#!/bin/bash   

echo -------------------------------------
echo installing... 
echo -------------------------------------

#current path
SCRIPT_FOLDER=$(cd "$(dirname "${BASH_SOURCE[0]}")" &> /dev/null && pwd)
echo 'current script path is' "$SCRIPT_FOLDER"

#get desktop folder
DESKTOP_FOLDER=$(xdg-user-dir DESKTOP)
echo 'desktop folder is' "$DESKTOP_FOLDER"

#get os arch
MACHINE_TYPE=$(uname -m)
echo 'architecture is' $MACHINE_TYPE

chmod +x "$SCRIPT_FOLDER/apps/ArubaSign"


echo create desktop shotcut
cat >  "$DESKTOP_FOLDER/ArubaSign.desktop" <<- EOM
[Desktop Entry] 
Version=1.0
Name=ArubaSign
Comment=Aruba Firma Digitale
Exec="$SCRIPT_FOLDER/apps/ArubaSign"
Icon=$SCRIPT_FOLDER/apps/images/ico.png
Terminal=false
Type=Application
Categories=Utility;Application;
EOM
chmod +x "$DESKTOP_FOLDER/ArubaSign.desktop"

#make all other executable
echo update permissions
chmod +x "$SCRIPT_FOLDER/apps/RootUpdater"
chmod +x "$SCRIPT_FOLDER/../ApkgTool"
chmod +x -R "$SCRIPT_FOLDER/../runtime/"

echo done

