/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.updater;

import com.sun.jna.Platform;
import esecurity.crypto.gui.properties.AppProperties;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.updater.Updater;
import esecurity.crypto.gui.updater.a;
import esecurity.desktop.observable.ObservableObject;
import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.sqllite.ArubaCdbManifestValidator;
import esecurity.tsl.sqllite.ManifestValidator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.provider.DownloadProgressNotifier;
import it.arubapec.ca.logger.utils.UpdateLogger;
import it.arubapec.ca.update.LinkedProperties;
import it.arubapec.ca.utils.FileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.AuthenticationException;
import javax.swing.JProgressBar;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class UpdaterUtils {
    private static final Pattern a = Pattern.compile("\\d+\\.\\d+\\.\\d+");
    private static final Pattern b = Pattern.compile("RC\\d+");
    private static final Pattern c = Pattern.compile("BETA\\d+");
    private static final Logger d = UpdateLogger.get();
    private static SHA1Digest e = new SHA1Digest();
    private static CertDb f = null;
    private static String g = null;
    private static String h = null;
    private static File i = null;
    private static ObservableObject<Updater.DownloadState> j = new ObservableObject<Updater.DownloadState>(Updater.DownloadState.NOT_INIT);

    public static ObservableObject<Updater.DownloadState> getDownloadState() {
        return j;
    }

    public static void setDownloadState(Updater.DownloadState downloadState) {
        j.setValue(downloadState);
    }

    public static boolean haveNewInstallerVersion(String stringArray, String stringArray2) throws URISyntaxException, IOException {
        if (stringArray2 == null || stringArray2.length() == 0) {
            d.warn("Impossibile verificare la versione corrente: URL per installer.info remoto non trovato");
            return false;
        }
        if (!Platform.isWindows()) {
            return false;
        }
        stringArray = new File((String)stringArray + "/installer.info");
        stringArray2 = new URL((String)stringArray2 + "/installer.info");
        UrlClient urlClient = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
        URLCredentials uRLCredentials = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
        RequestData requestData = new RequestData();
        byte[] byArray = urlClient.downloadUrl(stringArray2.toURI().toASCIIString(), requestData, uRLCredentials).getData();
        stringArray2 = (String[])byArray;
        if (byArray != null) {
            byte[] byArray2 = urlClient.downloadUrl(stringArray.toURI().toASCIIString(), requestData, uRLCredentials).getData();
            stringArray = (String[])byArray2;
            if (byArray2 != null) {
                stringArray2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])stringArray2)));
                stringArray = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])stringArray)));
                if (!(stringArray2 = stringArray2.readLine().trim().split("@"))[1].equals((stringArray = stringArray.readLine().trim().split("@"))[1]) || !stringArray2[3].equals(stringArray[3])) {
                    return true;
                }
            } else {
                d.info("File locale installer.info non trovato");
                return true;
            }
        }
        return false;
    }

    public static String getStableVersion(String object) throws URISyntaxException, IOException {
        if (object == null || ((String)object).length() == 0) {
            d.warn("Impossibile verificare la versione corrente: URL per installer.info remoto non trovato");
            return null;
        }
        object = new URL((String)object + "update_stable.conf");
        UrlClient urlClient = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
        URLCredentials uRLCredentials = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
        RequestData requestData = new RequestData();
        if ((object = urlClient.downloadUrl(((URL)object).toURI().toASCIIString(), requestData, uRLCredentials)).getData() != null && "OK".equals(object.getStatus())) {
            d.info("File stable trovato");
            return new String(object.getData(), "UTF-8");
        }
        return null;
    }

    public static Updater.Update haveNewVersion(String object, String string) throws MalformedURLException, URISyntaxException {
        object = new URL((String)object + "/updateVersion.info");
        Object object2 = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
        Object object3 = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
        Object object4 = new RequestData();
        object = ((URL)object).toURI().toASCIIString();
        d.info("current version is " + string + ". Check " + (String)object + " for updates");
        object = object2.downloadUrl((String)object, object4, (URLCredentials)object3);
        if ("KO".equals(object.getStatus()) && object.getStatus_code() == 404) {
            d.info("Remote file updateVersion.info not found");
            d.info("Update level FORCED");
            return Updater.Update.FORCED;
        }
        byte[] byArray = object.getData();
        object2 = byArray;
        if (byArray == null) {
            d.info("Error downloading updateVersion.info: " + object.getStatus() + " - " + object.getStatus_code());
            return Updater.Update.NO;
        }
        object = "";
        object3 = "";
        object4 = "";
        try {
            object2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])object2)));
            Throwable throwable = null;
            try {
                String[] stringArray;
                while ((stringArray = ((BufferedReader)object2).readLine()) != null) {
                    if (stringArray.trim().isEmpty()) continue;
                    stringArray = stringArray.split("=");
                    switch (stringArray[0]) {
                        case "version": {
                            object = stringArray[1];
                            break;
                        }
                        case "minComplianceVersion": {
                            object3 = stringArray[1];
                            break;
                        }
                        case "minVersion": {
                            object4 = stringArray[1];
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                    throw throwable4;
                }
            }
            ((BufferedReader)object2).close();
        }
        catch (IOException iOException) {
            d.error(iOException.getMessage(), (Throwable)iOException);
        }
        d.info("remoteVersion: " + (String)object);
        d.info("minComplianceVersion: " + (String)object3);
        d.info("minVersion: " + (String)object4);
        if (((String)object).isEmpty() || ((String)object3).isEmpty() || object4.isEmpty()) {
            d.info("Remote file updateVersion.info is empty");
            d.info("Update level FORCED");
            return Updater.Update.FORCED;
        }
        int n = UpdaterUtils.compareVersion(string, (String)object);
        if (n > 0) {
            d.info("Found RollBack version");
            d.info("Update level FORCED");
            return Updater.Update.FORCED;
        }
        if (n == 0) {
            return Updater.Update.STANDARD;
        }
        int n2 = UpdaterUtils.compareVersion(string, (String)object3);
        if (n2 >= 0) {
            d.info("Update level STANDARD");
            return Updater.Update.STANDARD;
        }
        int n3 = UpdaterUtils.compareVersion(string, (String)object4);
        if (n3 >= 0) {
            d.info("Update level CRITICAL");
            return Updater.Update.CRITICAL;
        }
        d.info("Update level FORCED");
        return Updater.Update.FORCED;
    }

    public static boolean haveNewVersion(String object, String object2, List<String> list) throws URISyntaxException, IOException {
        if (object2 == null || ((String)object2).length() == 0) {
            d.warn("Impossibile verificare la versione corrente: URL per update.info remoto non trovato");
            return false;
        }
        boolean bl = false;
        object = new File((String)object + "/update.info");
        object2 = new URL((String)object2 + "/update.info");
        Object object3 = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
        Object object4 = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
        String[] stringArray = new RequestData();
        byte[] byArray = object3.downloadUrl(((URL)object2).toURI().toASCIIString(), (RequestData)stringArray, (URLCredentials)object4).getData();
        object2 = byArray;
        if (byArray != null) {
            byte[] byArray2 = object3.downloadUrl(((File)object).toURI().toASCIIString(), (RequestData)stringArray, (URLCredentials)object4).getData();
            object = byArray2;
            if (byArray2 != null) {
                object2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])object2)));
                object = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])object)));
                object3 = ((BufferedReader)object2).readLine();
                object4 = ((BufferedReader)object).readLine();
                while (object3 != null && !((String)object3).trim().equals("") && object4 != null && !((String)object4).trim().equals("")) {
                    block10: {
                        String[] stringArray2;
                        block9: {
                            try {
                                stringArray = ((String)object3).split(":");
                                stringArray2 = ((String)object4).split(":");
                                if (list == null || !Arrays.asList(stringArray).contains("CHECKDISABLED") || !list.contains(stringArray[1])) break block9;
                            }
                            catch (Throwable throwable) {
                                ((BufferedReader)object2).readLine();
                                ((BufferedReader)object).readLine();
                                throw throwable;
                            }
                            object3 = ((BufferedReader)object2).readLine();
                            object4 = ((BufferedReader)object).readLine();
                            continue;
                        }
                        if (stringArray[0].trim().equals(stringArray2[0].trim())) break block10;
                        bl = true;
                        d.info("Trovata differenza hash righe");
                        d.info("  1:" + (String)object3);
                        d.info("  2:" + (String)object4);
                        object3 = ((BufferedReader)object2).readLine();
                        object4 = ((BufferedReader)object).readLine();
                        break;
                    }
                    object3 = ((BufferedReader)object2).readLine();
                    object4 = ((BufferedReader)object).readLine();
                }
                object3 = object3 != null ? object3 : "";
                Object object5 = object4 = object4 != null ? object4 : "";
                if (!bl && !((String)object3).trim().equals(((String)object4).trim())) {
                    bl = true;
                    d.info("Nuova versione");
                }
            } else {
                d.info("File delle versioni update.info non trovato!");
                bl = true;
            }
        }
        return bl;
    }

    public static void prepareImage(String object, String object2, String string) throws MalformedURLException, URISyntaxException, IOException, Exception {
        LinkedHashMap<String, a> linkedHashMap = new LinkedHashMap<String, a>();
        Object object3 = new File((String)object + "/update.info");
        Object object4 = new File((String)object2 + "/action.info");
        Object object5 = new File((String)object2 + "/update.info");
        Object object6 = new URL(string + "/update.info");
        URL uRL = new URL(string + "/update.sign");
        object2 = new File((String)object2);
        String string2 = ((File)object2).toURI().toASCIIString() + "/";
        if (UpdaterUtils.haveNewVersion((String)object, string, null)) {
            boolean bl;
            Object object7;
            Object object8;
            Object object9;
            if (!((File)object2).exists()) {
                ((File)object2).mkdirs();
            }
            object2 = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
            Object object10 = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
            object2 = object2.getInputStream((URL)object6, (URLCredentials)object10);
            object6 = new PrintStream(new FileOutputStream((File)object5));
            object10 = new BufferedReader(new InputStreamReader((InputStream)object2));
            String[] stringArray = ((BufferedReader)object10).readLine();
            while (stringArray != null && !stringArray.isEmpty()) {
                block27: {
                    try {
                        ((PrintStream)object6).println((String)stringArray);
                        if (!stringArray.contains(":")) break block27;
                        stringArray = stringArray.split(":");
                        object9 = stringArray[1];
                        object8 = stringArray[0];
                        object7 = new ArrayList<String>();
                        for (int i = 2; i < stringArray.length; ++i) {
                            object7.add(stringArray[i]);
                        }
                        linkedHashMap.put((String)object9, new a((String)object8, (List<String>)object7));
                    }
                    catch (Throwable throwable) {
                        ((BufferedReader)object10).readLine();
                        throw throwable;
                    }
                }
                stringArray = ((BufferedReader)object10).readLine();
            }
            ((BufferedReader)object10).close();
            ((InputStream)object2).close();
            ((PrintStream)object6).close();
            try {
                bl = UpdaterUtils.a(uRL, (File)object5);
            }
            catch (Exception exception) {
                d.error("Impossibile controllare l'integrit\u00e0 del file " + object5 + " con il seguente url: " + uRL);
                throw exception;
            }
            if (!bl) {
                d.error("Gli HMAC non corrispondono!!");
                throw new AuthenticationException("Il file " + ((File)object5).getCanonicalPath() + " \u00e8 corrotto");
            }
            d.info("Gli HMAC sono uguali: l'update.info \u00e8 valido!");
            object9 = null;
            try {
                d.info("File versione attuale:" + ((File)object3).toURI().toASCIIString());
                object9 = new FileInputStream((File)object3);
            }
            catch (IOException iOException) {
                d.error("Errore apertura file", (Throwable)iOException);
            }
            if (((File)object4).exists()) {
                ((File)object4).delete();
            }
            object8 = new PrintStream(new FileOutputStream((File)object4));
            if (object9 != null) {
                object7 = new BufferedReader(new InputStreamReader((InputStream)object9));
                String string3 = ((BufferedReader)object7).readLine();
                while (string3 != null) {
                    if (string3.contains(":")) {
                        d.info("processo linea locale >>> " + string3);
                        object2 = string3.split(":");
                        object3 = object2[0];
                        object2 = object2[1];
                        object4 = (a)((HashMap)linkedHashMap).get(object2);
                        if (object4 != null) {
                            object5 = ((a)object4).a();
                            if (object5 != null) {
                                if (!((String)object5).equals(object3)) {
                                    object3 = string2 + (String)object2;
                                    object6 = string + (String)object2;
                                    d.info("Download >>> " + (String)object6);
                                    UpdaterUtils.a((String)object6, (String)object5, (String)object3);
                                    UpdaterUtils.a((String)object2, ((a)object4).b(), (PrintStream)object8);
                                    linkedHashMap.remove(object2);
                                    if (((String)object2).equals("runtime.info")) {
                                        object2 = (String)object + "/jre32.tar.gz";
                                        if (Platform.is64Bit()) {
                                            object2 = (String)object + "/jre64.tar.gz";
                                        }
                                        if (!UpdaterUtils.downloadRuntime((String)object3, (String)object2)) {
                                            object = new File((String)object2);
                                            if (((File)object).exists()) {
                                                ((File)object).delete();
                                            }
                                            d.error("Impossibile scaricare il nuovo runtime");
                                            throw new IOException("Impossibile scaricare il nuovo runtime");
                                        }
                                        d.info("nuovo runtime scaricato");
                                    }
                                } else {
                                    linkedHashMap.remove(object2);
                                }
                            } else {
                                d.info("DELETE:" + (String)object2);
                                ((PrintStream)object8).println("DELETE:" + (String)object2);
                            }
                        } else {
                            d.info("Remote file for " + (String)object2 + " not found");
                            d.info("DELETE:" + (String)object2);
                            ((PrintStream)object8).println("DELETE:" + (String)object2);
                        }
                    }
                    string3 = ((BufferedReader)object7).readLine();
                }
                ((BufferedReader)object7).close();
                ((InputStream)object9).close();
            } else {
                d.error("Impossibile aprire versione attuale del file");
            }
            for (String string4 : ((HashMap)linkedHashMap).keySet()) {
                object2 = string2 + string4;
                object3 = string + string4;
                UpdaterUtils.a((String)object3, ((a)((HashMap)linkedHashMap).get(string4)).a(), (String)object2);
                object2 = (a)((HashMap)linkedHashMap).get(string4);
                UpdaterUtils.a(string4, ((a)object2).b(), (PrintStream)object8);
            }
            ((PrintStream)object8).close();
        }
    }

    public static Map<String, DownloadFile> prepareInstallerMap(String string, String string2, String string3) throws IOException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, URISyntaxException, UnrecoverableKeyException {
        Object object;
        HashMap<String, DownloadFile> hashMap = new HashMap<String, DownloadFile>();
        Object object2 = new URL(string2 + "/installer.info");
        UrlClient urlClient = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
        URLCredentials uRLCredentials = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
        object2 = urlClient.getInputStream((URL)object2, uRLCredentials);
        object2 = new BufferedReader(new InputStreamReader((InputStream)object2));
        int n = 0;
        while ((object = ((BufferedReader)object2).readLine()) != null) {
            d.info((String)object);
            if (n != 0) continue;
            object = ((String)object).split("@");
            String string4 = object[0] + "-" + object[1] + object[2];
            string4 = string4 + ("32".equals(string3) ? "x86" : "x64");
            String string5 = string2 + "/" + string4 + ".exe";
            long l = UpdaterUtils.a(string5, urlClient);
            if (l == -1L) {
                string4 = object[0] + "-" + object[1] + object[2];
                string5 = string2 + "/" + string4 + ".exe";
                l = UpdaterUtils.a(string5, urlClient);
            }
            object = new File(string + File.separator + string4 + ".exe");
            Object object3 = new BufferedReader(new InputStreamReader(urlClient.getInputStream(new URL(string5 + ".md5"), uRLCredentials)));
            object3 = ((BufferedReader)object3).readLine();
            g = string4 + ".exe";
            if (((File)object).exists() && FileUtils.getMD5((File)object).equals(object3)) {
                d.info("File " + ((File)object).getName() + " present, skip download");
            } else {
                d.info(string5 + " : " + l);
                hashMap.put(string5, new DownloadFile(string5, (File)object, (String)object3, l));
            }
            ++n;
        }
        return hashMap;
    }

    private static int a(String string, UrlClient urlClient) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        if (string.startsWith("file")) {
            return (int)new File(string).length();
        }
        return urlClient.getContentLengthLong(string, null).intValue();
    }

    public static Map<String, DownloadFile> prepareDownloadMap(String object, String object2, String string) throws MalformedURLException, URISyntaxException, IOException, Exception {
        String string2;
        boolean bl;
        Object object3;
        Object object4;
        Object object5;
        String string3;
        File file;
        Object object6;
        File file2;
        File file3;
        File file4;
        Object object7;
        LinkedHashMap<String, a> linkedHashMap;
        HashMap<String, DownloadFile> hashMap;
        block64: {
            block65: {
                boolean bl2;
                d.info("Prepare download map...");
                d.info("From " + string);
                hashMap = new HashMap<String, DownloadFile>();
                linkedHashMap = new LinkedHashMap<String, a>();
                object7 = new File((String)object + "/update.info");
                object = new File((String)object + "/disabled.info");
                file4 = new File((String)object2 + "/action.info");
                file3 = new File((String)object2 + "/update.info");
                file2 = new File((String)object2 + "/updateOLD.info");
                Object object8 = new URL(string + "/update.info");
                object6 = new URL(string + "/update.sign");
                file = new File((String)object2);
                string3 = file.toURI().toASCIIString() + "/";
                object5 = null;
                if (((File)object).exists()) {
                    object5 = Files.readAllLines(((File)object).toPath());
                }
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file2.exists()) {
                    file2.delete();
                }
                if (file3.exists()) {
                    FileUtils.copyfile((File)file3, (File)file2);
                }
                object = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
                Object object9 = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
                object = object.getInputStream((URL)object8, (URLCredentials)object9);
                object8 = new PrintStream(new FileOutputStream(file3));
                object9 = new BufferedReader(new InputStreamReader((InputStream)object));
                Object object10 = ((BufferedReader)object9).readLine();
                while (object10 != null && !object10.equals("")) {
                    block60: {
                        String string4;
                        block61: {
                            ((PrintStream)object8).println((String)object10);
                            if (!object10.contains(":")) break block60;
                            object10 = object10.split(":");
                            string4 = object10[1];
                            object4 = object10[0];
                            if (object5 == null || !Arrays.asList(object10).contains("CHECKDISABLED") || !object5.contains(string4)) break block61;
                            object10 = ((BufferedReader)object9).readLine();
                            continue;
                        }
                        try {
                            object3 = new ArrayList<String>();
                            for (int i = 2; i < ((String[])object10).length; ++i) {
                                object3.add(object10[i]);
                            }
                            linkedHashMap.put(string4, new a((String)object4, (List<String>)object3));
                        }
                        catch (Throwable throwable) {
                            ((BufferedReader)object9).readLine();
                            throw throwable;
                        }
                    }
                    object10 = ((BufferedReader)object9).readLine();
                }
                ((BufferedReader)object9).close();
                ((InputStream)object).close();
                ((PrintStream)object8).close();
                try {
                    bl2 = UpdaterUtils.a((URL)object6, file3);
                }
                catch (Exception exception) {
                    d.error("Impossibile controllare l'integrit\u00e0 del file " + file3 + " con il seguente url: " + object6);
                    throw exception;
                }
                if (!bl2) {
                    d.error("Gli HMAC non corrispondono!!");
                    throw new AuthenticationException("Il file " + file3.getCanonicalPath() + " \u00e8 corrotto");
                }
                d.info("Gli HMAC sono uguali: l'update.info \u00e8 valido!");
                bl = true;
                if (!file2.exists() || !FileUtils.contentEquals((File)file3, (File)file2)) break block64;
                d.info("E' presente il file updateOLD.info verifico che il precedente download sia andato a buon fine");
                if (!file4.exists()) break block65;
                object4 = null;
                object3 = null;
                try {
                    d.info("E' presente anche il file action.info ");
                    object4 = new BufferedReader(new InputStreamReader(new FileInputStream(file3)));
                    String string5 = ((BufferedReader)object4).readLine();
                    object = new HashMap<String, String>();
                    boolean bl3 = false;
                    while (string5 != null && !string5.equals("") && !bl3) {
                        block62: {
                            try {
                                if (string5.contains(":")) {
                                    object6 = string5.split(":");
                                    if (((String[])object6).length > 1) {
                                        ((HashMap)object).put(object6[1], object6[0]);
                                    } else {
                                        bl3 = true;
                                        d.error("La seguente linea del file " + file3.getCanonicalPath() + " non \u00e8 conforme (" + ((String[])object6).length + "): \r\n" + string5);
                                    }
                                    break block62;
                                }
                                bl3 = true;
                                d.error("La seguente linea del file " + file3.getCanonicalPath() + " non \u00e8 conforme: \r\n" + string5);
                            }
                            catch (Throwable throwable) {
                                ((BufferedReader)object4).readLine();
                                throw throwable;
                            }
                        }
                        string5 = ((BufferedReader)object4).readLine();
                    }
                    object3 = new BufferedReader(new InputStreamReader(new FileInputStream(file4)));
                    object6 = ((BufferedReader)object3).readLine();
                    while (object6 != null && !object6.equals("") && !bl3) {
                        block63: {
                            try {
                                if (object6.contains(":")) {
                                    object5 = object6.split(":");
                                    if (((String[])object5).length > 1) {
                                        object6 = object5[1];
                                        if (!((HashMap)object).containsKey(object6)) break block63;
                                        object9 = new File((String)object2 + File.separator + (String)object6);
                                        if (((File)object9).exists()) {
                                            String string6 = (String)((HashMap)object).get(object6);
                                            try {
                                                string2 = UpdaterUtils.a((File)object9);
                                                if (string2.isEmpty() || string6 == null || !string6.equals(string2)) {
                                                    d.error("L'hash del file " + object9 + " non matcha. Effettuo di nuovo il download");
                                                    bl3 = true;
                                                    break block63;
                                                }
                                                d.debug("L'hash del file " + object9 + " \u00e8 corretto " + string2);
                                            }
                                            catch (Throwable throwable) {
                                                d.error("Impossibile verificare il file " + object9 + " effettuo il download", throwable);
                                                bl3 = true;
                                            }
                                            break block63;
                                        }
                                        bl3 = true;
                                        d.error("Impossibile verificare il file " + object9 + " effettuo il download");
                                        break block63;
                                    }
                                    bl3 = true;
                                    d.error("La seguente linea del file " + file4.getCanonicalPath() + " non \u00e8 conforme: \\r\\n " + (String)object6);
                                    break block63;
                                }
                                bl3 = true;
                                d.error("La seguente linea del file " + file4.getCanonicalPath() + " non \u00e8 conforme: \\r\\n " + (String)object6);
                            }
                            catch (Throwable throwable) {
                                ((BufferedReader)object3).readLine();
                                throw throwable;
                            }
                        }
                        object6 = ((BufferedReader)object3).readLine();
                    }
                    if (!bl3) {
                        d.info("Non ho rilevato alcun errore, tutti i file sono stati scaricati. Non effettuo il download");
                        bl = false;
                    }
                    ((BufferedReader)object3).close();
                }
                catch (Exception exception) {
                    d.error("Errore durante la verifica dei file precedentemente scaricati " + exception.getMessage());
                    break block64;
                }
                finally {
                    if (object3 != null) {
                        ((BufferedReader)object3).close();
                    }
                    if (object4 != null) {
                        ((BufferedReader)object4).close();
                    }
                }
                ((BufferedReader)object4).close();
                break block64;
            }
            d.info("il file action.info non esiste, effettuo un nuovo download");
        }
        if (!bl) {
            if (file2.exists() && FileUtils.contentEquals((File)file3, (File)file2)) {
                file2.delete();
            }
        } else {
            object4 = Files.readAllBytes(Paths.get(file3.getCanonicalPath(), new String[0]));
            d.info("Eliminazione della cartella " + file);
            FileUtils.emptyDir((File)file, (boolean)false);
            try {
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception exception) {
                d.error("Errore nel ricreare la cartella " + file + " " + exception.getMessage());
            }
            try {
                d.info("Ripristino update.info temp");
                Files.write(Paths.get(file3.getCanonicalPath(), new String[0]), (byte[])object4, new OpenOption[0]);
                d.info("update.info temp ripristinato");
            }
            catch (Exception exception) {
                d.error("Errore nel ripristinare update.info temp " + exception.getMessage());
            }
            object3 = null;
            try {
                d.info("File versione attuale:" + ((File)object7).toURI().toASCIIString());
                object3 = new FileInputStream((File)object7);
            }
            catch (IOException iOException) {
                d.error("Errore apertura file: " + iOException.getMessage());
            }
            if (file4.exists()) {
                file4.delete();
            }
            PrintStream printStream = new PrintStream(new FileOutputStream(file4));
            if (object3 != null) {
                object = new BufferedReader(new InputStreamReader((InputStream)object3));
                String string7 = ((BufferedReader)object).readLine();
                while (string7 != null) {
                    if (string7.contains(":")) {
                        d.info("processo linea locale >>> " + string7);
                        object6 = string7.split(":");
                        object5 = object6[0];
                        object6 = object6[1];
                        boolean bl4 = true;
                        if (string7.contains("CHECK32") && (System.getProperty("os.arch").contains("amd64") || System.getProperty("os.arch").contains("x86_64") || System.getProperty("os.arch").contains("ia64"))) {
                            bl4 = false;
                        } else if (string7.contains("CHECK64") && !System.getProperty("os.arch").contains("amd64") && !System.getProperty("os.arch").contains("x86_64") && !System.getProperty("os.arch").contains("ia64")) {
                            bl4 = false;
                        }
                        a a2 = (a)((HashMap)linkedHashMap).get(object6);
                        if (a2 != null) {
                            string2 = a2.a();
                            object2 = a2.b();
                            if (string2 != null) {
                                if (!string2.equals(object5) && bl4) {
                                    object7 = string + (String)object6;
                                    d.info("Download >>> " + (String)object7);
                                    UpdaterUtils.a(printStream, (String)object7, string2, (List<String>)object2, string3, (String)object6, hashMap);
                                } else {
                                    linkedHashMap.remove(object6);
                                }
                            } else {
                                d.info("DELETE:" + (String)object6);
                                printStream.println("DELETE:" + (String)object6);
                            }
                        } else {
                            d.info("DELETE:" + (String)object6);
                            printStream.println("DELETE:" + (String)object6);
                        }
                    }
                    string7 = ((BufferedReader)object).readLine();
                }
                ((BufferedReader)object).close();
                ((InputStream)object3).close();
            } else {
                d.error("Impossibile aprire versione attuale del file");
            }
            for (String string8 : ((HashMap)linkedHashMap).keySet()) {
                object6 = string + string8;
                UpdaterUtils.a(printStream, (String)object6, ((a)((HashMap)linkedHashMap).get(string8)).a(), ((a)((HashMap)linkedHashMap).get(string8)).b(), string3, string8, hashMap);
            }
            printStream.close();
        }
        return hashMap;
    }

    private static boolean a(String string, String string2, String object) throws IOException {
        d.info("url:" + string);
        object = URLDecoder.decode(new URL((String)object).getFile(), "UTF8");
        d.info("to:" + (String)object);
        object = new File((String)object);
        if (((File)object).exists() && UpdaterUtils.a((File)object).equals(string2)) {
            return true;
        }
        ((File)object).getParentFile().mkdirs();
        ((File)object).createNewFile();
        if (((File)object).getAbsolutePath().endsWith(".sh") || ((File)object).getAbsolutePath().endsWith("updater")) {
            ((File)object).setExecutable(true);
        }
        FileOutputStream fileOutputStream = new FileOutputStream((File)object);
        UrlClient urlClient = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
        URLCredentials uRLCredentials = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
        InputStream inputStream = null;
        try {
            inputStream = urlClient.getInputStream(new URL(string), uRLCredentials);
        }
        catch (URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
            d.error(exception.getMessage(), (Throwable)exception);
        }
        e.reset();
        Object object2 = new byte[1024];
        int n = inputStream.read((byte[])object2);
        while (n != -1) {
            e.update(object2, 0, n);
            fileOutputStream.write((byte[])object2, 0, n);
            n = inputStream.read((byte[])object2);
        }
        object2 = new byte[e.getDigestSize()];
        e.doFinal(object2, 0);
        object2 = new String(Hex.encode((byte[])object2));
        inputStream.close();
        fileOutputStream.close();
        if (object2.equals(string2)) {
            return true;
        }
        ((File)object).delete();
        fileOutputStream = new FileOutputStream((File)object);
        try {
            inputStream = urlClient.getInputStream(new URL(string), uRLCredentials);
        }
        catch (URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
            d.error(exception.getMessage(), (Throwable)exception);
        }
        e.reset();
        object2 = new byte[1024];
        n = inputStream.read((byte[])object2);
        while (n != -1) {
            e.update(object2, 0, n);
            fileOutputStream.write((byte[])object2, 0, n);
            n = inputStream.read((byte[])object2);
        }
        object2 = new byte[e.getDigestSize()];
        e.doFinal(object2, 0);
        String string3 = new String(Hex.encode((byte[])object2));
        object2 = string3;
        if (!string3.equals(string2)) {
            d.error("Errore hash file scaricato: atteso=" + (String)object2 + ",  calcolato=" + string2);
        }
        inputStream.close();
        fileOutputStream.close();
        return true;
    }

    private static void a(PrintStream printStream, String string, String string2, List<String> list, String object, String string3, Map<String, DownloadFile> map) throws IOException {
        if (map.containsKey(string)) {
            return;
        }
        object = URLDecoder.decode(new URL((String)object + string3).getFile(), "UTF8");
        d.info("to:" + (String)object);
        object = new File((String)object);
        d.info("url:" + string);
        if (((File)object).exists() && UpdaterUtils.a((File)object).equals(string2)) {
            return;
        }
        try {
            UrlClient urlClient = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), UpdateLogger.get());
            long l = string.startsWith("file") ? new File(string).length() : urlClient.getContentLengthLong(string, null).longValue();
            d.info(string + " : " + l);
            map.put(string, new DownloadFile(string, (File)object, string2, l));
            UpdaterUtils.a(string3, list, printStream);
            return;
        }
        catch (KeyStoreException keyStoreException) {
            d.error(keyStoreException.getMessage());
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            d.error(noSuchAlgorithmException.getMessage());
            return;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            d.error(unrecoverableKeyException.getMessage());
            return;
        }
        catch (KeyManagementException keyManagementException) {
            d.error(keyManagementException.getMessage());
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            d.error(uRISyntaxException.getMessage());
            return;
        }
    }

    public static boolean applyUpdate(String object, String object2, JProgressBar jProgressBar) throws IOException {
        boolean bl = false;
        File file = new File((String)object);
        File file2 = new File((String)object2);
        object = new File((String)object + "/update.info");
        Object object3 = new File((String)object2 + "/action.info");
        object2 = new File((String)object2 + "/update.info");
        if (((File)object3).exists() && ((File)object2).exists()) {
            FileInputStream fileInputStream = new FileInputStream((File)object3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            Object object4 = bufferedReader.readLine();
            int n = 0;
            while (object4 != null) {
                object4 = bufferedReader.readLine();
                ++n;
            }
            fileInputStream.close();
            bufferedReader.close();
            if (jProgressBar != null) {
                jProgressBar.setMaximum(n);
                jProgressBar.setMinimum(0);
            }
            fileInputStream = new FileInputStream((File)object3);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            object4 = bufferedReader.readLine();
            while (object4 != null) {
                if (((String)object4).contains(":")) {
                    object3 = ((String)object4).split(":");
                    if (object3[0].equals("COPY")) {
                        object4 = file.toURI().toASCIIString() + object3[1];
                        object4 = URLDecoder.decode(new URL((String)object4).getFile(), "UTF8");
                        object4 = new File((String)object4);
                        ((File)object4).delete();
                        object3 = file2.toURI().toASCIIString() + object3[1];
                        object3 = URLDecoder.decode(new URL((String)object3).getFile(), "UTF8");
                        object3 = new File((String)object3);
                        if (((File)object3).exists()) {
                            ((File)object4).getParentFile().mkdirs();
                            if (!((File)object3).renameTo((File)object4)) {
                                FileUtils.copyfile((File)object3, (File)object4);
                            }
                        }
                    } else if (object3[0].equals("DELETE")) {
                        object4 = file.toURI().toASCIIString() + object3[1];
                        object4 = URLDecoder.decode(new URL((String)object4).getFile(), "UTF8");
                        if (!((File)(object4 = new File((String)object4))).getName().equals("gui.conf")) {
                            ((File)object4).delete();
                        }
                    } else {
                        throw new IOException("Comando non riconosciuto");
                    }
                }
                if (jProgressBar != null) {
                    JProgressBar jProgressBar2 = jProgressBar;
                    jProgressBar2.setValue(jProgressBar2.getValue() + 1);
                }
                object4 = bufferedReader.readLine();
            }
            fileInputStream.close();
            bufferedReader.close();
            ((File)object).delete();
            if (!((File)object2).renameTo((File)object)) {
                FileUtils.copyfile((File)object2, (File)object);
            }
            bl = FileUtils.emptyDir((File)file2, (boolean)false);
        }
        return bl;
    }

    public static boolean downloadRuntime(String string, String string2) {
        boolean bl;
        block26: {
            FileInputStream fileInputStream = null;
            bl = false;
            try {
                Object object = new Properties();
                string = URLDecoder.decode(new URL(string).getFile(), "UTF8");
                d.info("file:" + string);
                fileInputStream = new FileInputStream(string);
                ((Properties)object).load(fileInputStream);
                string = ((Properties)object).getProperty("url");
                d.info("url_base:" + string);
                System.getProperty("java.version");
                if (Platform.isWindows()) {
                    if (Platform.is64Bit()) {
                        ((Properties)object).getProperty("win64version");
                        object = ((Properties)object).getProperty("win64hash");
                        string = string + "/win/jre64.tar.gz";
                        bl = UpdaterUtils.a(string, (String)object, new File(string2).toURI().toASCIIString());
                    } else {
                        ((Properties)object).getProperty("win32version");
                        object = ((Properties)object).getProperty("win32hash");
                        string = string + "/win/jre32.tar.gz";
                        bl = UpdaterUtils.a(string, (String)object, new File(string2).toURI().toASCIIString());
                    }
                    break block26;
                }
                if (Platform.isLinux()) {
                    if (Platform.is64Bit()) {
                        ((Properties)object).getProperty("lin64version");
                        object = ((Properties)object).getProperty("lin64hash");
                        string = string + "/linux/jre64.tar.gz";
                        bl = UpdaterUtils.a(string, (String)object, new File(string2).toURI().toASCIIString());
                    } else {
                        ((Properties)object).getProperty("lin32version");
                        object = ((Properties)object).getProperty("lin32hash");
                        string = string + "/linux/jre32.tar.gz";
                        bl = UpdaterUtils.a(string, (String)object, new File(string2).toURI().toASCIIString());
                    }
                    break block26;
                }
                return Platform.isMac();
                {
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                d.error(fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                d.error(iOException.getMessage(), (Throwable)iOException);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    d.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
        }
        return bl;
    }

    public static void getRuntimeFile(String object, String string, String string2) throws IOException {
        LinkedProperties linkedProperties = new LinkedProperties();
        if (((File)(object = new File((String)object))).exists()) {
            File file = new File(((File)object).getAbsolutePath() + File.separator + "win" + File.separator + "jre32.tar.gz");
            File file2 = new File(((File)object).getAbsolutePath() + File.separator + "win" + File.separator + "jre64.tar.gz");
            File file3 = new File(((File)object).getAbsolutePath() + File.separator + "linux" + File.separator + "jre32.tar.gz");
            object = new File(((File)object).getAbsolutePath() + File.separator + "linux" + File.separator + "jre64.tar.gz");
            if (!file.exists()) {
                throw new IOException("32 Bit windows not found");
            }
            if (!file2.exists()) {
                throw new IOException("64 Bit windows not found");
            }
            if (!file3.exists()) {
                throw new IOException("32 Bit linux not found");
            }
            if (!((File)object).exists()) {
                throw new IOException("64 Bit windows not found");
            }
            linkedProperties.put((Object)"url", (Object)string);
            linkedProperties.put((Object)"win32version", (Object)("Sample " + System.getProperty("java.version")));
            linkedProperties.put((Object)"win32hash", (Object)UpdaterUtils.a(file));
            linkedProperties.put((Object)"win64version", (Object)("Sample " + System.getProperty("java.version")));
            linkedProperties.put((Object)"win64hash", (Object)UpdaterUtils.a(file2));
            linkedProperties.put((Object)"lin32version", (Object)("Sample " + System.getProperty("java.version")));
            linkedProperties.put((Object)"lin32hash", (Object)UpdaterUtils.a(file3));
            linkedProperties.put((Object)"lin64version", (Object)("Sample " + System.getProperty("java.version")));
            linkedProperties.put((Object)"lin64hash", (Object)UpdaterUtils.a((File)object));
            object = new FileOutputStream(string2);
            linkedProperties.store((OutputStream)object, null);
            ((FileOutputStream)object).close();
            return;
        }
        throw new IOException("Base Dir not Found");
    }

    private static String a(File object) throws IOException {
        object = new FileInputStream((File)object);
        e.reset();
        Object object2 = new byte[1024];
        int n = ((FileInputStream)object).read((byte[])object2);
        while (n != -1) {
            e.update(object2, 0, n);
            n = ((FileInputStream)object).read((byte[])object2);
        }
        object2 = new byte[e.getDigestSize()];
        e.doFinal(object2, 0);
        object2 = new String(Hex.encode((byte[])object2));
        ((FileInputStream)object).close();
        return object2;
    }

    public static void downloadFileFromURL2(DownloadFile object, DownloadProgressNotifier downloadProgressNotifier, boolean bl) throws IOException {
        d.debug("Inizio downloadFileFromURL2");
        File file = ((DownloadFile)object).getOutputFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            d.info("Trovato file " + file.toPath() + " incompleto, procedo alla cancellazione");
            Files.delete(file.toPath());
        }
        file.createNewFile();
        if (file.getAbsolutePath().endsWith(".sh") || file.getAbsolutePath().endsWith(".bat") || file.getAbsolutePath().contains("updater32") || file.getAbsolutePath().contains("updater64") || file.getAbsolutePath().contains("sign") || file.getAbsolutePath().contains("sign32") || file.getAbsolutePath().contains("sign64") || file.getAbsolutePath().contains("verify") || file.getAbsolutePath().contains("verify32") || file.getAbsolutePath().contains("verify64") || file.getAbsolutePath().endsWith("updater")) {
            file.setExecutable(true);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream fileOutputStream;
                block26: {
                    fileOutputStream = new FileOutputStream(file);
                    Throwable throwable2 = null;
                    try {
                        String string = ((DownloadFile)object).getHash();
                        UrlClient urlClient = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
                        URLCredentials uRLCredentials = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
                        if (bl) {
                            UpdaterUtils.setDownloadState(Updater.DownloadState.DOWNLOADING);
                            d.info("download state:" + (Object)((Object)Updater.DownloadState.DOWNLOADING));
                        }
                        if (!(object = urlClient.downloadHttpUrl(((DownloadFile)object).getStrUrl(), new RequestData(), uRLCredentials, (OutputStream)fileOutputStream, downloadProgressNotifier)).getStatus().equals("OK")) {
                            throw new IOException("Errore download file: " + object.getStatusMessage());
                        }
                        e.reset();
                        object = new byte[4096];
                        int n = ((InputStream)fileInputStream).read((byte[])object);
                        while (n != -1) {
                            e.update((byte[])object, 0, n);
                            n = ((InputStream)fileInputStream).read((byte[])object);
                        }
                        object = new byte[e.getDigestSize()];
                        e.doFinal((byte[])object, 0);
                        object = new String(Hex.encode((byte[])object));
                        if (((String)object).equals(string) || FileUtils.getMD5((File)file).equals(string)) break block26;
                        throw new IOException("Errore hash file scaricato: atteso=" + (String)object + ",  calcolato=" + string);
                    }
                    catch (Throwable throwable3) {
                        try {
                            Throwable throwable4 = throwable3;
                            throwable2 = throwable3;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 != null) {
                                try {
                                    ((OutputStream)fileOutputStream).close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                ((OutputStream)fileOutputStream).close();
                            }
                            throw throwable5;
                        }
                    }
                }
                ((OutputStream)fileOutputStream).close();
            }
            catch (Throwable throwable7) {
                try {
                    Throwable throwable8 = throwable7;
                    throwable = throwable7;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    if (throwable != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        ((InputStream)fileInputStream).close();
                    }
                    throw throwable9;
                }
            }
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            if (bl) {
                UpdaterUtils.setDownloadState(Updater.DownloadState.COMPLETE_KO);
                d.info("download state:" + (Object)((Object)Updater.DownloadState.COMPLETE_KO));
            }
            throw new IOException("Errore download file da URL >>> " + iOException.getMessage());
        }
        if (bl) {
            UpdaterUtils.setDownloadState(Updater.DownloadState.COMPLETE_OK);
            d.info("download state:" + (Object)((Object)Updater.DownloadState.COMPLETE_OK));
        }
        d.debug("fine downloadFileFromURL2");
    }

    private static void a(String string, List<String> object, PrintStream printStream) {
        if (object == null || object.isEmpty()) {
            printStream.println("COPY:" + string);
            d.info("COPY:" + string);
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            String string2;
            String string3 = (String)object.next();
            if (string3.equalsIgnoreCase("CHECKDISABLED")) continue;
            if (string3.equalsIgnoreCase("CHECK32")) {
                d.info("JVM architecture: " + System.getProperty("os.arch"));
                if (System.getProperty("os.arch").contains("amd64") || System.getProperty("os.arch").contains("x86_64")) break;
                if (!System.getProperty("os.arch").contains("ia64")) continue;
                return;
            }
            if (string3.equalsIgnoreCase("CHECK64")) {
                d.info("JVM architecture: " + System.getProperty("os.arch"));
                if (!System.getProperty("os.arch").contains("amd64") && !System.getProperty("os.arch").contains("x86_64") && !System.getProperty("os.arch").contains("ia64")) break;
                continue;
            }
            if (string3.toUpperCase().startsWith("EXEC")) {
                string2 = "EXEC(\\(([^\\?]*)?(\\?(.*))?\\))?";
                object2 = Pattern.compile("EXEC(\\(([^\\?]*)?(\\?(.*))?\\))?");
                if (((Matcher)(object2 = ((Pattern)object2).matcher(string3))).matches()) {
                    string3 = ((Matcher)object2).group(2);
                    string2 = ((Matcher)object2).group(4);
                    printStream.println("EXEC:" + (string3 == null || string3.isEmpty() ? string : string3) + (string2 == null || string2.length() == 0 ? "" : ":" + string2));
                    d.info("EXEC:" + (string3 == null || string3.isEmpty() ? string : string3) + (string2 == null || string2.length() == 0 ? "" : ":" + string2));
                    continue;
                }
                throw new RuntimeException("Azione con sintassi non corretta: " + string3 + ". Deve rispettare la regex " + string2);
            }
            if (string3.toUpperCase().startsWith("ADMINEXEC")) {
                string2 = "ADMINEXEC(\\(([^\\?]*)?(\\?(.*))?\\))?";
                object2 = Pattern.compile("ADMINEXEC(\\(([^\\?]*)?(\\?(.*))?\\))?");
                if (((Matcher)(object2 = ((Pattern)object2).matcher(string3))).matches()) {
                    string3 = ((Matcher)object2).group(2);
                    string2 = ((Matcher)object2).group(4);
                    printStream.println("ADMINEXEC:" + (string3 == null || string3.isEmpty() ? string : string3) + (string2 == null || string2.length() == 0 ? "" : ":" + string2));
                    d.info("ADMINEXEC:" + (string3 == null || string3.isEmpty() ? string : string3) + (string2 == null || string2.length() == 0 ? "" : ":" + string2));
                    continue;
                }
                throw new RuntimeException("Azione con sintassi non corretta: " + string3 + ". Deve rispettare la regex " + string2);
            }
            if (string3.toUpperCase().startsWith("DELETE")) {
                string2 = "DELETE(\\((.*)\\))?";
                object2 = Pattern.compile("DELETE(\\((.*)\\))?");
                if (((Matcher)(object2 = ((Pattern)object2).matcher(string3))).matches()) {
                    string3 = ((Matcher)object2).group(2);
                    printStream.println("DELETE:" + (string3 == null || string3.isEmpty() ? string : string3));
                    d.info("DELETE:" + (string3 == null || string3.isEmpty() ? string : string3));
                    continue;
                }
                throw new RuntimeException("Azione con sintassi non corretta: " + string3 + ". Deve rispettare la regex " + string2);
            }
            if (string3.toUpperCase().equals("COPYSYS32")) {
                string2 = System.getenv("WINDIR") + "\\System32";
                string2 = string2.replace(":", "%duepunti%");
                printStream.println("COPY:" + string + ":" + string2);
                d.info("COPY:" + string + ":" + string2);
                continue;
            }
            if (string3.toUpperCase().equals("COPYSYS64")) {
                string2 = System.getenv("WINDIR") + "\\SysWOW64";
                string2 = string2.replace(":", "%duepunti%");
                printStream.println("COPY:" + string + ":" + string2);
                d.info("COPY:" + string + ":" + string2);
                continue;
            }
            if (string3.toUpperCase().startsWith("COPY[@") && string3.endsWith("]")) {
                string2 = string3;
                string2 = string2.substring(string2.indexOf("[@") + 2);
                string2 = string2.substring(0, string2.indexOf("]"));
                string2 = string2.replace(":", "%duepunti%");
                printStream.println("COPY:" + string + ":" + string2);
                d.info("COPY:" + string + ":" + string2);
                continue;
            }
            if (string3.toUpperCase().startsWith("COPYFULL[@") && string3.endsWith("]")) {
                string2 = string3;
                string2 = string2.substring(string2.indexOf("[@") + 2);
                string2 = string2.substring(0, string2.indexOf("]"));
                string2 = string2.replace(":", "%duepunti%");
                printStream.println("COPYFULL:" + string + ":" + string2);
                d.info("COPYFULL:" + string + ":" + string2);
                continue;
            }
            if (string3.toUpperCase().startsWith("ADMINCOPY[@") && string3.endsWith("]")) {
                string2 = string3;
                string2 = string2.substring(string2.indexOf("[@") + 2);
                string2 = string2.substring(0, string2.indexOf("]"));
                string2 = string2.replace(":", "%duepunti%");
                printStream.println("ADMINCOPY:" + string + ":" + string2);
                d.info("ADMINCOPY:" + string + ":" + string2);
                continue;
            }
            if (string3.toUpperCase().startsWith("REG")) {
                string2 = "REG(\\(([^\\?]*)?(\\?(.*))?\\))?";
                object2 = Pattern.compile("REG(\\(([^\\?]*)?(\\?(.*))?\\))?");
                if (((Matcher)(object2 = ((Pattern)object2).matcher(string3))).matches()) {
                    string3 = ((Matcher)object2).group(2);
                    string2 = ((Matcher)object2).group(4);
                    printStream.println("REG:" + (string3 == null || string3.isEmpty() ? string : string3) + (string2 == null || string2.length() == 0 ? "" : ":" + string2));
                    d.info("REG:" + (string3 == null || string3.isEmpty() ? string : string3) + (string2 == null || string2.length() == 0 ? "" : ":" + string2));
                    continue;
                }
                throw new RuntimeException("Azione con sintassi non corretta: " + string3 + ". Deve rispettare la regex " + string2);
            }
            if (string3.toUpperCase().startsWith("RENAME[")) {
                String string4 = string3;
                string2 = string4.substring(string4.indexOf("[") + 1, string3.indexOf("]"));
                printStream.println("RENAME:" + string + ":" + string2);
                continue;
            }
            if (string3.toUpperCase().startsWith("RUNNABLE[")) {
                String string5 = string3;
                string2 = string5.substring(string5.indexOf("[") + 1, string3.indexOf("]"));
                printStream.println("RUNNABLE:" + string2);
                continue;
            }
            printStream.println(string3.toUpperCase() + ":" + string);
            d.info(string3.toUpperCase() + ":" + string);
        }
    }

    private static String a(String object, File object2) throws NoSuchAlgorithmException, InvalidKeyException, FileNotFoundException, IOException {
        object = new SecretKeySpec(((String)object).getBytes(), "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init((Key)object);
        object = new FileInputStream((File)object2);
        object2 = new InputStreamReader((InputStream)object);
        BufferedReader bufferedReader = new BufferedReader((Reader)object2);
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            mac.update(string.getBytes());
            string = bufferedReader.readLine();
        }
        ((FileInputStream)object).close();
        ((InputStreamReader)object2).close();
        bufferedReader.close();
        object = UpdaterUtils.a(mac.doFinal());
        return object;
    }

    private static String a(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        char[] cArray = new char[2];
        for (byte by : byArray) {
            cArray[0] = Character.forDigit(by >> 4 & 0xF, 16);
            cArray[1] = Character.forDigit(by & 0xF, 16);
            stringBuilder.append(cArray);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static String evaluateUpdateInfo(String string, File object) throws NoSuchAlgorithmException, InvalidKeyException, FileNotFoundException, IOException {
        string = UpdaterUtils.a(string, (File)object);
        object = new PrintWriter(((File)object).getParentFile().getCanonicalPath() + File.separator + ((File)object).getName().replaceFirst("[.][^.]+$", "") + ".sign");
        ((PrintWriter)object).println(string);
        ((PrintWriter)object).close();
        return string;
    }

    private static boolean a(URL object, File file) throws FileNotFoundException, IOException, URISyntaxException, NoSuchAlgorithmException, InvalidKeyException {
        Object object2 = new UrlClient(ClientProperties.getInstance().getNetworkConfig(), d);
        Object object3 = new URLCredentials(ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_USER, ""), ClientProperties.getInstance().get(ServerProperties.UPDATER_BASIC_AUTH_PSW, ""), null, null);
        InputStream inputStream = null;
        try {
            inputStream = object2.getInputStream((URL)object, (URLCredentials)object3);
        }
        catch (URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
            d.error(exception.getMessage(), (Throwable)exception);
        }
        object2 = new BufferedReader(new InputStreamReader(inputStream));
        object3 = ((BufferedReader)object2).readLine();
        d.info("HMAC scaricato da " + object + ": " + (String)object3);
        ((BufferedReader)object2).close();
        inputStream.close();
        object = UpdaterUtils.a("8gJkufO8fliQPvfgdoehyGfo86g", file);
        d.info("HMAC di " + file + ": " + (String)object);
        boolean bl = ((String)object3).equals(object);
        return bl;
    }

    public static CertDb getCertDb() {
        if (f != null) {
            return f;
        }
        try {
            f = CertDbBuilder.get().setFile(new File(ClientProperties.getInstance().get(AppProperties.CDB_FILE, ""))).setNetworkConfig(ClientProperties.getInstance().getNetworkConfig()).setType(CertDbType.SQLLITE).setManifestValidator((ManifestValidator)new ArubaCdbManifestValidator()).build();
        }
        catch (CapiException | IOException throwable) {
            d.error(throwable.getMessage(), throwable);
        }
        return f;
    }

    public static void setInstallerName(String string) {
        g = string;
    }

    public static String getInstallerName() {
        return g;
    }

    public static void setApplyUpdateFile(File object) {
        i = object;
        try {
            object = new BufferedReader(new FileReader((File)object));
            Throwable throwable = null;
            try {
                g = "1".equals(((BufferedReader)object).readLine()) ? ((BufferedReader)object).readLine() : null;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                    throw throwable4;
                }
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            d.error(iOException.getMessage(), (Throwable)iOException);
        }
    }

    public static File getApplyUpdateFile() {
        return i;
    }

    public static String getUpdaterName() {
        return null;
    }

    public static int compareVersion(String string, String string2) {
        int n;
        int n2;
        String string3 = UpdaterUtils.a(string);
        String string4 = UpdaterUtils.a(string2);
        while (!string3.isEmpty() && !string4.isEmpty()) {
            int n3 = string3.indexOf(".");
            if (n3 > 0) {
                n2 = Integer.parseInt(string3.substring(0, n3));
                string3 = string3.substring(n3 + 1);
            } else {
                n2 = Integer.parseInt(string3);
                string3 = "";
            }
            n3 = string4.indexOf(".");
            if (n3 > 0) {
                n = Integer.parseInt(string4.substring(0, n3));
                string4 = string4.substring(n3 + 1);
            } else {
                n = Integer.parseInt(string4);
                string4 = "";
            }
            if (n2 < n) {
                return -1;
            }
            if (n2 <= n) continue;
            return 1;
        }
        String string5 = UpdaterUtils.b(string);
        string3 = UpdaterUtils.b(string2);
        if (!string5.isEmpty() && string3.isEmpty()) {
            return 1;
        }
        if (string5.isEmpty() && !string3.isEmpty()) {
            return -1;
        }
        if (!string5.isEmpty() && !string3.isEmpty()) {
            boolean bl = string.contains("BETA");
            boolean bl2 = string2.contains("BETA");
            if (!bl && bl2) {
                return 1;
            }
            if (bl && !bl2) {
                return -1;
            }
            n2 = Integer.parseInt(string5);
            if (n2 < (n = Integer.parseInt(string3))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
        }
        return 0;
    }

    private static String a(String string) {
        Matcher matcher = a.matcher(string);
        if (matcher.find()) {
            return string.substring(matcher.start(), matcher.end());
        }
        return "";
    }

    private static String b(String string) {
        Matcher matcher = b.matcher(string);
        if (matcher.find()) {
            return string.substring(matcher.start() + 2, matcher.end());
        }
        matcher = c.matcher(string);
        if (matcher.find()) {
            return string.substring(matcher.start() + 4, matcher.end());
        }
        return "";
    }

    public static class DownloadFile {
        private String a;
        private File b;
        private String c;
        private long d;

        public DownloadFile(String string, File file, String string2, long l) {
            this.a = string;
            this.b = file;
            this.c = string2;
            this.d = l;
        }

        public String getStrUrl() {
            return this.a;
        }

        public void setStrUrl(String string) {
            this.a = string;
        }

        public File getOutputFile() {
            return this.b;
        }

        public void setOutputFile(File file) {
            this.b = file;
        }

        public String getHash() {
            return this.c;
        }

        public void setHash(String string) {
            this.c = string;
        }

        public long getSize() {
            return this.d;
        }

        public void setSize(long l) {
            this.d = l;
        }
    }
}

