/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.config;

import esecurity.dsd.core.ConfigurationMap;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.PropertyContainer;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Set;

public class RemoteConfigProvider
implements Comparable<RemoteConfigProvider>,
LocalConfigurationProvider {
    ConfigurationMap instance = new ConfigurationMap();
    private String name = "";

    public RemoteConfigProvider(String name) {
        this.name = name;
    }

    public static Builder create(String name) {
        return new Builder(name);
    }

    public static Builder copy(String name, LocalConfigurationProvider serverConfig) {
        Builder builder = new Builder(name);
        builder.conf = new ConfigurationMap(serverConfig.getProvidedConfiguration());
        return builder;
    }

    @Override
    public int compareTo(RemoteConfigProvider arg0) {
        if (arg0 != null) {
            return this.name.compareToIgnoreCase(arg0.name);
        }
        return 0;
    }

    public PropertyContainer getProvidedConfiguration() {
        return this.instance;
    }

    public Set<String> getDefaultProvidedKeys() {
        return Collections.EMPTY_SET;
    }

    public static class Builder {
        private ConfigurationMap conf = new ConfigurationMap();
        private String name;

        public Builder(String name) {
            this.name = name;
            this.conf.setValue("host", null);
            this.conf.setValue("secured", (Object)true);
            this.conf.setValue("pwd", null);
            this.conf.setValue("port", (Object)-1);
            this.conf.setValue("service", (Object)"dsd-server");
            this.conf.setValue("connectionTimeout", (Object)60);
            this.conf.setValue("readTimeout", (Object)60);
            this.conf.setValue("writeTimeout", (Object)60);
            this.conf.setValue("user", null);
        }

        public Builder proxyAddress(String proxyAddr) {
            this.conf.setValue("proxy.addr", (Object)proxyAddr);
            return this;
        }

        public Builder proxyAuthentication(String user, String pwd) {
            this.conf.setValue("proxy.user", (Object)user);
            this.conf.setValue("proxy.pwd", (Object)pwd);
            return this;
        }

        public Builder proxyPort(Integer proxyPort) {
            this.conf.setValue("proxy.port", (Object)proxyPort);
            return this;
        }

        public Builder host(String host) {
            this.conf.setValue("host", (Object)host);
            return this;
        }

        public Builder port(int portno) {
            if (portno >= 0) {
                this.conf.setValue("port", (Object)portno);
            }
            return this;
        }

        public Builder useSSL(boolean secured) {
            this.conf.setValue("secured", (Object)secured);
            return this;
        }

        public Builder username(String user) {
            this.conf.setValue("user", (Object)user);
            return this;
        }

        public Builder password(String pwd) {
            this.conf.setValue("pwd", (Object)pwd);
            return this;
        }

        public Builder servicePrefix(String service) {
            this.conf.setValue("service", (Object)service);
            return this;
        }

        public Builder connectionTimeoutSecs(int seconds) {
            this.conf.setValue("connectionTimeout", (Object)seconds);
            return this;
        }

        public Builder readTimeoutSecs(int seconds) {
            this.conf.setValue("readTimeout", (Object)seconds);
            return this;
        }

        public Builder writeTimeoutSecs(int seconds) {
            this.conf.setValue("writeTimeout", (Object)seconds);
            return this;
        }

        public RemoteConfigProvider build() {
            String pwd = (String)this.conf.getValue("pwd", String.class).orElseThrow(() -> new InvalidParameterException("Needs hostname, username and password parameters."));
            String uname = (String)this.conf.getValue("user", String.class).orElseThrow(() -> new InvalidParameterException("Needs hostname, username and password parameters."));
            String hname = (String)this.conf.getValue("host", String.class).orElseThrow(() -> new InvalidParameterException("Needs hostname, username and password parameters."));
            if (!("".equals(pwd) || "".equals(uname) || "".equals(hname))) {
                RemoteConfigProvider remote = new RemoteConfigProvider(this.name);
                remote.instance = new ConfigurationMap(this.conf.getMap());
                return remote;
            }
            throw new InvalidParameterException("Needs hostname, username and password parameters.");
        }
    }
}

