/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.pkcs11.CapiPKCS11Exception;

public class Pkcs11ExceptionUtils {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HOST_MEMORY = 2;
    public static final int SLOT_ID_INVALID = 3;
    public static final int GENERAL_ERROR = 5;
    public static final int FUNCTION_FAILED = 6;
    public static final int ARGUMENTS_BAD = 7;
    public static final int NO_EVENT = 8;
    public static final int NEED_TO_CREATE_THREADS = 9;
    public static final int CANT_LOCK = 10;
    public static final int ATTRIBUTE_READ_ONLY = 16;
    public static final int ATTRIBUTE_SENSITIVE = 17;
    public static final int ATTRIBUTE_TYPE_INVALID = 18;
    public static final int ATTRIBUTE_VALUE_INVALID = 19;
    public static final int DATA_INVALID = 32;
    public static final int DATA_LEN_RANGE = 33;
    public static final int DEVICE_ERROR = 48;
    public static final int DEVICE_MEMORY = 49;
    public static final int DEVICE_REMOVED = 50;
    public static final int ENCRYPTED_DATA_INVALID = 64;
    public static final int ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int FUNCTION_CANCELED = 80;
    public static final int FUNCTION_NOT_PARALLEL = 81;
    public static final int FUNCTION_PARALLEL = 82;
    public static final int FUNCTION_NOT_SUPPORTED = 84;
    public static final int KEY_HANDLE_INVALID = 96;
    public static final int KEY_SIZE_RANGE = 98;
    public static final int KEY_TYPE_INCONSISTENT = 99;
    public static final int KEY_NOT_NEEDED = 100;
    public static final int KEY_CHANGED = 101;
    public static final int KEY_NEEDED = 102;
    public static final int KEY_INDIGESTIBLE = 103;
    public static final int KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int KEY_NOT_WRAPPABLE = 105;
    public static final int KEY_UNEXTRACTABLE = 106;
    public static final int MECHANISM_INVALID = 112;
    public static final int MECHANISM_PARAM_INVALID = 113;
    public static final int OBJECT_HANDLE_INVALID = 130;
    public static final int OPERATION_ACTIVE = 144;
    public static final int OPERATION_NOT_INITIALIZED = 145;
    public static final int PIN_INCORRECT = 160;
    public static final int PIN_INVALID = 161;
    public static final int PIN_LEN_RANGE = 162;
    public static final int PIN_EXPIRED = 163;
    public static final int PIN_LOCKED = 164;
    public static final int SESSION_CLOSED = 176;
    public static final int SESSION_COUNT = 177;
    public static final int SESSION_EXCLUSIVE_EXISTS = 178;
    public static final int SESSION_HANDLE_INVALID = 179;
    public static final int SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int SESSION_READ_ONLY = 181;
    public static final int SESSION_EXISTS = 182;
    public static final int SESSION_READ_ONLY_EXISTS = 183;
    public static final int SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int SIGNATURE_INVALID = 192;
    public static final int SIGNATURE_LEN_RANGE = 193;
    public static final int TEMPLATE_INCOMPLETE = 208;
    public static final int TEMPLATE_INCONSISTENT = 209;
    public static final int TOKEN_NOT_PRESENT = 224;
    public static final int TOKEN_NOT_RECOGNIZED = 225;
    public static final int TOKEN_WRITE_PROTECTED = 226;
    public static final int UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int USER_ALREADY_LOGGED_IN = 256;
    public static final int USER_NOT_LOGGED_IN = 257;
    public static final int USER_PIN_NOT_INITIALIZED = 258;
    public static final int USER_TYPE_INVALID = 259;
    public static final int USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int USER_TOO_MANY_TYPES = 261;
    public static final int WRAPPED_KEY_INVALID = 272;
    public static final int WRAPPED_KEY_LEN_RANGE = 274;
    public static final int WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int RANDOM_NO_RNG = 289;
    public static final int INSERTION_CALLBACK_SET = 320;
    public static final int INSERTION_CALLBACK_NOT_SUPPORTED = 321;
    public static final int BUFFER_TOO_SMALL = 336;
    public static final int SAVED_STATE_INVALID = 352;
    public static final int INFORMATION_SENSITIVE = 368;
    public static final int STATE_UNSAVEABLE = 384;
    public static final int CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int MUTEX_BAD = 416;
    public static final int MUTEX_NOT_LOCKED = 417;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;

    public static CapiException toCapiException(CapiPKCS11Exception capiPKCS11Exception) {
        return Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception, false, false);
    }

    public static CapiException toCapiException(CapiPKCS11Exception capiPKCS11Exception, boolean bl) {
        return Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception, bl, false);
    }

    public static CapiException toCapiException(CapiPKCS11Exception capiPKCS11Exception, boolean bl, boolean bl2) {
        long l;
        String string;
        switch ((int)capiPKCS11Exception.getErrorCode()) {
            case 176: 
            case 179: 
            case 257: {
                string = "User not logged in";
                l = 10013L;
                break;
            }
            case 50: {
                string = "Token removed";
                l = 10012L;
                break;
            }
            case 224: {
                string = "Token not inserted";
                l = 10011L;
                break;
            }
            case 49: {
                string = "No space on device";
                l = 10030L;
                break;
            }
            case 48: {
                string = "Problem on device";
                l = 11001L;
                break;
            }
            case 16: {
                string = "Cannot modify label";
                l = 11010L;
                break;
            }
            case 17: 
            case 368: {
                string = "Cannot read private data";
                l = 11011L;
                break;
            }
            case 400: {
                string = "Library not initialized";
                l = 10003L;
                break;
            }
            case 182: 
            case 401: {
                string = "Library already init";
                l = 10002L;
                break;
            }
            case 84: {
                string = "Function not supported";
                l = 11002L;
                break;
            }
            case 98: {
                string = "Unsupported key size";
                l = 10031L;
                break;
            }
            case 105: 
            case 106: {
                string = "Cannot extract key";
                l = 11012L;
                break;
            }
            case 112: 
            case 113: {
                string = "Unsupported mechanism";
                l = 11013L;
                break;
            }
            case 163: {
                string = bl ? "Expired PUK" : "Expired PIN";
                l = bl ? 2010L : 2007L;
                break;
            }
            case 160: {
                string = bl ? "Wrong PUK" : "Wrong PIN";
                l = bl ? 2005L : 2001L;
                break;
            }
            case 161: 
            case 162: {
                string = bl ? "Invalid PUK" : "Invalid PIN";
                l = bl ? 2009L : 2006L;
                break;
            }
            case 164: {
                string = bl ? "Locked PUK" : "Locked PIN";
                l = bl ? 2008L : 2003L;
                break;
            }
            case 177: 
            case 256: 
            case 259: 
            case 260: 
            case 261: {
                string = "cannot login";
                l = 11014L;
                break;
            }
            case 3: {
                string = "Invalid slot";
                l = 11003L;
                break;
            }
            case 225: 
            case 226: {
                string = "Token is not valid";
                l = 11004L;
                break;
            }
            case 258: {
                string = "Token is not initialized";
                l = 10010L;
                break;
            }
            case 104: {
                string = "Function not permitted for this type of key";
                l = 10038L;
                break;
            }
            case 32: {
                string = "Data is Invalid";
                l = 10038L;
                break;
            }
            case -2147483136: {
                if (bl2) {
                    string = "AS_VENDOR_NET_ERR";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483135: {
                if (bl2) {
                    string = "AS_VENDOR_NET_UNK";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483134: {
                if (bl2) {
                    string = "AS_VENDOR_NET_CONN";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483133: {
                if (bl2) {
                    string = "AS_VENDOR_NET_RCV";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483132: {
                if (bl2) {
                    string = "AS_VENDOR_NET_SND";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483131: {
                if (bl2) {
                    string = "AS_VENDOR_NET_NOSOCK";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483130: {
                if (bl2) {
                    string = "AS_VENDOR_NET_ARGS";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483129: {
                if (bl2) {
                    string = "AS_VENDOR_NET_LIB";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483128: {
                if (bl2) {
                    string = "AS_VENDOR_NET_MEM";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483127: {
                if (bl2) {
                    string = "AS_VENDOR_NET_MSGS";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483126: {
                if (bl2) {
                    string = "AS_VENDOR_NET_TIMEOUT";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483125: {
                if (bl2) {
                    string = "AS_VENDOR_NET_WND";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483124: {
                if (bl2) {
                    string = "AS_VENDOR_NET_AGAIN";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483123: {
                if (bl2) {
                    string = "AS_VENDOR_NET_QUIT";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483122: {
                if (bl2) {
                    string = "AS_VENDOR_NO_SERVER";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483121: {
                if (bl2) {
                    string = "AS_VENDOR_NO_CARD_FOUND";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483120: {
                if (bl2) {
                    string = "AS_VENDOR_REMOTE_CALL_ERROR";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483117: {
                if (bl2) {
                    string = "AS_VENDOR_INVALID_MAC";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            case -2147483116: {
                if (bl2) {
                    string = "AS_VENDOR_NO_MAC_KEY";
                    l = capiPKCS11Exception.getErrorCode();
                    break;
                }
            }
            default: {
                string = "General error on Token";
                l = 10040L;
            }
        }
        return new CapiException(string, (int)l);
    }

    static {
        String[] stringArray = new String[]{"Function has completed successfully", "Function should be canceled", "Not enough memory on host", "Slot ID is invalid", "Unrecoverable error", "The requested function could not be performed", "Supplied arguments not appropriate", "No new events available", "Native thread support required", "Locking not available", "Attribute is read-only", "Attribute is sensitive and cannot be revealed", "Attribute type is invalid", "Attribute value is invalid", "Data is invalid", "Invalid data length", "Device error", "Not enough memory on device", "Device has been removed", "Encrypted data is invalid", "Encrypted data length is out of range", "Function has been canceled", "No function is executing in parallel", "Function is executing in parallel", "The requested function is not supported", "Key handle is invalid", "Key size is out of range", "Key type is inconsistent with mechanism", "Key not needed, extraneous key supplied", "Key has been changed", "Key needed, no key supplied", "The value of the specified key cannot be digested", "Function not permitted for this key", "Key cannot be wrapped", "Key is unextractable", "Mechanism invalid", "Mechanism parameter is invalid", "Object handle is invalid", "Another operation is already active", "Operation has not been initialized", "Pin is incorrect", "New PIN cotains invalid characters", "New PIN length is out of range", "Pin has expired", "Pin is locked", "Session has been closed", "Session limits have been reached", "An exclusive session already exists", "Session handle is invalid", "Parallel execution is not supported", "Session is read-only", "A session with the token is already open", "A read-only session already exists and the SO cannot be logged in", "A read/write SO session already exists and the SO cannot be logged in", "Signature is invalid", "Signature length is out of range", "Template is incomplete", "Template is inconsistent", "Slot does not contain a token", "The token was not recognized", "Token is write-protected", "Unwrapping key handle is invalid", "Unwrapping key size is out of range", "Unwrapping key is inconsistent with mechanism", "A user is already logged in", "A user is not logged in", "The user's PIN has not been initialized", "User type is invalid", "Another user is already logged in", "Too many users logged in", "Wrapped key is invalid", "Wrapped key length is out of range", "Wrapping key handle is invalid", "Wrapping key size is invalid", "Wrapping key type is inconsistent with mechanism", "Random number generator does not accept seeding", "The token does not have a random number generator", "Insertion_CALLBACK_SET", "The slot does not support token insertion callbacks", "Buffer too small", "The saved operations state is invalid and cannot be restored", "The requested information is sensitive and cannot be revealed", "The operations state cannot be saved", "Cryptoki is not yet initialized", "Cryptoki is already initialized", "Mutex object is bad", "Mutex is not locked"};
    }
}

