/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisKeyStoreParameters;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class ActalisKeyStore
extends KeyStoreSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private ActalisKeyStoreParameters b = null;
    private CertificateFactory c;
    private Hashtable<String, X509Certificate> d = new Hashtable();

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            if (this.b.getTk().isSessionOpen()) {
                return this.b.getTk().getPrivateKey(string);
            }
            throw new UnrecoverableKeyException("Errore recupero chiave --> session not open");
        }
        catch (CapiException capiException) {
            a.error("Errore recupero chiave", (Throwable)capiException);
            throw new UnrecoverableKeyException("Errore recupero chiave");
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = new Certificate[1];
        Certificate[] certificateArray2 = certificateArray;
        certificateArray[0] = this.d.get(string);
        return certificateArray2;
    }

    @Override
    public Certificate engineGetCertificate(String object) {
        object = this.d.get(object);
        return object;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Enumeration<String> engineAliases() {
        Enumeration<String> enumeration = this.d.keys();
        return enumeration;
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.d.get(string) != null;
    }

    @Override
    public int engineSize() {
        return this.d.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        try {
            if (this.b.getTk().isSessionOpen()) {
                bl = this.b.getTk().getPrivateKey(string) != null;
            }
        }
        catch (CapiException capiException) {
            a.error("Unable to retrieve key info", (Throwable)capiException);
        }
        return bl;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        boolean bl = this.d.get(string) != null;
        return bl;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        String string = null;
        for (String string2 : this.d.keySet()) {
            Certificate certificate2 = this.d.get(string2);
            if (!certificate2.equals(certificate)) continue;
            string = string2;
            break;
        }
        return string;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        boolean bl = false;
        this.c = CertificateFactory.getInstance("X.509");
        if (loadStoreParameter instanceof ActalisKeyStoreParameters) {
            this.b = (ActalisKeyStoreParameters)loadStoreParameter;
            try {
                if (!this.b.getTk().isSessionOpen()) {
                    bl = true;
                    this.b.getTk().openPublicSession();
                }
                byte by = 18;
                if (this.b.getTk().getClass().getName().endsWith("PKCS11Token") || this.b.getTk().getClass().getName().endsWith("SoftToken")) {
                    by = 4;
                }
                String[] stringArray = this.b.getTk().listObjects(null, by);
                String[] stringArray2 = stringArray;
                stringArray2 = stringArray;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray2[i];
                    try {
                        Object object = this.b.getTk().getCert(string);
                        object = new ByteArrayInputStream(Base64.decode((String)object));
                        X509Certificate x509Certificate = (X509Certificate)this.c.generateCertificate((InputStream)object);
                        ((ByteArrayInputStream)object).close();
                        this.d.put(string, x509Certificate);
                        continue;
                    }
                    catch (Exception exception) {
                        a.warn("Alias " + string + " has not valid certificate!");
                    }
                }
                if (bl) {
                    this.b.getTk().closeSession();
                }
                return;
            }
            catch (CapiException capiException) {
                a.error("unable to initialize the token: " + capiException.getMessage());
                throw new IOException(capiException.getMessage());
            }
        }
        throw new NoSuchAlgorithmException("Invalid Parameters");
    }
}

