/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class StepX509KeyUsage
extends SingleValidationSubStepImpl {
    public StepX509KeyUsage() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        if (!(validationContextParameters == null || validationContextParameters.getSignerCertificate() == null || validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getFormat() != null && validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST))) {
            try {
                object = validationContextParameters.getSignerCertificate().getCert().keyUsageToString(validationContextParameters.getSignerCertificate().getCert().getKeyUsage());
            }
            catch (CapiException capiException) {
                object = "";
            }
            if (validationContextParameters.getSignature() != null ? !validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST) && !((String)object).contains("nonRepudiation") : !validationContextParameters.getSignerCertificate().getCert().getBasicConstraints() && !((String)object).contains("nonRepudiation")) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0011_NODIGITALSIGNATURE, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
            }
        }
        return null;
    }
}

