/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationStep;
import esecurity.validator.steps.SingleValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationSubStep;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class ValidationStep
implements Comparable<ValidationStep> {
    protected final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private ValidationType a;
    protected LinkedList<ValidationSubStep> subSteps = new LinkedList();

    public ValidationStep(ValidationType validationType) {
        this.a = validationType;
    }

    public ValidationType getType() {
        return this.a;
    }

    @Override
    public int compareTo(ValidationStep validationStep) {
        int n = ValidationStep.retrieveAnnotationOrder(this) == null ? 100 : ValidationStep.retrieveAnnotationOrder(this).order();
        int n2 = ValidationStep.retrieveAnnotationOrder(validationStep) == null ? 100 : ValidationStep.retrieveAnnotationOrder(validationStep).order();
        return n - n2;
    }

    public static StepContext retrieveAnnotationContext(ValidationStep annotationArray) {
        StepContext stepContext = null;
        if (annotationArray.getClass().getAnnotations().length > 0) {
            for (Annotation annotation : annotationArray.getClass().getAnnotations()) {
                if (!(annotation instanceof StepContext)) continue;
                stepContext = (StepContext)annotation;
                break;
            }
        }
        return stepContext;
    }

    public static StepOrder retrieveAnnotationOrder(ValidationStep annotationArray) {
        StepOrder stepOrder = null;
        if (annotationArray.getClass().getAnnotations().length > 0) {
            for (Annotation annotation : annotationArray.getClass().getAnnotations()) {
                if (!(annotation instanceof StepOrder)) continue;
                stepOrder = (StepOrder)annotation;
                break;
            }
        }
        return stepOrder;
    }

    protected LinkedList<ValidatorMessage> checkSubSteps(ValidationContextParameters validationContextParameters) {
        LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
        for (ValidationSubStep validationSubStep : this.subSteps) {
            if (validationSubStep instanceof SingleValidationStep) {
                ValidatorMessage validatorMessage = ((SingleValidationStep)((Object)validationSubStep)).check(validationContextParameters);
                if (validatorMessage == null) continue;
                linkedList.add(validatorMessage);
                continue;
            }
            List<ValidatorMessage> list = ((MultipleValidationStep)((Object)validationSubStep)).checks(validationContextParameters);
            if (list == null) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }
}

