/*
 * Decompiled with CFR 0.152.
 */
package esecurity.internal.asb.gw;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.arubacipherservice.DecryptReq;
import esecurity.arubacipherservice.DecryptRet;
import esecurity.internal.asb.gw.GwClientDefault;
import esecurity.internal.asb.gw.GwClientI;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestClient;
import it.arubapec.signservice.ArssAudit;
import it.arubapec.signservice.Auth;
import it.arubapec.signservice.AutomaticSignatureControl;
import it.arubapec.signservice.AutomaticSignatureControlReturn;
import it.arubapec.signservice.CertListResponse;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.CertsListRequestAuth;
import it.arubapec.signservice.ChangePassword;
import it.arubapec.signservice.CloseSessionRequest;
import it.arubapec.signservice.CreateSessionReturn;
import it.arubapec.signservice.CredentialListQuery;
import it.arubapec.signservice.CredentialListReturn;
import it.arubapec.signservice.GWReturn;
import it.arubapec.signservice.RetriveCredential;
import it.arubapec.signservice.RetriveCredentialReturn;
import it.arubapec.signservice.SendCredential;
import it.arubapec.signservice.SessionSignRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.StrongCredential;
import it.arubapec.signservice.TempPwdRequest;
import it.arubapec.signservice.TempPwdRequestEx;
import it.arubapec.signservice.TempPwdResponse;
import it.arubapec.signservice.TempPwdResponseEx;
import it.arubapec.signservice.TestCredential;
import it.arubapec.signservice.UserAuthenticationInfoRequest;
import it.arubapec.signservice.UserAuthenticationInfoResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwClientGson
extends GwClientI {
    private static final Logger a = LoggerFactory.getLogger((String)GwClientDefault.class.getName());
    private static Logger b = null;
    private RestClient c = null;
    private boolean d = false;
    private URLCredentials e;
    private boolean f;

    public GwClientGson(UrlClient urlClient) throws CertDBException {
        this(urlClient, a, null, null, false, true);
    }

    public GwClientGson(UrlClient urlClient, Logger logger, URLCredentials uRLCredentials, KeyStore keyStore, boolean bl, boolean bl2) {
        b = logger != null ? logger : a;
        this.e = uRLCredentials;
        this.f = bl2;
        this.c = new RestClient(urlClient, keyStore, bl, b);
        if (System.getProperties().getProperty("esecurity.asb.gw.debug") != null) {
            this.d = System.getProperties().getProperty("esecurity.asb.gw.debug").equals("true");
        }
    }

    @Override
    public void setEnforceMode(boolean bl) {
        this.f = bl;
    }

    @Override
    public SignResponse signop(String string, SignRequest signRequest) throws IOException {
        return this.makeCall(string + "/signop", signRequest, SignResponse.class);
    }

    @Override
    public SignResponse signop2(String string, SessionSignRequest sessionSignRequest) throws IOException {
        return this.makeCall(string + "/signop2", sessionSignRequest, SignResponse.class);
    }

    @Override
    public CertListResponse certlistop(String string, CertsListRequest certsListRequest) throws IOException {
        return this.makeCall(string + "/certlistop", certsListRequest, CertListResponse.class);
    }

    @Override
    public CertListResponse certlistopauth(String string, CertsListRequestAuth certsListRequestAuth) throws IOException {
        return this.makeCall(string + "/certlistopauth", certsListRequestAuth, CertListResponse.class);
    }

    @Override
    public GWReturn close_session(String string, CloseSessionRequest closeSessionRequest) throws IOException {
        return this.makeCall(string + "/close_session", closeSessionRequest, GWReturn.class);
    }

    @Override
    public CreateSessionReturn create_session(String string, TempPwdRequestEx tempPwdRequestEx) throws IOException {
        return this.makeCall(string + "/create_session", tempPwdRequestEx, CreateSessionReturn.class);
    }

    @Override
    public TempPwdResponse temppwd(String string, TempPwdRequest tempPwdRequest) throws IOException {
        return this.makeCall(string + "/temppwd", tempPwdRequest, TempPwdResponse.class);
    }

    @Override
    public String arssaudit(String string, ArssAudit arssAudit) throws IOException {
        return this.makeCall(string + "/arssaudit", arssAudit, String.class);
    }

    @Override
    public TempPwdResponseEx temppwd_ext(String string, TempPwdRequestEx tempPwdRequestEx) throws IOException {
        return this.makeCall(string + "/temppwd_ext", tempPwdRequestEx, TempPwdResponseEx.class);
    }

    @Override
    public String send_credential(String string, SendCredential sendCredential) throws IOException {
        return this.makeCall(string + "/send_credential", sendCredential, String.class);
    }

    @Override
    public String verify_credential(String string, StrongCredential strongCredential) throws IOException {
        return this.makeCall(string + "/verify_credential", strongCredential, String.class);
    }

    @Override
    public String verify_otp(String string, StrongCredential strongCredential) throws IOException {
        return this.makeCall(string + "/verify_otp", strongCredential, String.class);
    }

    @Override
    public AutomaticSignatureControlReturn enable_automatic_signature(String string, AutomaticSignatureControl automaticSignatureControl) throws IOException {
        return this.makeCall(string + "/temppwd_ext", automaticSignatureControl, AutomaticSignatureControlReturn.class);
    }

    @Override
    public RetriveCredentialReturn retrieve_credential(String string, RetriveCredential retriveCredential) throws IOException {
        return this.makeCall(string + "/retrive_credential", retriveCredential, RetriveCredentialReturn.class);
    }

    @Override
    public String[] auth_methods(String string, Auth auth) throws IOException {
        return this.makeCall(string + "/auth_methods", auth, String[].class);
    }

    @Override
    public String getInfoMiddlewareUrl() {
        return "";
    }

    @Override
    public CredentialListReturn credentials_query(String string, CredentialListQuery credentialListQuery) throws IOException {
        return this.makeCall(string + "/credentials_query", credentialListQuery, CredentialListReturn.class);
    }

    @Override
    public GWReturn test_otp(String string, TestCredential testCredential) throws IOException {
        return this.makeCall(string + "/test_otp", testCredential, GWReturn.class);
    }

    @Override
    public DecryptRet decrypt(String string, DecryptReq decryptReq) throws IOException {
        return this.makeCall(string + "/decrypt", decryptReq, DecryptRet.class);
    }

    public <T> T makeCall(String object, Object object2, Class<T> clazz) throws IOException {
        if (!((String)object).toUpperCase().startsWith("HTTPS")) {
            if (this.f) {
                b.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!((String)object).contains("http://localhost") && !((String)object).contains("http://127.0.0.1")) {
                b.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        try {
            b.debug("endpoint richiesta " + (String)object);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            object2 = objectMapper.writeValueAsString(object2);
            if (this.d) {
                b.debug("richiesta : {}", (Object)this.a((String)object2));
            }
            object = this.c.sendRawJson((String)object, ((String)object2).getBytes(), this.e);
            if (this.d) {
                b.info("{}", object2);
                b.info("{}", (Object)object.getResponseData());
            }
            if (object.getResponseData() == null) {
                b.error("Nessun risposta dal server: " + object.getMessage());
                throw new IOException(object.getMessage());
            }
            if (String.class.equals(clazz)) {
                return (T)new String(object.getResponseData());
            }
            object = new InputStreamReader(new ByteArrayInputStream(object.getResponseData()));
            if ((object = objectMapper.readValue((Reader)object, clazz)) == null) {
                throw new IOException("Null Response from Server");
            }
        }
        catch (Throwable throwable) {
            b.error(throwable.getMessage(), throwable);
            throw new IOException(throwable.getMessage(), throwable);
        }
        return (T)object;
    }

    private String a(String string) {
        try {
            int n = string.indexOf("userPWD");
            if (n != -1) {
                string = GwClientGson.a(n, 10, string);
            }
            if ((n = string.indexOf("delegated_password")) != -1) {
                string = GwClientGson.a(n, 21, string);
            }
            if ((n = string.indexOf("otpPwd")) != -1) {
                string = GwClientGson.a(n, 9, string);
            }
            if ((n = string.indexOf("newpassword")) != -1) {
                string = GwClientGson.a(n, 14, string);
            }
            if ((n = string.indexOf("applicationpassword")) != -1) {
                string = GwClientGson.a(n, 22, string);
            }
            if ((n = string.indexOf("value")) != -1) {
                string = GwClientGson.a(n, 8, string);
            }
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private static String a(int n, int n2, String string) {
        String string2 = "\",";
        if (string.substring(n + n2).indexOf("\",") == -1) {
            string2 = "\"}";
        }
        String string3 = string.substring(n + n2, n + n2 + string.substring(n + n2).indexOf(string2));
        return string.replace("\"" + string3 + "\"", "\"*****\"");
    }

    @Override
    public GWReturn changePassword(String string, ChangePassword changePassword) throws IOException {
        return this.makeCall(string + "/change_password", changePassword, GWReturn.class);
    }

    @Override
    public UserAuthenticationInfoResponse userAuthenticationInfo(String string, UserAuthenticationInfoRequest userAuthenticationInfoRequest) throws IOException {
        return this.makeCall(string + "/user_authentication_info", userAuthenticationInfoRequest, UserAuthenticationInfoResponse.class);
    }
}

