#!/usr/bin/env python3
import os
import stat
import struct
import sys

script_path = os.path.dirname(os.path.realpath(__file__))
os.chdir(script_path)

is_64bits = sys.maxsize > 2**32
if is_64bits and os.path.exists(script_path+"/jre64"):
    java_path = "./jre64/bin/java"
    os.environ["LD_LIBRARY_PATH"]="/usr/lib/x64-athena/:" + script_path + "/driver"
else:
    java_path = "./jre32/bin/java"
    os.environ["LD_LIBRARY_PATH"]="/usr/lib/x86-athena/:" + script_path + "/driver"

as_path = "./dist/ArubaSign.jar:./dist/lib/* it.arubapec.arubasign.ArubaSignApp"

print( 8 * struct.calcsize("P"))
print( os.getcwd())
print( java_path)
print( as_path)

os.system(java_path+" -Djdk.http.auth.tunneling.disabledSchemes= -splash:images/MainSplash.png -Djavax.net.ssl.trustStore=./cacerts -Dswt.autoScale=exact -Dorg.eclipse.jetty.util.log.class=org.eclipse.jetty.util.log.StdErrLog -Dcapi.certdb.verbose=false"+" -cp "+as_path)

