/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.Composite;
import esecurity.desktop.swt.ProgressEvent;
import esecurity.desktop.swt.ProgressListener;
import esecurity.desktop.swt.SWTClass;
import esecurity.desktop.swt.SWTFacade;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Browser
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(Browser.class);

    public Browser(Composite parent, int style) {
        try {
            this.innerObject = SWTClass.Browser.getRef();
            this.innerObject.init(parent.innerObject.getObj(), style);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        try {
            Object p = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.ProgressListener.getClss()}, (proxy, method, args) -> {
                logger.debug("Browser ProgressListener " + method.getName());
                if (method.getName() != null && method.getName().contains("changed")) {
                    listener.changed(new ProgressEvent(args[0]));
                } else if (method.getName() != null && method.getName().contains("completed")) {
                    listener.completed(new ProgressEvent(args[0]));
                }
                return null;
            });
            this.innerObject.callMethod("addProgressListener", p);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public boolean setText(String html) {
        try {
            return this.innerObject.callMethodAsBoolean("setText", html);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public boolean setUrl(String url) {
        try {
            return this.innerObject.callMethodAsBoolean("setUrl", url);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public boolean execute(String script) {
        try {
            return this.innerObject.callMethodAsBoolean("execute", script);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public Object evaluate(String script) {
        Object obj = null;
        try {
            obj = this.innerObject.callMethod("evaluate", script);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return obj;
    }
}

