/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.jetty;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import esecurity.desktop.BaseController;
import esecurity.desktop.Listener;
import esecurity.desktop.Region;
import esecurity.desktop.View;
import esecurity.desktop.jetty.JettyRedirect;
import esecurity.desktop.jetty.JettyResource;
import esecurity.desktop.jetty.WSEvent;
import esecurity.desktop.jetty.WSServlet;
import esecurity.desktop.swt.DragAndDropInnerArea;
import esecurity.desktop.swt.Point;
import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;

public class JettyView
extends View {
    private static Server server;
    public static HashMap<String, BaseController> controllerMap;
    private String vieewId = "/127.0.0.1:8888";
    private String redirectUrl = "";
    private String indexOpenScript = "";
    private BaseController controller = null;
    private Listener dropListener;
    private int width;
    private int heigth;

    public Server getServer() {
        return server;
    }

    @Override
    protected void initialize(BaseController controller, View parent, String title, byte[] image, View.ModalType modalType, Region viewArea, Region dragArea, boolean decorated, boolean resizable, boolean onTop) throws Exception {
        this.controller = controller;
        controller.setView(this);
        controllerMap.put(controller.getId(), controller);
        this.width = viewArea.getWidth();
        this.heigth = viewArea.getHeight();
        this.redirectUrl = String.format("http://localhost:8888/redirect?controllerId=%d&height=%d&width=%d", Integer.parseInt(controller.getId()), this.heigth, this.width);
        this.indexOpenScript = "window.open(\"http://localhost:8888/index?controllerId=" + controller.getId() + "\",\"_blank\",\"menubar=1,resizable=1,width=" + this.width + ",height=" + this.heigth + "\");";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        block9: {
            try {
                if (server == null) break block9;
                boolean start = false;
                if (!server.isRunning()) {
                    Server server = JettyView.server;
                    synchronized (server) {
                        if (!JettyView.server.isRunning()) {
                            JettyView.server.start();
                            JettyView.server.dump((Appendable)System.err);
                            Thread.sleep(2000L);
                            start = true;
                        }
                    }
                }
                if (start) {
                    Desktop dsk = Desktop.getDesktop();
                    dsk.browse(URI.create(this.redirectUrl));
                    server.join();
                    System.out.println("Server Join");
                } else {
                    this.evaluate(this.indexOpenScript, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object evaluate(String expression) {
        return this.evaluate(expression, false);
    }

    @Override
    public void registerJsMethod(String name, BaseController controller) {
        String js = "";
        Method mtd = controller.getJsMethod(name);
        String parameters = "";
        String parametersJson = "";
        int i = 0;
        for (Class<?> par : mtd.getParameterTypes()) {
            if (parameters.equals("")) {
                parameters = parameters + "par" + i;
                parametersJson = parametersJson + "\"par" + i + "\":par" + i;
            } else {
                parameters = parameters + ",par" + i;
                parametersJson = parametersJson + ",\"par" + i + "\":par" + i;
            }
            ++i;
        }
        js = js + "\nfunction " + name + "(" + parameters + "){\nvar xhr = new XMLHttpRequest();\nvar url = \"index?controllerId=" + controller.getId() + "\";\nxhr.open(\"POST\", url, true);\nxhr.setRequestHeader(\"Content-Type\", \"application/json\");\nxhr.onreadystatechange = function () {\n    if (xhr.readyState === 4 && xhr.status === 200) {\n        var json = JSON.parse(xhr.responseText);\n        console.log(\" status -->, \" + json.status);\n    }\n};\nvar arguments = {" + parametersJson + "};\nvar json = {method:\"" + name + "\",arg:arguments};\nvar data = JSON.stringify(json);\nxhr.send(data);\n}\n";
        this.getDocument().addScriptChild(js);
    }

    public void setDropListener(Listener listener) {
        this.dropListener = listener;
        this.getDocument().setAttribute("draggable", "true");
        this.getDocument().setAttribute("ondragstart", "controller_" + this.controller.getId() + "_onDragEnter");
        this.getDocument().setAttribute("ondragend", "controller_" + this.controller.getId() + "_onDragEnd()");
    }

    @Override
    public final void onDragEnter() {
    }

    @Override
    public final void onDragEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluate(String expression, boolean firstValidView) {
        try {
            Session ses;
            String sendExpressione = expression;
            if (expression.startsWith("return ")) {
                sendExpressione = expression.substring(7);
            }
            if ((ses = WSEvent.sessions.get(this.controller.getId())) == null) {
                if (firstValidView) {
                    for (Map.Entry<String, Session> entry : WSEvent.sessions.entrySet()) {
                        if (!entry.getValue().isOpen()) continue;
                        ses = entry.getValue();
                        break;
                    }
                } else {
                    return null;
                }
            }
            String threadId = Thread.currentThread().getName() + "" + Thread.currentThread().getId();
            WSEvent.returns.remove(threadId);
            JsonObject newObject = new JsonObject();
            newObject.addProperty("ThreadId", threadId);
            newObject.addProperty("evaluate", sendExpressione);
            RemoteEndpoint remoteEndpoint = ses.getRemote();
            synchronized (remoteEndpoint) {
                ses.getRemote().sendString(newObject.toString());
            }
            Thread.sleep(50L);
            JsonElement objReturn = null;
            int i = 0;
            while (!WSEvent.returns.containsKey(threadId)) {
                try {
                    if (i > 600) break;
                    Thread.sleep(100L);
                    ++i;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((objReturn = WSEvent.returns.remove(threadId)) != null) {
                if (objReturn.isJsonPrimitive() && objReturn.getAsString().equals("undefined")) {
                    return null;
                }
                if (expression.startsWith("return ")) {
                    if (objReturn.toString().equals("{}")) {
                        return "EMPTY_OBJECT";
                    }
                    return objReturn.getAsString();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public void waitViewReady() throws IOException {
        Session ses = WSEvent.sessions.get(this.controller.getId());
        int i = 0;
        while (!WSEvent.sessions.containsKey(this.controller.getId())) {
            try {
                if (i > 600) break;
                Thread.sleep(100L);
                ++i;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (WSEvent.sessions.get(this.controller.getId()) == null) {
            throw new IOException("No WebSocketComunication Extabilished");
        }
    }

    @Override
    public void close() {
        this.evaluate("window.close();");
    }

    @Override
    public Object getWindow() {
        return null;
    }

    @Override
    public void forceActive() {
        this.evaluate("window.focus()");
    }

    @Override
    public void setActive() {
        this.evaluate("window.focus()");
    }

    @Override
    public void execute(String expression) {
        this.evaluate(expression);
    }

    @Override
    public void stopBuffering() {
    }

    public void onClose(Listener listener) {
    }

    @Override
    public void setDimension(int width, int height) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public void maximize() {
    }

    @Override
    public void minimize(boolean minimize) {
    }

    @Override
    public int getInnerCurrentWidth() {
        return this.width;
    }

    @Override
    public int getInnerCurrentHeight() {
        return this.heigth;
    }

    @Override
    public void onResize(Runnable runnable) {
    }

    @Override
    public void redraw() {
    }

    @Override
    public void setMinDimension(int width, int height) {
    }

    @Override
    public void setDraggableDimension(int width, int height) {
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public int getShellWidth() {
        return -1;
    }

    @Override
    public int getShellHeight() {
        return -1;
    }

    public void onShow(Listener listener) {
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public Point getLocation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void toggleMaximization() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isMaximized() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDraggableBarDimension(int width, int height) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void enableDropEvent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void onMaximizationChange(Runnable run) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void centerOnScreen() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTitle() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDragAndDropInnerArea(DragAndDropInnerArea dada) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addDragAndDropInnerArea(DragAndDropInnerArea dada) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDragAndDropEnabled(boolean dragAndDropEnabled) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> getDocumentStyles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void onDragError() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        controllerMap = new HashMap();
        server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setHost("localhost");
        connector.setPort(8888);
        server.addConnector((Connector)connector);
        ServletContextHandler handler = new ServletContextHandler(1);
        handler.setContextPath("/");
        server.setHandler((Handler)handler);
        ServletHolder holderEvents = new ServletHolder("ws", WSServlet.class);
        handler.addServlet(holderEvents, "/ws");
        handler.addServlet(JettyResource.class, "/index");
        handler.addServlet(JettyRedirect.class, "/redirect");
    }
}

