/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.BaseController;
import esecurity.desktop.DOMEvent;
import esecurity.desktop.Event;
import esecurity.desktop.JsUtils;
import esecurity.desktop.Listener;
import esecurity.desktop.Region;
import esecurity.desktop.ResUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.Appendable;
import esecurity.desktop.dom.DOMElementList;
import esecurity.desktop.jetty.JettyView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOMElement
implements Appendable {
    protected static final Logger logger = LoggerFactory.getLogger(DOMElement.class);
    protected static final String DOCUMENT = "document";
    protected StringBuilder jsToEvaluateElement;
    protected View view;
    protected String id = "";

    DOMElement(String jsToEvaluateElement, View view) {
        this.jsToEvaluateElement = new StringBuilder(jsToEvaluateElement.length()).append(jsToEvaluateElement);
        this.view = view;
    }

    DOMElement(StringBuilder jsToEvaluateElement, View view) {
        this.jsToEvaluateElement = jsToEvaluateElement;
        this.view = view;
    }

    public DOMElement(String jsToEvaluateElement, View view, String id) {
        this.jsToEvaluateElement = new StringBuilder(jsToEvaluateElement.length()).append(jsToEvaluateElement);
        this.view = view;
        this.id = id;
    }

    public DOMElement(StringBuilder jsToEvaluateElement, View view, String id) {
        this.jsToEvaluateElement = jsToEvaluateElement;
        this.view = view;
        this.id = id;
    }

    public StringBuilder getJsToEvaluateElement() {
        return this.jsToEvaluateElement;
    }

    public DOMElement getElementById(String id) {
        StringBuilder evalueteJsElement = new StringBuilder().append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")");
        Object ret = null;
        try {
            ret = this.view.evaluate(new StringBuilder(evalueteJsElement.length() * 2 + 28).append("return (").append((CharSequence)evalueteJsElement).append("!=null&&").append((CharSequence)evalueteJsElement).append("!=undefined)").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret != null && ret.toString().equals("true")) {
            return new DOMElement(evalueteJsElement.toString(), this.view, id);
        }
        return null;
    }

    public static DOMElement getElementById(String id, View currentView) {
        StringBuilder evaluateJsElement = new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")");
        Object ret = null;
        try {
            ret = currentView.evaluate(new StringBuilder(evaluateJsElement.length() * 2 + 28).append("return (").append((CharSequence)evaluateJsElement).append("!=null&&").append((CharSequence)evaluateJsElement).append("!=undefined)").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret != null && ret.toString().equals("true")) {
            return new DOMElement(evaluateJsElement.toString(), currentView, id);
        }
        return null;
    }

    public DOMElementList getElementsByClassName(String className) {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + className.length() + 29).append((CharSequence)this.jsToEvaluateElement).append(".getElementsByClassName(\"").append(JsUtils.escapeJs(className)).append("\")");
        DOMElementList objReturn = new DOMElementList(evalueteJsElement, this.view);
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate("return (" + evalueteJsElement + "!=null&&" + evalueteJsElement + "!=undefined)");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret.booleanValue()) {
            Object val = this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 14).append("return ").append((CharSequence)evalueteJsElement).append(".length").toString());
            int size = 0;
            if (val != null) {
                size = val instanceof Double ? ((Double)val).intValue() : Integer.parseInt("" + val);
            }
            objReturn.setSize(size);
        }
        return objReturn;
    }

    public DOMElementList getElementsByTagName(String tagName) {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + tagName.length() + 26).append((CharSequence)this.jsToEvaluateElement).append(".getElementsByTagName(\"").append(JsUtils.escapeJs(tagName)).append("\")");
        DOMElementList objReturn = new DOMElementList(evalueteJsElement, this.view);
        if (this.isElementPresent(evalueteJsElement.toString())) {
            Object val = this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 14).append("return ").append((CharSequence)evalueteJsElement).append(".length").toString());
            int size = 0;
            if (val != null) {
                size = val instanceof Double ? ((Double)val).intValue() : Integer.parseInt((String)val);
            }
            objReturn.setSize(size);
        }
        return objReturn;
    }

    public DOMElementList getElementsByName(String name) {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + name.length() + 24).append((CharSequence)this.jsToEvaluateElement).append(".getElementsByName(\"").append(JsUtils.escapeJs(name)).append("\")");
        DOMElementList objReturn = new DOMElementList(evalueteJsElement, this.view);
        if (this.isElementPresent(evalueteJsElement.toString())) {
            Object val = this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 14).append("return ").append((CharSequence)evalueteJsElement).append(".length").toString());
            int size = 0;
            if (val != null) {
                size = val instanceof Double ? ((Double)val).intValue() : Integer.parseInt((String)val);
            }
            objReturn.setSize(size);
        }
        return objReturn;
    }

    public double getOffsetWidth() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 12).append((CharSequence)this.jsToEvaluateElement).append(".offsetWidth");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            return (Double)this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return 0.0;
    }

    public double getOffsetHeight() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 13).append((CharSequence)this.jsToEvaluateElement).append(".offsetHeight");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            return (Double)this.view.evaluate("return " + evalueteJsElement);
        }
        return 0.0;
    }

    public static double getOffsetWidth(String id, View view) {
        StringBuilder evalueteJsElement = new StringBuilder(id.length() + 41).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").offsetWidth");
        if (DOMElement.isElementPresent(evalueteJsElement.toString(), view)) {
            return (Double)view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return 0.0;
    }

    public static double getOffsetHeight(String id, View view) {
        StringBuilder evalueteJsElement = new StringBuilder(id.length() + 42).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").offsetHeight");
        if (DOMElement.isElementPresent(evalueteJsElement.toString(), view)) {
            return (Double)view.evaluate("return " + evalueteJsElement);
        }
        return 0.0;
    }

    public double getClientHeight() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 13).append((CharSequence)this.jsToEvaluateElement).append(".clientHeight");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            return (Double)this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return 0.0;
    }

    public double getClientWidth() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 12).append((CharSequence)this.jsToEvaluateElement).append(".clientWidth");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            return (Double)this.view.evaluate("return " + evalueteJsElement);
        }
        return 0.0;
    }

    public static double getClientHeight(String id, View view) {
        StringBuilder evalueteJsElement = new StringBuilder(id.length() + 42).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").clientHeight");
        if (DOMElement.isElementPresent(evalueteJsElement.toString(), view)) {
            return (Double)view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return 0.0;
    }

    public static double getClientWidth(String id, View view) {
        StringBuilder evalueteJsElement = new StringBuilder(id.length() + 41).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").clientWidth");
        if (DOMElement.isElementPresent(evalueteJsElement.toString(), view)) {
            return (Double)view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return 0.0;
    }

    public String getAttribute(String attribute) {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + attribute.length() + 19).append((CharSequence)this.jsToEvaluateElement).append(".getAttribute(\"").append(JsUtils.escapeJs(attribute)).append("\")");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            return (String)this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return null;
    }

    public String getStyle(String property) {
        StringBuilder evaluateJsElement = new StringBuilder(this.jsToEvaluateElement.length() + property.length() + 7).append((CharSequence)this.jsToEvaluateElement).append(".style.").append(property);
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate(new StringBuilder(evaluateJsElement.length() * 3 + 36).append("return (").append((CharSequence)evaluateJsElement).append("!=null&&").append((CharSequence)evaluateJsElement).append("!=undefined&&").append((CharSequence)evaluateJsElement).append("!==\"\")").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret.booleanValue()) {
            return (String)this.view.evaluate(new StringBuilder(evaluateJsElement.length() + 7).append("return ").append((CharSequence)evaluateJsElement).toString());
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
        this.setAttribute("id", id);
    }

    public void setAttribute(String attribute, String value) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + attribute.length() + value.length() + 25).append((CharSequence)this.jsToEvaluateElement).append(".setAttribute(\"").append(JsUtils.escapeJs(attribute)).append("\",\"").append(JsUtils.escapeJs(value)).append("\");").toString());
    }

    public void removeAttribute(String attribute) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + attribute.length() + 23).append((CharSequence)this.jsToEvaluateElement).append(".removeAttribute(\"").append(JsUtils.escapeJs(attribute)).append("\");").toString());
    }

    public String getTextContent() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 12).append((CharSequence)this.jsToEvaluateElement).append(".textContent");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            return (String)this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return null;
    }

    public void setTextContent(String text) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + text.length() + 18).append((CharSequence)this.jsToEvaluateElement).append(".textContent=\"").append(JsUtils.escapeJs(text)).append("\";").toString());
    }

    public void setVisible(boolean visibility) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 26).append((CharSequence)this.jsToEvaluateElement).append(".style.display = \"").append(visibility ? "" : "none").append("\";").toString());
    }

    public static void setVisible(String id, boolean visibility, View view) {
        view.execute(new StringBuilder(id.length() + 55).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").style.display = \"").append(visibility ? "" : "none").append("\";").toString());
    }

    public void hide() {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 29).append((CharSequence)this.jsToEvaluateElement).append(".style.visibility=\"hidden\";").toString());
    }

    public void show() {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 32).append((CharSequence)this.jsToEvaluateElement).append(".style.visibility = \"visible\";").toString());
    }

    public void setStyle(String property, String value) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + property.length() + value.length() + 13).append((CharSequence)this.jsToEvaluateElement).append(".style.").append(property).append("=\"").append(JsUtils.escapeJs(value)).append("\";").toString());
    }

    public static void setStyle(String id, String property, String value, View view) {
        view.execute(new StringBuilder(id.length() + property.length() + value.length() + 44).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").style.").append(property).append(" = \"").append(JsUtils.escapeJs(value)).append("\";").toString());
    }

    public boolean isDisplayed() {
        StringBuilder evaluateJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 14).append((CharSequence)this.jsToEvaluateElement).append(".style.display");
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate(new StringBuilder(evaluateJsElement.length() * 3 + 41).append("return (").append((CharSequence)evaluateJsElement).append("!=null&&").append((CharSequence)evaluateJsElement).append("!=undefined&&").append((CharSequence)evaluateJsElement).append("!==\"none\")").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    public static boolean isDisplayed(String id, View view) {
        StringBuilder evaluateJsElement = new StringBuilder(id.length() + 43).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").style.display");
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)view.evaluate(new StringBuilder(evaluateJsElement.length() * 3 + 41).append("return (").append((CharSequence)evaluateJsElement).append("!=null&&").append((CharSequence)evaluateJsElement).append("!=undefined&&").append((CharSequence)evaluateJsElement).append("!==\"none\")").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    public static void createElementWithID(String tagName, String elementID, View view) {
        view.execute(new StringBuilder(elementID.length() * 3 + tagName.length() + 43).append("var ").append(elementID).append("=document.createElement(\"").append(JsUtils.escapeJs(tagName)).append("\");").append(elementID).append(".id=\"").append(JsUtils.escapeJs(elementID)).append("\";").toString());
    }

    public void createElementWithIDAndAppendIt(String tagName, String elementID, String parentID) {
        StringBuilder evaluate = parentID != null ? new StringBuilder(tagName.length() + elementID.length() + parentID.length() + 102).append("var elem = document.createElement(\"").append(JsUtils.escapeJs(tagName)).append("\");elem.id=\"").append(JsUtils.escapeJs(elementID)).append("\";document.getElementById(\"").append(JsUtils.escapeJs(parentID)).append("\").appendChild(elem);") : new StringBuilder(tagName.length() + elementID.length() + 83).append("var elem=document.createElement(\"").append(JsUtils.escapeJs(tagName)).append("\");elem.id=\"").append(JsUtils.escapeJs(elementID)).append("\";document.body.appendChild(elem);");
        this.view.execute(evaluate.toString());
    }

    public void createElementAndAppendIt(String tagName, String parentID) {
        String evaluate = parentID != null ? new StringBuilder(tagName.length() + this.jsToEvaluateElement.length() + parentID.length() + 74).append("var elem=document.createElement(\"").append(JsUtils.escapeJs(tagName)).append("\");").append((CharSequence)this.jsToEvaluateElement).append(".getElementById(\"").append(JsUtils.escapeJs(parentID)).append("\")").append(".appendChild(elem);").toString() : new StringBuilder(tagName.length() + 68).append("var elem=document.createElement(\"").append(JsUtils.escapeJs(tagName)).append("\");document.body.appendChild(elem);").toString();
        this.view.execute(evaluate);
    }

    public DOMElement createElementWithIDAppendAndReturnIt(String tagName, String elementID, String parentID) {
        StringBuilder evaluate = parentID != null ? new StringBuilder(tagName.length() + elementID.length() + parentID.length() + 98).append("var elem=document.createElement(\"").append(JsUtils.escapeJs(tagName)).append("\");elem.id=\"").append(JsUtils.escapeJs(elementID)).append("\";document.getElementById(\"").append(JsUtils.escapeJs(parentID)).append("\").appendChild(elem);") : new StringBuilder(tagName.length() + elementID.length() + 84).append("var elem=document.createElement(\"").append(JsUtils.escapeJs(tagName)).append("\");elem.id=\"").append(JsUtils.escapeJs(elementID)).append("\";document.body.appendChild(elem);");
        try {
            this.view.execute(evaluate.toString());
            return this.getElementById(elementID);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void addHTMLtoElement(String content) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + content.length() + 17).append((CharSequence)this.jsToEvaluateElement).append(".innerHTML += \"").append(JsUtils.escapeJs(content)).append("\";").toString());
    }

    public static void addHTMLtoElement(String id, String content, View view) {
        view.execute(new StringBuilder(id.length() + content.length() + 44).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")").append(".innerHTML += \"").append(JsUtils.escapeJs(content)).append("\";").toString());
    }

    public void setDisable(boolean disable) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 16).append((CharSequence)this.jsToEvaluateElement).append(".disabled=").append(disable ? "true" : "false").append(";").toString());
    }

    public static void setDisable(String id, boolean disable, View view) {
        view.execute(new StringBuilder(id.length() + 51).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").disabled = \"").append(disable ? "true" : "false").append("\";").toString());
    }

    public String getInnerHTML() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 10).append((CharSequence)this.jsToEvaluateElement).append(".innerHTML");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            return (String)this.view.evaluate("return " + evalueteJsElement);
        }
        return null;
    }

    public void setInnerHTML(String text) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + text.length() + 18).append((CharSequence)this.jsToEvaluateElement).append(".innerHTML = \"").append(JsUtils.escapeJs2(text)).append("\";").toString());
    }

    public static void setInnerHTML(String id, String text, View view) {
        view.execute(new StringBuilder(id.length() + text.length() + 48).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\").innerHTML = \"").append(JsUtils.escapeJs2(text)).append("\";").toString());
    }

    public void appendInnerHTML(String text) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + this.jsToEvaluateElement.length() + text.length() + 27).append((CharSequence)this.jsToEvaluateElement).append(".innerHTML=").append((CharSequence)this.jsToEvaluateElement).append(".innerHTML + \"").append(JsUtils.escapeJs2(text)).append("\";").toString());
    }

    public void addJavascriptEventListener(String event, String function) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + event.length() + function.length() + 23).append((CharSequence)this.jsToEvaluateElement).append(".addEventListener(\"").append(JsUtils.escapeJs(event)).append("\",").append(function).append(");").toString());
    }

    public static void addJavascriptEventListener(String elementId, View view, String event, String function) {
        view.execute(new StringBuilder(elementId.length() + event.length() + function.length() + 50).append("document.getElementById(\"").append(JsUtils.escapeJs(elementId)).append("\").addEventListener(\"").append(JsUtils.escapeJs(event)).append("\",").append(function).append(");").toString());
    }

    public void addJavaEventListener(DOMEvent event, Listener<Event> listener, boolean replaceAll) {
        this.view.setEventListenerById(this.id, event, listener, replaceAll);
    }

    public static void addJavaEventListener(View view, String id, DOMEvent event, Listener<Event> listener, boolean replaceAll) {
        view.setEventListenerById(id, event, listener, replaceAll);
    }

    public void removeJavaEventListener(DOMEvent event, Listener<Event> listener) {
        this.view.removeEventListenerById(this.id, event, listener);
    }

    public static void removeJavaEventListener(View view, String id, DOMEvent event, Listener<Event> listener) {
        view.removeEventListenerById(id, event, listener);
    }

    public void simulateAction(String event) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + event.length() + 5).append((CharSequence)this.jsToEvaluateElement).append(".").append(JsUtils.escapeJs(event)).append("();").toString());
    }

    public void setInnerPageFragment(BaseController controller) {
        try {
            Document html = ResUtils.composeHtml(controller, true, new ArrayList<String>());
            controller.setView(this.view);
            if (this.view instanceof JettyView) {
                JettyView.controllerMap.put(controller.getId(), controller);
            }
            Elements style = html.getElementsByTag("style");
            Elements scripts = html.getElementsByTag("script");
            Element body = html.body();
            String bodyHtml = JsUtils.escapeJs2(body.html());
            this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + bodyHtml.length() + 16).append((CharSequence)this.jsToEvaluateElement).append(".innerHTML= \"").append(bodyHtml).append("\"").toString());
            StringBuilder sb = new StringBuilder();
            List<String> mainStyles = this.view.getDocumentStyles();
            for (Element st : style) {
                if (mainStyles.contains(st.attr("id"))) continue;
                sb.append(JsUtils.escapeJs2(st.outerHtml()));
                mainStyles.add(st.attr("id"));
            }
            this.view.execute(new StringBuilder(sb.length() + 94).append("var head = document.getElementsByTagName(\"head\")[0]; head.innerHTML = head.innerHTML + \"").append((CharSequence)sb).append("\";").toString());
            for (int i = 0; i < scripts.size(); ++i) {
                String scr = JsUtils.escapeJs2(((Element)scripts.get(i)).html());
                this.view.execute(new StringBuilder(controller.getId().length() + scr.length() + 205).append("try{var sc = document.createElement(\"script\"); sc.id = \"script_").append(controller.getId()).append("_").append(i).append("\"; var t = document.createTextNode(\"").append(scr).append("\");sc.appendChild(t);document.head.appendChild(sc);}catch(exception){error(exception.stack);}").toString());
            }
            for (String name : controller.getJsMethodNames()) {
                this.view.registerJsMethod(name, controller);
            }
            controller.viewOnLoad();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addScriptChild(String script) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + script.length() + 108).append("var scrip=").append((CharSequence)this.jsToEvaluateElement).append(".createElement(\"script\");\nscript.innerHTML=\"").append(JsUtils.escapeJs2(script)).append("\";document.getElementsByTagName(\"body\")[0].appendChild(script);").toString());
    }

    public void addClass(String className) {
        this.view.execute(new StringBuilder(this.id.length() + className.length() + 17).append("addClass(\"").append(this.id).append("\", \"").append(className).append("\");").toString());
    }

    public static void addClass(String id, String className, View view) {
        view.execute(new StringBuilder(id.length() + className.length() + 17).append("addClass(\"").append(id).append("\", \"").append(className).append("\");").toString());
    }

    public void toggleClass(String className) {
        this.view.execute(new StringBuilder(this.id.length() + className.length() + 24).append("toggleClass(\"").append(this.id).append("\", \"").append(className).append("\");").toString());
    }

    public static void toggleClass(String id, String className, View view) {
        view.execute(new StringBuilder(id.length() + className.length() + 24).append("toggleClass(\"").append(id).append("\", \"").append(className).append("\");").toString());
    }

    public void removeClass(String className) {
        this.view.execute(new StringBuilder(this.id.length() + className.length() + 24).append("removeClass(\"").append(this.id).append("\", \"").append(className).append("\");").toString());
    }

    public static void removeClass(String id, String className, View view) {
        view.execute(new StringBuilder(id.length() + className.length() + 24).append("removeClass(\"").append(id).append("\", \"").append(className).append("\");").toString());
    }

    public boolean hasClass(String className) {
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate(new StringBuilder(this.id.length() + className.length() + 28).append("return hasClass(\"").append(this.id).append("\", \"").append(className).append("\");").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    public void remove() {
        this.view.execute(new StringBuilder(this.id.length() + 13).append("remove(\"").append(this.id).append("\");").toString());
    }

    public static void remove(String elementId, View view) {
        view.execute(new StringBuilder(elementId.length() + 13).append("remove(\"").append(JsUtils.escapeJs(elementId)).append("\");").toString());
    }

    public String getId() {
        if (this.id == null || this.id.isEmpty()) {
            Object ret = null;
            try {
                ret = this.view.evaluate(new StringBuilder(this.jsToEvaluateElement.length() + 11).append("return ").append((CharSequence)this.jsToEvaluateElement).append(".id;").toString());
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            if (ret != null) {
                this.id = (String)ret;
            }
        }
        return this.id;
    }

    public static String getSelectedText(View view) {
        Object ret = null;
        try {
            ret = view.evaluate("var text=\"\";\nif(window.getSelection){\ntext = window.getSelection().toString();\n}else if(document.selection && document.selection.type!=\"Control\"){\ntext = document.selection.createRange().text;\n}\nreturn text;\n");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret != null) {
            return (String)ret;
        }
        return null;
    }

    public Region getBoundingClientRect() {
        String ret = null;
        try {
            ret = (String)this.view.evaluate(new StringBuilder(this.id.length() + 35).append("return getBoundingClientRect(\"").append(this.id).append("\");").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret != null) {
            String[] positions = ret.split(";");
            Region reg = new Region((int)Float.parseFloat(positions[3]), (int)Float.parseFloat(positions[0]), (int)(Float.parseFloat(positions[1]) - Float.parseFloat(positions[3])), (int)(Float.parseFloat(positions[2]) - Float.parseFloat(positions[0])));
            return reg;
        }
        return null;
    }

    public boolean isContained(String containerId) {
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate(new StringBuilder(this.id.length() + containerId.length() + 31).append("return isContained(\"").append(this.id).append("\", \"").append(containerId).append("\");").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    public void insertAfter(String elementId) {
        this.view.execute(new StringBuilder(this.id.length() + elementId.length() + 24).append("insertAfter(\"").append(this.id).append("\", \"").append(elementId).append("\");").toString());
    }

    public void insertBefore(String elementId) {
        this.view.execute(new StringBuilder(this.id.length() + elementId.length() + 25).append("insertBefore(\"").append(this.id).append("\", \"").append(elementId).append("\");").toString());
    }

    public int getScrollTop() {
        double ret = 0.0;
        try {
            ret = (Double)this.view.evaluate("return getScrollTop(\"" + this.id + "\");");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return (int)ret;
    }

    @Override
    public void appendChild(DOMElement child) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + child.getId().length() + 15).append((CharSequence)this.jsToEvaluateElement).append(".appendChild(").append(child.getId()).append(");").toString());
    }

    public static void appendChild(String parentId, String childId, View view) {
        view.execute(new StringBuilder(parentId.length() + childId.length() + 43).append("document.getElementById(\"").append(parentId).append("\").appendChild(").append(childId).append(");").toString());
    }

    public void removeChild(DOMElement child) {
        this.removeChild(child.getId());
    }

    public void removeChild(String childId) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + childId.length() + 15).append((CharSequence)this.jsToEvaluateElement).append(".removeChild(").append(childId).append(");").toString());
    }

    public static void removeChild(String parentId, String childId, View view) {
        view.execute(new StringBuilder(parentId.length() + childId.length() + 44).append("document.getElementById(\"").append(parentId).append("\").removeChild(").append(childId).append(");").toString());
    }

    public void focus() {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 10).append((CharSequence)this.jsToEvaluateElement).append(".focus();").toString());
    }

    public static void focus(String id, View view) {
        view.execute(new StringBuilder(id.length() + 38).append("document.getElementById(\"").append(id).append("\").focus();").toString());
    }

    public void blur() {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 7).append((CharSequence)this.jsToEvaluateElement).append(".blur()").toString());
    }

    public static void blur(String id, View view) {
        view.execute(new StringBuilder(id.length() + 35).append("document.getElementById(\"").append(id).append("\").blur();").toString());
    }

    protected static boolean exist(String id, View view) {
        StringBuilder evaluateJsElement = new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")");
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)view.evaluate("return (" + evaluateJsElement + "!=null&&" + evaluateJsElement + "!=undefined)");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    public void onClick(Listener<Event> listener) {
        this.addJavaEventListener(DOMEvent.CLICK, listener, true);
    }

    public void onDoubleClick(Listener<Event> listener) {
        this.addJavaEventListener(DOMEvent.DBLCLICK, listener, true);
    }

    public void onChange(Listener<Event> listener) {
        this.addJavaEventListener(DOMEvent.CHANGE, listener, true);
    }

    public void onMouseUp(Listener<Event> listener) {
        this.addJavaEventListener(DOMEvent.MOUSEUP, listener, true);
    }

    public void onKeyUp(Listener<Event> listener) {
        this.addJavaEventListener(DOMEvent.KEYUP, listener, true);
    }

    public void onKeyPress(Listener<Event> listener) {
        this.addJavaEventListener(DOMEvent.KEYPRESS, listener, true);
    }

    public static boolean isElementPresent(String jsElementQuery, View view) {
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)view.evaluate(new StringBuilder(jsElementQuery.length() * 2 + 28).append("return (").append(jsElementQuery).append("!=null&&").append(jsElementQuery).append("!=undefined)").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret != null) {
            return ret;
        }
        return false;
    }

    protected boolean isElementPresent(String jsElementQuery) {
        return DOMElement.isElementPresent(jsElementQuery, this.view);
    }
}

