/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop;

import esecurity.desktop.BaseController;
import esecurity.desktop.Region;
import esecurity.desktop.View;
import esecurity.desktop.ViewFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ViewBuilder.class);
    private boolean resizable = true;
    private boolean onTop = false;
    private boolean decorated = true;
    private View.ModalType modalType = View.ModalType.NONE;
    private Region viewArea = new Region(0, 0, 100, 100);
    private Region dragArea = null;
    private View parent = null;
    private BaseController controller;
    private String title = "";
    private byte[] image = null;

    public ViewBuilder(BaseController controller) {
        this.controller = controller;
    }

    public ViewBuilder setImage(byte[] image) {
        this.image = image;
        return this;
    }

    public ViewBuilder setViewArea(Region viewArea) {
        this.viewArea = viewArea;
        return this;
    }

    public ViewBuilder setResizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    public ViewBuilder setOnTop(boolean onTop) {
        this.onTop = onTop;
        return this;
    }

    public ViewBuilder setDecorated(boolean decorated) {
        this.decorated = decorated;
        return this;
    }

    public ViewBuilder setModalType(View.ModalType modalType) {
        this.modalType = modalType;
        return this;
    }

    public ViewBuilder setDragArea(Region dragArea) {
        this.dragArea = dragArea;
        return this;
    }

    public ViewBuilder setParent(View parent) {
        this.parent = parent;
        return this;
    }

    public ViewBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public View build() {
        try {
            return ViewFactory.newInstance(this.controller, this.parent, this.title, this.image, this.modalType, this.viewArea, this.dragArea, this.decorated, this.resizable, this.onTop);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

