/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import it.actalis.ellips.capi.core.CapiException;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class TimeStampAndCRL {
    private byte[] a = null;
    private byte[] b = null;

    public byte[] getCRL() {
        return Arrays.copyOf((byte[])this.a, (int)this.a.length);
    }

    public byte[] getTimeStampToken() {
        return Arrays.copyOf((byte[])this.b, (int)this.b.length);
    }

    public void setCRL(byte[] byArray) {
        this.a = Arrays.copyOf((byte[])byArray, (int)byArray.length);
    }

    public void setTimeStampToken(byte[] byArray) {
        this.b = Arrays.copyOf((byte[])byArray, (int)byArray.length);
    }

    public DERSequence getDERSequence() throws CapiException {
        if (this.b == null) {
            throw new CapiException("No TimeStampToken in TimeStampandCRL", 50040);
        }
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])this.b);
            aSN1EncodableVector.add((ASN1Encodable)aSN1Primitive);
            if (this.a != null) {
                aSN1Primitive = ASN1Primitive.fromByteArray((byte[])this.a);
                aSN1EncodableVector.add((ASN1Encodable)aSN1Primitive);
            }
            aSN1EncodableVector = new DERSequence(aSN1EncodableVector);
            return aSN1EncodableVector;
        }
        catch (IOException iOException) {
            throw new CapiException("IOException getting TimeStampToken", 50040);
        }
    }

    public byte[] getEncoded() throws CapiException {
        DERSequence dERSequence = this.getDERSequence();
        if (dERSequence == null) {
            throw new CapiException("No TimeStampToken in TimeStampandCRL", 50040);
        }
        try {
            return dERSequence.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CapiException("IOException getting TimeStampToken", 50040);
        }
    }
}

