/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.filter.Base64InputFilter;
import it.actalis.ellips.capi.datahandlers.inputs.filter.PEMInputFilter;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;

public class CRL {
    private static CertificateFactory a;
    private static final Logger b;
    public static final int reason_unspecified = 0;
    public static final int reason_keyCompromise = 1;
    public static final int reason_caCompromise = 2;
    public static final int reason_affiliationChanged = 3;
    public static final int reason_superseded = 4;
    public static final int reason_cessationOfOperation = 5;
    public static final int reason_certificateHold = 6;
    public static final int reason_removeFromCRL = 8;
    public static final int reason_privilegeWithdrawn = 9;
    public static final int reason_aACompromise = 10;
    private String c = "";
    private X509CRL d = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public CRL(byte[] object) throws CapiException {
        InputHandler inputHandler = null;
        try {
            inputHandler = DataHandlerBuilder.get().setBytes((byte[])object).buildInput();
            this.a(inputHandler);
        }
        catch (CapiException capiException) {
            try {
                object = capiException;
                throw capiException;
                catch (Exception exception) {
                    b.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("CRL format unknown or not implemented", 31000);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(inputHandler);
                throw throwable;
            }
        }
        Util.closeQuietly(inputHandler);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CRL(InputStream object) throws CapiException {
        InputHandler inputHandler = null;
        try {
            inputHandler = DataHandlerBuilder.get().setInputStream((InputStream)object).buildInput();
            this.a(inputHandler);
        }
        catch (CapiException capiException) {
            try {
                object = capiException;
                throw capiException;
                catch (Exception exception) {
                    b.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("CRL format unknown or not implemented", 31000);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(inputHandler);
                throw throwable;
            }
        }
        Util.closeQuietly(inputHandler);
    }

    private void a(InputHandler inputHandler) throws CapiException {
        try {
            int n = inputHandler.getInputAsNewStream().read();
            boolean bl = n == 48;
            if ((n = n == 45 ? 1 : 0) == 0 && !bl) {
                inputHandler.addFilter(new Base64InputFilter());
            } else if (n != 0) {
                inputHandler.addFilter(new PEMInputFilter());
            }
            this.d = (X509CRL)a.generateCRL(inputHandler.getInputAsNewStream());
            this.d.getIssuerX500Principal();
            return;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format unknown or not implemented", 31000);
        }
    }

    public String getEncoded() throws CapiException {
        try {
            if (this.d == null) {
                throw new CapiException("Internal error", 31003);
            }
            byte[] byArray = this.d.getEncoded();
            return Util.base64EncodeStr(byArray);
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public X509CRL getInternalCRL() {
        return this.d;
    }

    public byte[] getDEREncoded() throws CapiException {
        try {
            if (this.d == null) {
                throw new CapiException("Internal error", 31003);
            }
            byte[] byArray = this.d.getEncoded();
            return byArray;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public LinkedList<String> getIdps() throws CapiException {
        Object object;
        try {
            object = this.d.getExtensionValue("2.5.29.28");
            if (object == null) {
                b.debug("CRL Issuing DP extension not found");
                return null;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            IssuingDistributionPoint issuingDistributionPoint = IssuingDistributionPoint.getInstance((Object)aSN1InputStream.readObject());
            object = issuingDistributionPoint;
            if (issuingDistributionPoint == null) {
                return null;
            }
            DistributionPointName distributionPointName = object.getDistributionPoint();
            object = distributionPointName;
            GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
            object = generalNames;
            GeneralName[] generalNameArray = generalNames.getNames();
            object = new LinkedList();
            for (int i = 0; i < generalNameArray.length; ++i) {
                ASN1String aSN1String;
                if (generalNameArray[i].getTagNo() == 6) {
                    aSN1String = (ASN1String)generalNameArray[i].getName();
                    ((LinkedList)object).add(aSN1String.getString());
                    continue;
                }
                if (generalNameArray[i].getTagNo() == 4) {
                    aSN1String = (X500Name)generalNameArray[i].getName();
                    ((LinkedList)object).add(aSN1String.toString());
                    continue;
                }
                ((LinkedList)object).add(generalNameArray[i].toString());
            }
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Issuer name format alert", 31000);
        }
        return object;
    }

    public String getIssuerDN() throws CapiException {
        try {
            X500Principal x500Principal = this.d.getIssuerX500Principal();
            return x500Principal.getName();
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Issuer name format alert", 31000);
        }
    }

    public Date getExpiredCertsOnCRL() throws CapiException {
        try {
            Object object = this.d.getExtensionValue("2.5.29.60");
            if (object == null) {
                return null;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            ASN1GeneralizedTime aSN1GeneralizedTime = ASN1GeneralizedTime.getInstance((Object)aSN1InputStream.readObject());
            object = aSN1GeneralizedTime;
            if (aSN1GeneralizedTime == null) {
                return null;
            }
            Date date = object.getDate();
            object = date;
            return date;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("extension ExpiredCertsOnCRL alert", 31000);
        }
    }

    public boolean checkIssuingDistributionPoint(String string, boolean bl) throws CapiException {
        try {
            int n;
            Object object = this.d.getExtensionValue("2.5.29.28");
            if (object == null) {
                b.debug("CRL Issuing DP extension not found");
                return true;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            IssuingDistributionPoint issuingDistributionPoint = IssuingDistributionPoint.getInstance((Object)aSN1InputStream.readObject());
            object = issuingDistributionPoint;
            if (issuingDistributionPoint == null) {
                return true;
            }
            if (object.onlyContainsUserCerts() && !bl) {
                b.debug("CRL Issuing DP contains only user certificate match User certificate ");
            } else if (object.onlyContainsCACerts() && bl) {
                b.debug("CRL Issuing DP contains only CA certificate match CA certificate ");
            } else {
                b.debug("CRL not valid: CRL Issuing DP onlyContainsUserCerts is " + object.onlyContainsUserCerts() + " and mismatch certificate type");
                return false;
            }
            GeneralName[] generalNameArray = object.getDistributionPoint();
            generalNameArray = (GeneralNames)generalNameArray.getName();
            generalNameArray = generalNameArray.getNames();
            Vector vector = new Vector();
            object = vector;
            vector.setSize(0);
            for (int i = 0; i < generalNameArray.length; ++i) {
                ASN1String aSN1String;
                if (generalNameArray[i].getTagNo() == 6) {
                    aSN1String = (ASN1String)generalNameArray[i].getName();
                    ((Vector)object).addElement(aSN1String.getString());
                    continue;
                }
                if (generalNameArray[i].getTagNo() == 4) {
                    aSN1String = (X500Name)generalNameArray[i].getName();
                    ((Vector)object).addElement(aSN1String.toString());
                    continue;
                }
                ((Vector)object).addElement(generalNameArray[i].toString());
            }
            String[] stringArray = new String[((Vector)object).size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)((Vector)object).elementAt(n);
            }
            b.debug("Checking validity of Certificate DP: " + string);
            for (n = 0; n < stringArray.length; ++n) {
                b.debug("Verifying CRL Issuing DP: " + stringArray[n]);
                if (stringArray[n].compareToIgnoreCase(string) != 0) continue;
                b.debug("Found CRL Issuing DP matching Certificate DP");
                return true;
            }
            b.debug("CRL not valid: Not found CRL Issuing DP matching Certificate DP.");
            return false;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("exception checking IssuingDistributionPoint", 31000);
        }
    }

    public boolean canUseFor(Certificate certificate, Date stringArray) throws CapiException {
        boolean bl = false;
        String[] stringArray2 = certificate.getCdpURLs();
        Object object = new Date();
        if (stringArray != null) {
            object = stringArray;
        }
        if (this.d.getThisUpdate().after(certificate.getInternalCert().getNotBefore()) && (((Date)object).after(this.d.getThisUpdate()) && ((Date)object).before(this.d.getNextUpdate()) || this.d.getThisUpdate().after((Date)object))) {
            stringArray = certificate.getIssuerDN();
            object = this.getIssuerDN();
            if (CRL.a((String)stringArray).equalsIgnoreCase(CRL.a((String)object)) && stringArray2 != null) {
                stringArray = stringArray2;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    if (!this.checkIssuingDistributionPoint(string, certificate.getBasicConstraints())) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private static String a(String string) {
        try {
            Object object = new X509Principal(string);
            object = object.getValues(new ASN1ObjectIdentifier("2.5.4.3"));
            if (((Vector)object).size() > 0) {
                return (String)((Vector)object).get(0);
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public boolean canUseFor(X509Certificate x509Certificate, Date date) throws CertificateEncodingException, CapiException {
        return this.canUseFor(new Certificate(x509Certificate.getEncoded()), date);
    }

    public boolean isRevoked(BigInteger object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            object = this.d.getRevokedCertificate((BigInteger)object);
            return object != null;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public boolean isRevoked(byte[] object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            object = new Certificate((byte[])object);
            return this.d.isRevoked(((Certificate)object).getInternalCert());
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public boolean isRevokedAccordingToDigitPA(byte[] object, Date cloneable) throws CapiException {
        Date date;
        if (this.isRevoked((byte[])object)) {
            Date date2;
            try {
                object = new Certificate((byte[])object);
                date2 = Util.parseDate(this.getRevocationDate(((Certificate)object).getSerialNumber()), "yyyyMMddHHmmss");
            }
            catch (Exception exception) {
                b.debug("[doWork] No valid revocation date specified");
                return true;
            }
            if (cloneable != null && date2 != null) {
                return ((Date)cloneable).compareTo(date2) >= 0;
            }
            return true;
        }
        Certificate certificate = null;
        try {
            certificate = new Certificate((byte[])object);
            certificate.isValid();
            return false;
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return false;
        }
        catch (CapiException capiException) {
            object = capiException;
            throw capiException;
        }
        object = "yyyyMMddHHmmss";
        cloneable = new SimpleDateFormat((String)object);
        try {
            date = this.getExpiredCertsOnCRL();
        }
        catch (Exception exception) {
            throw new CapiException("CRL ExpiredCertsOnCRL parsing exception", 31003);
        }
        if (date == null) {
            throw new CapiException("Certificate expired, CRL without expired certs", 31009);
        }
        object = certificate.getValidityNotAfter((String)object);
        try {
            object = ((DateFormat)cloneable).parse((String)object);
        }
        catch (ParseException parseException) {
            throw new CapiException("Certificate expiry date parsing exception", 30002);
        }
        if (((Date)object).compareTo(date) >= 0) {
            return false;
        }
        throw new CapiException("Certificate has expired before the date in extension ExpiredCertsOnCRL ", 31012);
    }

    public String getThisUpdate(String string) throws CapiException {
        try {
            Date date = this.d.getThisUpdate();
            return Util.formatDate(date, string);
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String getNextUpdate(String string) throws CapiException {
        try {
            Date date = this.d.getNextUpdate();
            if (date == null) {
                return null;
            }
            return Util.formatDate(date, string);
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public void verify(byte[] object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            object = new Certificate((byte[])object);
            String string = this.d.getIssuerX500Principal().getName("RFC2253");
            String string2 = ((Certificate)object).getInternalCert().getSubjectX500Principal().getName();
            if (!string.equalsIgnoreCase(string2)) {
                b.debug("issuer: " + string);
                b.debug("subject: " + string2);
                throw new CapiException("IssuerDN does not match", 31002);
            }
            object = ((Certificate)object).getPublicKey();
            this.d.verify((PublicKey)object);
            return;
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (SignatureException signatureException) {
            b.debug(signatureException.getMessage(), (Throwable)signatureException);
            throw new CapiException("The signature is not valid", 31001);
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("The signature is not valid", 31001);
        }
    }

    public BigInteger[] listCertificates() throws CapiException {
        try {
            Object[] objectArray = this.d.getRevokedCertificates();
            if (objectArray == null || objectArray.isEmpty()) {
                return new BigInteger[0];
            }
            objectArray = objectArray.toArray();
            BigInteger[] bigIntegerArray = new BigInteger[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                X509CRLEntry x509CRLEntry = (X509CRLEntry)objectArray[i];
                bigIntegerArray[i] = x509CRLEntry.getSerialNumber();
            }
            return bigIntegerArray;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String[] listCertificates(char c2) throws CapiException {
        try {
            b.debug("CRL:listCertificates:getRevokedCertificates");
            Object[] objectArray = this.d.getRevokedCertificates();
            b.debug("CRL:listCertificates:set null ?");
            if (objectArray == null || objectArray.isEmpty()) {
                return new String[0];
            }
            b.debug("CRL:listCertificates:set not null");
            objectArray = objectArray.toArray();
            String[] stringArray = new String[objectArray.length];
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                X509CRLEntry x509CRLEntry = (X509CRLEntry)objectArray[i];
                stringBuffer.setLength(0);
                String string = Util.bigIntToHexStr(x509CRLEntry.getSerialNumber());
                stringBuffer.append(string);
                stringBuffer.append(c2);
                string = this.getRevocationDate(x509CRLEntry.getSerialNumber());
                stringBuffer.append(string);
                stringBuffer.append(c2);
                int n = this.getReasonCode(x509CRLEntry.getSerialNumber());
                stringBuffer.append(n);
                stringBuffer.append(c2);
                stringArray[i] = stringBuffer.toString();
            }
            return stringArray;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String getRevocationDate(BigInteger object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            object = this.d.getRevokedCertificate((BigInteger)object);
            if (object == null) {
                throw new CapiException("Cert is NOT revoked", 31004);
            }
            object = ((X509CRLEntry)object).getRevocationDate();
            return Util.formatDate((Date)object, null);
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public int getReasonCode(BigInteger object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            object = this.d.getRevokedCertificate((BigInteger)object);
            if (object == null) {
                throw new CapiException("Cert is NOT revoked", 31004);
            }
            if (!((X509CRLEntry)object).hasExtensions()) {
                return 0;
            }
            byte[] byArray = object.getExtensionValue(Extension.reasonCode.getId());
            object = byArray;
            if (byArray == null) {
                return 0;
            }
            object = (ASN1Enumerated)X509ExtensionUtil.fromExtensionValue((byte[])object);
            return object.getValue().intValue();
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        try {
            string = "CRL " + this.d.getType() + " version " + this.d.getVersion() + string + "Signature Algorithm: " + this.d.getSigAlgName() + string + "Issuer: " + this.getIssuerDN() + string + "this update: " + Util.formatDate(this.d.getThisUpdate(), "EEE, d MMM yyyy HH:mm:ss z") + string + "next update: " + Util.formatDate(this.d.getNextUpdate(), "EEE, d MMM yyyy HH:mm:ss z") + string + (this.d.getRevokedCertificates() != null && !this.d.getRevokedCertificates().isEmpty() ? this.d.getRevokedCertificates().size() : 0) + " revoked certificates" + string;
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            return null;
        }
        return string;
    }

    public String getDownloadedUrl() {
        return this.c;
    }

    public void setDownloadedUrl(String string) {
        this.c = string;
    }

    static {
        b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        try {
            a = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {}
    }
}

