/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

var sign_scrollVisible = false;

var SIGN_MIN_CELL_WIDTH = 260;

var sign_window = {
    width: 0,
    heigth: 0
};

/**
 * Richiamato ogni volta che la finestra di firma viene ridimensionata
 * 
 * @returns {undefined}
 */
function sign_resize() {
    try {
        var headWidth = $("#sign_fileTableHead_container").width();
        var headCellDocumentsWidth = $("#sign_fileTableHeadCellDocuments").width();
        var headCellOutputWidth = $("#sign_fileTableHeadCellOutput").width();

        if (sign_window.width > 0) {
            if (headCellDocumentsWidth <= 0) {
                headCellDocumentsWidth = headWidth / 2;
            }
            var dx = window.innerWidth - sign_window.width;
            sign_window.width = window.innerWidth;
            var newHeadCellDocumentsWidth = headCellDocumentsWidth + (dx / 2);
            if (headCellOutputWidth < SIGN_MIN_CELL_WIDTH) {
                newHeadCellDocumentsWidth = headCellDocumentsWidth + dx;
            }
            if (newHeadCellDocumentsWidth < SIGN_MIN_CELL_WIDTH) {
                newHeadCellDocumentsWidth = SIGN_MIN_CELL_WIDTH;
            }
            headCellDocumentsWidth = newHeadCellDocumentsWidth;
            $("#sign_fileTableHeadCellDocuments").width(newHeadCellDocumentsWidth);

            if (headWidth + 20 < headCellDocumentsWidth + headCellOutputWidth) {
                headCellDocumentsWidth = headWidth / 2;
                headCellOutputWidth = headCellDocumentsWidth;
                $("#sign_fileTableHeadCellDocuments").width(headCellDocumentsWidth);
                $("#sign_fileTableHeadCellOutput").width(headCellOutputWidth);
            }
        } else {
            sign_window.width = window.innerWidth;
        }

        $("#sign_fileTableHeadCellDocuments").resizable("option", "maxWidth", headWidth - 300);

        $(".sign_filesToSignTable_fileToSignName").width(headCellDocumentsWidth - 150);

        $("#sign_textContainer").width(window.innerWidth - 450);

        sign_refreshCellWidth();
    } catch (exception) {
        error(exception.stack);
    }
}

function set_asicE_height() {
    var tableHeight = $("#sign_fileToSignColumn").height();
    $("#sign_asicEFileColumn").css('bottom', tableHeight / 2);
}

/**
 * Richiamato ogni volta che la lista dei file viene modificata
 * 
 * @returns {undefined}
 */
function sign_refreshCellWidth() {
    try {
        var headWidth = $("#sign_fileTableHead_container").width();

        var leftHeadCellWidth = $("#sign_fileTableHeadCellDocuments").width();

        $("#sign_fileToSignColumn").width(leftHeadCellWidth);
        $("#sign_fileTableHeadCellOutput").width(headWidth - leftHeadCellWidth);

        $("#sign_asicEFileColumn").width(headWidth - leftHeadCellWidth);
        set_asicE_height();

        $("#sign_signedFileColumn").width(headWidth - leftHeadCellWidth);

        var rect = $("#sign_fileTableHeadCellDocuments")[0].getBoundingClientRect();
        $(".sign_filesToSignTable_fileToSignName").width(rect.width - 150);
    } catch (exception) {
        error(exception.stack);
    }
}

function sign_cellResized(cellId) {
    var rect = $("#" + cellId)[0].getBoundingClientRect();
    $("#sign_fileTableHeadCellDocuments").width(rect.width);
}

function sign_setTitleOnOverflow(elementId, text) {
    try {
        var element = document.getElementById(elementId);
        if (element.offsetWidth < element.scrollWidth) {
            element.setAttribute('title', text);
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function sign_signatureOutcomeAlignColumn() {
    try {
        var headWidth = $("#sign_SignatureOutcomePanel_errorDocumentsTableArea_tableHead").width();
        $("#sign_SignatureOutcomePanel_errorDocumentsTableArea_tableBody .cg-tableColumn").width((headWidth / 2) + 1);
    } catch (exception) {
        error(exception.stack);
    }
}

function sign_loadResizable() {
    $(".fileTableHeadCell").width("50%");
    $(".sign_tableColumn").width("50%");
    $("#sign_fileTableHeadCellDocuments").resizable({
        handles: "e",
        minWidth: 260,
        maxWidth: $("#sign_fileTableHead_container").width() - 300,
        resize: function (event, ui) {
            sign_refreshCellWidth();
        }
    });
}

function sign_toggleShowHideIcon(iconId, inputId) {
    try {
        var input = document.getElementById(inputId);
        if (input.getAttribute("type") == "password") {
            input.setAttribute("type", "text");
            removeClass(iconId, "cg-show-icon");
            addClass(iconId, "cg-hide-icon");
        } else {
            input.setAttribute("type", "password");
            removeClass(iconId, "cg-hide-icon");
            addClass(iconId, "cg-show-icon");
        }
    } catch (exception) {
        error(exception.stack);
    }
}

var isKeyPressSupported;

function addKeyPressEventListener(id) {
    if (typeof isKeyPressSupported === 'undefined' || isKeyPressSupported === null) {
        // L'evento keypress è deprecato https://developer.mozilla.org/en-US/docs/Web/API/Element/keypress_event
        isKeyPressSupported = checkIfKeyPressIsSupported();
    }
    if (isKeyPressSupported) {
        document.getElementById(id).addEventListener('keypress', signedFileNameInputKeyPress);
    } else {
        document.getElementById(id).addEventListener('keydown', signedFileNameInputKeyPress);
    }
}

function checkIfKeyPressIsSupported() {
    var el = document.createElement('input');
    eventName = 'onkeypress';
    var isSupported = (eventName in el);
    if (!isSupported) {
        el.setAttribute(eventName, 'return;');
        isSupported = typeof el[eventName] == 'function';
    }
    el = null;
    return isSupported;
}

/**
 * 
 * ------------------------------ START FilesToSignTable ------------------------------
 * 
 */

var forbiddenKey = ["\\", "/", ":", "*", "?", "\"", "<", ">", "|"];

/**
 * Previene l'inserimento di caratteri non supportati per i nomi dei 
 * @param {type} evt
 * @returns {undefined}
 */
function signedFileNameInputKeyPress(evt) {
    var key = evt.key;
    // Workaround per Xulrunner
    if (key == null || key == "" || key == "MozPrintableKey") {
        key = String.fromCharCode(evt.which);
    }
    if ($.inArray(key, forbiddenKey) >= 0) {
        evt.preventDefault();
        $controller$.showForbiddenCharMessage();
    }
}

/**
 * Aggiorna il nome del file firmato
 * @param {type} evt
 * @returns {undefined}
 */
function signedFileNameInputKeyUp(evt) {
    $controller$.updateFileToSignName(evt.target.id, document.getElementById(evt.target.id).value);
}

/**
 * 
 * ------------------------------ END FilesToSignTable ------------------------------
 * 
 */

/**
 * 
 * ------------------------------ START SignatureOperationPanel ------------------------------
 * 
 */

var signOP = {
    errorMessageId: null,
    userInputId: null,
    newUserPasswordInputId: null,
    loginPasswordInputId: null,
    otpInputId: null,
    otpErrorId: null,
    pinInputId: null,
    pinErrorId: null,
    loginPasswordInputErrorLabelId: null,
    userInputErrorLabelId: null,
    newUserPasswordInputErrorLabelId: null,
    number2Id: null,
    signButtonId: null
};

var signPanelType = 'REMOTE';
var remoteLoginStatus = 'NOT_LOGGED';

function setSignOP(errorMessageId, userInputId, newUserPasswordInputId, loginPasswordInputId,
        otpInputId, otpErrorId, pinInputId, pinErrorId, loginPasswordInputErrorLabelId,
        userInputErrorLabelId, newUserPasswordInputErrorLabelId, number2Id, signButtonId) {
    signOP.errorMessageId = errorMessageId;
    signOP.userInputId = userInputId;
    signOP.newUserPasswordInputId = newUserPasswordInputId;
    signOP.loginPasswordInputId = loginPasswordInputId;
    signOP.otpInputId = otpInputId;
    signOP.otpErrorId = otpErrorId;
    signOP.pinInputId = pinInputId;
    signOP.pinErrorId = pinErrorId;
    signOP.loginPasswordInputErrorLabelId = loginPasswordInputErrorLabelId;
    signOP.userInputErrorLabelId = userInputErrorLabelId;
    signOP.newUserPasswordInputErrorLabelId = newUserPasswordInputErrorLabelId;
    signOP.number2Id = number2Id;
    signOP.signButtonId = signButtonId;
}

function setSignPanelType(panelType) {
    signPanelType = panelType;
}

function setRemoteLoginStatus(remoteStatus) {
    remoteLoginStatus = remoteStatus;
}

function loginPasswordInputKeyUp(evt) {
    try {
        removeClass(signOP.loginPasswordInputId, "cg-textInput-Error");
        document.getElementById(signOP.loginPasswordInputErrorLabelId).style.display = 'none';
        if (evt.keyCode == 13) {
            if (document.getElementById(signOP.loginPasswordInputId).value == null || document.getElementById(signOP.loginPasswordInputId).value == "") {
                addClass(signOP.loginPasswordInputId, "cg-textInput-Error");
                document.getElementById(signOP.loginPasswordInputErrorLabelId).style.display = '';
            } else {
                $controller$.remoteSignatureLoginJS();
            }
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function newUserInputKeyUp(evt) {
    try {
        removeClass(signOP.userInputId, "cg-textInput-Error");
        document.getElementById(signOP.userInputErrorLabelId).style.display = 'none';
        if (evt.keyCode == 13) {
            if (checkNewUserCredentials()) {
                $controller$.newUserremoteSignatureLoginJS();
            }
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function newUserPasswordInputKeyUp(evt) {
    try {
        removeClass(signOP.newUserPasswordInputId, "cg-textInput-Error");
        document.getElementById(signOP.newUserPasswordInputErrorLabelId).style.display = 'none';
        if (evt.keyCode == 13) {
            if (checkNewUserCredentials()) {
                $controller$.newUserremoteSignatureLoginJS();
            }
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function checkNewUserCredentials() {
    var ret = true;
    if (document.getElementById(signOP.userInputId).value == null || document.getElementById(signOP.userInputId).value == "") {
        addClass(signOP.userInputId, "cg-textInput-Error");
        document.getElementById(signOP.userInputErrorLabelId).style.display = '';
        ret = false;
    }
    if (document.getElementById(signOP.newUserPasswordInputId).value == null || document.getElementById(signOP.newUserPasswordInputId).value == "") {
        addClass(signOP.newUserPasswordInputId, "cg-textInput-Error");
        document.getElementById(signOP.newUserPasswordInputErrorLabelId).style.display = '';
        ret = false;
    }
    return ret;
}

function otpInputKeyUp(evt) {
    try {
        codeKeyUp(evt, signOP.otpInputId, signOP.otpErrorId);
    } catch (exception) {
        error(exception.stack);
    }
}

function pinInputKeyUp(evt) {
    try {
        codeKeyUp(evt, signOP.pinInputId, signOP.pinErrorId);
    } catch (exception) {
        error(exception.stack);
    }
}

function signPinInputKeyUp(evt) {
    try {
        removeClass('sign_SignatureOperationPanel_signingPinArea_pinInput', "cg-textInput-Error");
        document.getElementById('sign_SignatureOperationPanel_signingPinArea_pinError').style.display = 'none';
        if (document.getElementById('sign_SignatureOperationPanel_signingPinArea_pinInput').value == null
                || document.getElementById('sign_SignatureOperationPanel_signingPinArea_pinInput').value == "") {
            document.getElementById('sign_SignatureOperationPanel_signingPinArea_signButton').setAttribute('disabled', 'disabled');
            addClass('sign_SignatureOperationPanel_signingPinArea_signButton', 'disabled');
        } else {
            document.getElementById('sign_SignatureOperationPanel_signingPinArea_signButton').removeAttribute('disabled');
            removeClass('sign_SignatureOperationPanel_signingPinArea_signButton', 'disabled');
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function codeKeyUp(evt, codeInputId, errorId) {
    removeClass(codeInputId, "cg-textInput-Error");
    document.getElementById(errorId).style.display = 'none';
    var canSign = updateSignButton();
    if (evt.keyCode == 13 && canSign === true) {
        $controller$.signJS();
        return;
    }
    if (document.getElementById(codeInputId).value == null || document.getElementById(codeInputId).value == "") {
        addClass(signOP.number2Id, "sign_SignatureOperationPanel_signTypeArea_numberContainer_inactive");
        removeClass(signOP.number2Id, "sign_SignatureOperationPanel_signTypeArea_numberContainer_active");
    } else {
        addClass(signOP.number2Id, "sign_SignatureOperationPanel_signTypeArea_numberContainer_active");
        removeClass(signOP.number2Id, "sign_SignatureOperationPanel_signTypeArea_numberContainer_inactive");
    }
}

function updateSignButton() {
    if (signPanelType == 'REMOTE') {
        if (remoteLoginStatus == 'LOGGED') {
            if (document.getElementById(signOP.otpInputId).value != null && document.getElementById(signOP.otpInputId).value != "") {
                document.getElementById(signOP.signButtonId).removeAttribute('disabled');
                removeClass(signOP.signButtonId, 'disabled');
                return true;
            }
        }
    } else {
        if (document.getElementById(signOP.pinInputId).value != null && document.getElementById(signOP.pinInputId).value != "") {
            document.getElementById(signOP.signButtonId).removeAttribute('disabled');
            removeClass(signOP.signButtonId, 'disabled');
            return true;
        }
    }
    document.getElementById(signOP.signButtonId).setAttribute('disabled', 'disabled');
    addClass(signOP.signButtonId, 'disabled');
    return false;
}

/**
 * 
 * ------------------------------ END SignatureOperationPanel ------------------------------
 * 
 */

/**
 * 
 * ------------------------------ START SignaturePasswordExpired ------------------------------
 * 
 */

function passwordExpiredInputKeyUp(newPasswordId, newPasswordConfirmId, insertOtpId, modifyPasswordId) {
    var newPasswordEl = document.getElementById(newPasswordId);
    var newPasswordConfirmEl = document.getElementById(newPasswordConfirmId);
    var insertOtpEl = document.getElementById(insertOtpId);
    if (newPasswordEl.value == null || newPasswordEl.value == ""
            || newPasswordConfirmEl.value == null || newPasswordConfirmEl.value == ""
            || insertOtpEl.value == null || insertOtpEl.value == "") {
        document.getElementById(modifyPasswordId).setAttribute('disabled', 'disabled');
        addClass(modifyPasswordId, 'disabled');
    } else {
        document.getElementById(modifyPasswordId).removeAttribute('disabled');
        removeClass(modifyPasswordId, 'disabled');
    }
}

/**
 * 
 * ------------------------------ END SignaturePasswordExpired ------------------------------
 * 
 */