/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.List;
import java.util.Map;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;

    WindowsComputerSystem() {
        this.init();
    }

    private void init() {
        List<String> models;
        Map<String, List<String>> win32ComputerSystem = WmiUtil.selectStringsFrom(null, "Win32_ComputerSystem", "Manufacturer,Model", null);
        List<String> manufacturers = win32ComputerSystem.get("Manufacturer");
        if (manufacturers != null && !manufacturers.isEmpty()) {
            this.setManufacturer(manufacturers.get(0));
        }
        if ((models = win32ComputerSystem.get("Model")) != null && !models.isEmpty()) {
            this.setModel(models.get(0));
        }
        this.setSerialNumber(this.getSystemSerialNumber());
        this.setFirmware(new WindowsFirmware());
        this.setBaseboard(new WindowsBaseboard());
    }

    private String getSystemSerialNumber() {
        String serialNumber = WmiUtil.selectStringFrom(null, "Win32_BIOS", "SerialNumber", "where PrimaryBIOS=true");
        if ("".equals(serialNumber)) {
            serialNumber = WmiUtil.selectStringFrom(null, "Win32_Csproduct", "IdentifyingNumber", null);
        }
        if ("".equals(serialNumber)) {
            serialNumber = "unknown";
        }
        return serialNumber;
    }
}

