/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.parser.SignerInfoDataParser;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignatureTransform;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import esecurity.validator.xades.bean.XadesSigningCertificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XadesSignerInfoDataParser
extends SignerInfoDataParser {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static DocumentBuilderFactory b = DocumentBuilderFactory.newInstance();

    @Override
    public SignerInfoData parse(byte[] object) {
        XadesSignerInfoData xadesSignerInfoData;
        try {
            Object object2;
            Element element;
            Object object3;
            Object object4;
            xadesSignerInfoData = new XadesSignerInfoData();
            object = b.newDocumentBuilder().parse(new ByteArrayInputStream((byte[])object));
            Object object5 = XPathFactory.newInstance();
            object5 = ((XPathFactory)object5).newXPath();
            Object object6 = (Element)object5.evaluate("/Signature/SignedInfo/CanonicalizationMethod", object.getDocumentElement(), XPathConstants.NODE);
            if (object6 != null) {
                object6 = object6.getAttribute("Algorithm");
                xadesSignerInfoData.setCanonicalizationMethod((String)object6);
            }
            if ((object6 = (Element)object5.evaluate("/Signature/SignedInfo/SignatureMethod", object.getDocumentElement(), XPathConstants.NODE)) != null) {
                object6 = object6.getAttribute("Algorithm");
                xadesSignerInfoData.setSignatureMethod((String)object6);
            }
            object6 = (NodeList)object5.evaluate("/Signature/SignedInfo/Reference", object.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < object6.getLength(); ++i) {
                Object object7;
                object4 = new XadesSignatureReference();
                object3 = (Element)object6.item(i);
                if (object3.hasAttribute("URI")) {
                    ((XadesSignatureReference)object4).setURI(object3.getAttribute("URI"));
                }
                if (object3.hasAttribute("Type")) {
                    ((XadesSignatureReference)object4).setType(object3.getAttribute("Type"));
                }
                if ((object7 = (Element)object5.evaluate("./DigestMethod", object3, XPathConstants.NODE)) != null) {
                    object7 = object7.getAttribute("Algorithm");
                    ((XadesSignatureReference)object4).setDigestMethodAlgorithm((String)object7);
                }
                if ((object7 = (Element)object5.evaluate("./DigestValue", object3, XPathConstants.NODE)) != null) {
                    object7 = object7.getTextContent();
                    ((XadesSignatureReference)object4).setDigestValue(Base64.decode((String)object7));
                }
                if ((object7 = (Element)object5.evaluate("./Transforms", object3, XPathConstants.NODE)) != null) {
                    object3 = (NodeList)object5.evaluate("./Transform", object7, XPathConstants.NODESET);
                    for (int j = 0; j < object3.getLength(); ++j) {
                        element = (Element)object3.item(j);
                        object2 = new XadesSignatureTransform();
                        if (element.hasAttribute("Algorithm")) {
                            ((XadesSignatureTransform)object2).setAlgorithm(element.getAttribute("Algorithm"));
                        }
                        ((XadesSignatureReference)object4).getTransforms().add((XadesSignatureTransform)object2);
                    }
                }
                xadesSignerInfoData.getReferences().add((XadesSignatureReference)object4);
            }
            Object object8 = (Element)object5.evaluate("/Signature/SignatureValue", object.getDocumentElement(), XPathConstants.NODE);
            xadesSignerInfoData.setSignatureValue(object8.getTextContent().replace("\r", "").replace("\n", "").trim());
            object4 = (Element)object5.evaluate("/Signature/Object/QualifyingPropertiesReference", object.getDocumentElement(), XPathConstants.NODE);
            object3 = (Element)object5.evaluate("/Signature/Object/QualifyingProperties/SignedProperties", object.getDocumentElement(), XPathConstants.NODE);
            if (object3 != null) {
                xadesSignerInfoData.setHasSignedProperties(true);
                xadesSignerInfoData.setSignedPropsId(object3.getAttribute("Id"));
                Object object9 = (Element)object5.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties", object.getDocumentElement(), XPathConstants.NODE);
                if (object9 != null) {
                    Element element2;
                    object9 = (Element)object5.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SigningTime", object.getDocumentElement(), XPathConstants.NODE);
                    if (object9 != null) {
                        object9 = object9.getFirstChild().getNodeValue();
                        try {
                            DatatypeFactory.newInstance().newXMLGregorianCalendar((String)object9).toGregorianCalendar();
                            xadesSignerInfoData.setHasSigningTime(true);
                        }
                        catch (Exception exception) {}
                    }
                    if ((object9 = (Element)object5.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SigningCertificate", object.getDocumentElement(), XPathConstants.NODE)) != null) {
                        object3 = (NodeList)object5.evaluate("./Cert", object9, XPathConstants.NODESET);
                        for (int i = 0; i < object3.getLength(); ++i) {
                            element = (Element)object3.item(i);
                            if (element == null) continue;
                            try {
                                object2 = new XadesSigningCertificate();
                                object6 = (Element)object5.evaluate("./CertDigest/DigestMethod", element, XPathConstants.NODE);
                                object8 = (Element)object5.evaluate("./CertDigest/DigestValue", element, XPathConstants.NODE);
                                object4 = (Element)object5.evaluate("./IssuerSerial/X509IssuerName", element, XPathConstants.NODE);
                                element2 = (Element)object5.evaluate("./IssuerSerial/X509SerialNumber", element, XPathConstants.NODE);
                                if (object6.hasAttribute("Algorithm")) {
                                    ((XadesSigningCertificate)object2).setDigestMethod(object6.getAttribute("Algorithm"));
                                }
                                if ((object8 = object8.getTextContent()) != null) {
                                    object8 = ((String)object8).trim();
                                }
                                ((XadesSigningCertificate)object2).setDigestValue((String)object8);
                                ((XadesSigningCertificate)object2).setIssuerName(object4.getTextContent());
                                ((XadesSigningCertificate)object2).setSerialNumber(new BigInteger(element2.getTextContent()));
                                ((XadesSigningCertificate)object2).setVersion(1);
                                xadesSignerInfoData.getSigningCertificates().add((XadesSigningCertificate)object2);
                                continue;
                            }
                            catch (Exception exception) {
                                a.error(exception.getMessage(), (Throwable)exception);
                            }
                        }
                    }
                    if ((object3 = (Element)object5.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SigningCertificateV2", object.getDocumentElement(), XPathConstants.NODE)) != null) {
                        NodeList nodeList = (NodeList)object5.evaluate("./Cert", object3, XPathConstants.NODESET);
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            object2 = (Element)nodeList.item(i);
                            if (object2 == null) continue;
                            try {
                                object6 = new XadesSigningCertificate();
                                object8 = (Element)object5.evaluate("./CertDigest/DigestMethod", object2, XPathConstants.NODE);
                                object4 = (Element)object5.evaluate("./CertDigest/DigestValue", object2, XPathConstants.NODE);
                                element2 = (Element)object5.evaluate("./IssuerSerialV2", object2, XPathConstants.NODE);
                                if (object8.hasAttribute("Algorithm")) {
                                    ((XadesSigningCertificate)object6).setDigestMethod(object8.getAttribute("Algorithm"));
                                }
                                if ((object8 = object4.getTextContent()) != null) {
                                    object8 = ((String)object8).trim();
                                }
                                ((XadesSigningCertificate)object6).setDigestValue((String)object8);
                                if (element2 != null) {
                                    ((XadesSigningCertificate)object6).setIssuerName(element2.getTextContent());
                                }
                                ((XadesSigningCertificate)object6).setVersion(2);
                                xadesSignerInfoData.getSigningCertificates().add((XadesSigningCertificate)object6);
                                continue;
                            }
                            catch (Exception exception) {
                                a.error(exception.getMessage(), (Throwable)exception);
                            }
                        }
                    }
                    if ((object9 = (Element)object5.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SignaturePolicyIdentifier", object.getDocumentElement(), XPathConstants.NODE)) != null) {
                        xadesSignerInfoData.setHasSignaturePolicyIdentifier(true);
                    }
                }
            } else if (object4 != null) {
                xadesSignerInfoData.setHasSignedProperties(true);
            }
            Element element3 = (Element)object5.evaluate("/Signature/KeyInfo", object.getDocumentElement(), XPathConstants.NODE);
            if (element3 != null) {
                xadesSignerInfoData.setKeyInfoId(element3.getAttribute("Id"));
                element3 = (Element)object5.evaluate("/Signature/KeyInfo//X509Certificate", element3, XPathConstants.NODE);
                if (element3 != null) {
                    xadesSignerInfoData.setHasKeyInfo(true);
                }
            }
            if ((element3 = (Element)object5.evaluate("/Signature/Object/QualifyingProperties/UnsignedProperties", object.getDocumentElement(), XPathConstants.NODE)) != null) {
                object5.evaluate("./CertificateValues", element3, XPathConstants.NODE);
            }
        }
        catch (Exception exception) {
            xadesSignerInfoData = null;
            a.error(exception.getMessage(), (Throwable)exception);
        }
        return xadesSignerInfoData;
    }
}

