/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureAlgorithm;
import java.security.PrivateKey;
import java.security.SignatureException;

public class SignUtils {
    public static SignatureAlgorithm algoByKeyAndDigest(PrivateKey privateKey, DigestAlgorithm digestAlgorithm) throws SignatureException {
        SignatureAlgorithm signatureAlgorithm = null;
        for (SignatureAlgorithm signatureAlgorithm2 : SignatureAlgorithm.values()) {
            if (!signatureAlgorithm2.getSignatureAlgo().equalsIgnoreCase(privateKey.getAlgorithm()) || signatureAlgorithm2.getDigestAlgo() != digestAlgorithm) continue;
            signatureAlgorithm = signatureAlgorithm2;
            break;
        }
        if (signatureAlgorithm == null) {
            new SignatureException("Invalid Digest Algorithm");
        }
        return signatureAlgorithm;
    }
}

