/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DLSequence;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class ECUtils {
    public static PublicKey rebuildPublicKeyFromRawCard(byte[] object, byte[] object2) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)ASN1ObjectIdentifier.fromByteArray((byte[])object);
        object = aSN1ObjectIdentifier;
        if (!(aSN1ObjectIdentifier.getId().equals("1.2.840.10045.3.1.7") || object.getId().equals("1.3.132.0.34") || object.getId().equals("1.3.132.0.35"))) {
            throw new IOException("Invalid Curve Params");
        }
        object2 = (DEROctetString)DEROctetString.fromByteArray((byte[])object2);
        object2 = new DERBitString(object2.getOctets());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator((OutputStream)byteArrayOutputStream);
        dERSequenceGenerator.addObject((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.10045.2.1"));
        dERSequenceGenerator.addObject((ASN1Encodable)object);
        dERSequenceGenerator.close();
        object = (DLSequence)DERSequence.fromByteArray((byte[])byteArrayOutputStream.toByteArray());
        byteArrayOutputStream = new ByteArrayOutputStream();
        dERSequenceGenerator = new DERSequenceGenerator((OutputStream)byteArrayOutputStream);
        dERSequenceGenerator.addObject((ASN1Encodable)object);
        dERSequenceGenerator.addObject((ASN1Encodable)object2);
        dERSequenceGenerator.close();
        object = AlgorithmId.parse(new DerValue(object.getEncoded()));
        object2 = new X509EncodedKeySpec(byteArrayOutputStream.toByteArray());
        object = KeyFactory.getInstance(((AlgorithmId)object).getName());
        object = ((KeyFactory)object).generatePublic((KeySpec)object2);
        return object;
    }
}

