/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.Validator;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.LoggerConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.actalis.ellips.capi.tsl.ParsingResults;
import it.actalis.ellips.capi.tsl.TSL;
import it.actalis.ellips.capi.tsl.TSLParserFactory;
import it.actalis.ellips.capi.tsl.TSLPointer;
import it.actalis.ellips.capi.tsl.TSLServiceType;
import it.actalis.ellips.capi.tsl.TSLStatus;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdaterGUI;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdaterReport;
import it.actalis.ellips.capi.tsl.rootupdater.TSLInfo;
import it.actalis.ellips.capi.tsl.rootupdater.TSLUtils;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateMode;
import it.actalis.ellips.capi.tsl.rootupdater.a;
import it.actalis.ellips.capi.tsl.rootupdater.c;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import it.arubapec.ca.utils.ConfigParameter;
import it.arubapec.ca.utils.FileUtils;
import it.arubapec.ca.utils.LockApplication;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.slf4j.Logger;
import secretstoreutils.SecretStore;

public class RootUpdater {
    protected String homeFolder = null;
    protected static Logger logger = null;
    protected CertDB cdb = null;
    protected String cdbName = null;
    protected File cdbFile = null;
    protected String cdbPassword = null;
    protected String customTSLItaUrl = null;
    protected String customTSLItaCert = null;
    protected String reportFileName = "";
    protected String mergeFileName = "";
    protected File indexLastUpdFile = null;
    protected File lastUpdFile = null;
    protected File progressFile = null;
    protected File reportFile = null;
    protected File mergeFile = null;
    protected File tslEndPointFile = null;
    protected final String DEBUG_CDB_NAME = "cert_debug.cdb";
    protected TSLParserFactory parserFactory = null;
    protected boolean forcedUpdate = false;
    protected boolean fileProgressEnabled = false;
    protected boolean printTSLEndpoints = false;
    protected boolean checkAdditionalSrvInfo = false;
    protected String TSLHistoryFolder = null;
    protected int iProgressStep;
    protected int totProgressSteps;
    protected RootUpdaterReport report = null;
    protected RootUpdaterGUI updaterGUI = null;
    protected UpdateMode updateMode = UpdateMode.ATSL_SIGNED;
    protected final int UPD_DONE = 0;
    protected final int UPD_ERROR = 1;
    protected final int UPD_SKIP = 2;
    protected final int UPD_UNKNOWN = 3;
    protected final int UPD_IGNORED = 4;
    protected final int UPD_ARCHIVED = 5;
    protected final String arubaCDBServerUrl = "https://updatesfirma.aruba.it/cdb/cert.cdb";
    protected final String arubaCDBSignedServerUrl = "https://updatesfirma.aruba.it/cdb/cert.cdb.p7m";
    protected final String arubaCDBChecksumServerUrl = "https://updatesfirma.aruba.it/cdb/checksum.txt";
    protected List<String> ignoreTSL = new LinkedList<String>();
    protected List<String> ignoreVerificationTSL = new LinkedList<String>();
    protected String debugTSL = "";

    public RootUpdater(String string, String string2) throws CapiException {
        this(string, string2, "1234567890AAbbCCdd", null);
    }

    public RootUpdater(String string, String string2, String string3) throws CapiException {
        this(string, string2, string3, null);
    }

    public RootUpdater(String string, String string2, String string3, NetworkConfig networkConfig) throws CapiException {
        this(string, string2, string3, networkConfig, null);
    }

    public RootUpdater(String string, String string2, String string3, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this(string, "TSL", string2, string3, networkConfig, logger);
    }

    public RootUpdater(String string, String string2, String string3, String string4, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this(string, string2, string3, string4, null, networkConfig, logger);
    }

    public RootUpdater(String string, String string2, File file, String string3, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this(string, "TSL", string2, string3, file, networkConfig, logger);
    }

    public RootUpdater(String string, String string2, String string3, String string4, File file, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this.a(string, string2, string3, string4, networkConfig, logger, file);
    }

    public RootUpdater(String string, ValidatorConfig validatorConfig) throws CapiException {
        this(string, validatorConfig, null);
    }

    public RootUpdater(String string, ValidatorConfig validatorConfig, Logger logger) throws CapiException {
        if (validatorConfig == null) {
            throw new CapiException("No config specified", 1003);
        }
        NetworkConfig networkConfig = validatorConfig.getNetConfiguration();
        if (networkConfig == null) {
            String string2;
            String string3;
            String string4;
            String string5;
            networkConfig = new NetworkConfig(logger, false);
            int n = 0;
            if (validatorConfig.getElement("http.proxy", null) != null && (string5 = validatorConfig.getElement("http.proxy", null)).equalsIgnoreCase("true")) {
                n = 1;
            }
            if (n != 0) {
                string5 = "";
                if (validatorConfig.getElement("http.proxy.host", null) != null) {
                    string5 = validatorConfig.getElement("http.proxy.host", null);
                }
                n = validatorConfig.getIntElement("http.proxy.port", 8080);
                String string6 = "";
                if (validatorConfig.getElement("http.proxy.user", null) != null) {
                    string6 = validatorConfig.getElement("http.proxy.user", null);
                }
                string4 = "";
                if (validatorConfig.getElement("http.proxy.pass", null) != null) {
                    string4 = validatorConfig.getElement("http.proxy.pass", null);
                }
                string3 = "";
                if (validatorConfig.getElement("http.proxy.noProxyHosts", null) != null) {
                    string3 = validatorConfig.getElement("http.proxy.noProxyHosts", null);
                }
                networkConfig.setProxy(string5);
                networkConfig.setProxyPort("" + n);
                networkConfig.setUserProxy(string6);
                networkConfig.setPasswordProxy(string4);
                networkConfig.setProxynohosts(string3.split(","));
            }
            boolean bl = false;
            if (validatorConfig.getElement("ldap.proxy", null) != null && (string2 = validatorConfig.getElement("ldap.proxy", null)).equalsIgnoreCase("true")) {
                bl = true;
            }
            if (bl) {
                String string7 = "";
                if (validatorConfig.getElement("ldap.proxy.host", null) != null) {
                    string7 = validatorConfig.getElement("ldap.proxy.host", null);
                }
                int n2 = validatorConfig.getIntElement("ldap.proxy.port", 8080);
                string4 = "";
                if (validatorConfig.getElement("ldap.proxy.user", null) != null) {
                    string4 = validatorConfig.getElement("http.proxy.user", null);
                }
                string3 = "";
                if (validatorConfig.getElement("ldap.proxy.pass", null) != null) {
                    string3 = validatorConfig.getElement("ldap.proxy.pass", null);
                }
                networkConfig.setLdapProxy(string7);
                networkConfig.setLdapProxyPort("" + n2);
                networkConfig.setLdapUserProxy(string4);
                networkConfig.setLdapPasswordProxy(string3);
            }
        }
        String string8 = validatorConfig.getElement("certdb.file");
        File file = new File(string8);
        string8 = validatorConfig.getElement("certdb.pwd");
        this.a(string, "", file.getName(), string8, networkConfig, logger, null);
    }

    private void a(String object, String string, String string2, String string3, NetworkConfig networkConfig, Logger logger, File file) throws CapiException {
        if (Util.isNullOrEmpty((String)object)) {
            throw new CapiException("TSL home folder wrong or not specified", 1003);
        }
        if (Util.isNullOrEmpty(string2)) {
            throw new CapiException("cdb name wrong or not specified", 1003);
        }
        if (Util.isNullOrEmpty(string3)) {
            throw new CapiException("cdb password wrong or not specified", 1003);
        }
        RootUpdater.logger = logger == null ? EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME) : logger;
        this.customTSLItaUrl = "";
        this.customTSLItaCert = "";
        this.parserFactory = new TSLParserFactory();
        if (networkConfig == null) {
            networkConfig = new NetworkConfig(RootUpdater.logger, false);
        }
        this.parserFactory.setNetworkConfig(networkConfig);
        this.fileProgressEnabled = false;
        this.reportFileName = "";
        this.mergeFileName = "";
        this.report = new RootUpdaterReport();
        this.iProgressStep = 0;
        this.totProgressSteps = 1;
        this.cdbName = string2;
        this.homeFolder = object;
        if (!Util.isNullOrEmpty(string)) {
            this.homeFolder = (String)object + File.separator + string;
        }
        object = new File(this.homeFolder);
        try {
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
                RootUpdater.logger.info("TSL folder created");
            }
        }
        catch (SecurityException securityException) {
            RootUpdater.logger.error("Unable to create TSL folder: " + securityException.getMessage());
            throw new CapiException("Unable to create TSL folder", 1003, securityException);
        }
        this.cdbFile = new File(object + File.separator + this.cdbName);
        this.indexLastUpdFile = new File(object + File.separator + "lastUpdIndex.ini");
        this.lastUpdFile = new File(object + File.separator + "atslLastUpd.txt");
        this.progressFile = new File(object + File.separator + "progress.txt");
        this.tslEndPointFile = new File(object + File.separator + "tslEndPoints.txt");
        this.forcedUpdate = false;
        this.cdbPassword = string3;
        try {
            if (this.cdbFile.exists() || file == null || !file.exists()) {
                RootUpdater.logger.info("create cdb " + !this.cdbFile.exists());
                this.cdb = CertDB.getInstance(this.cdbFile.getAbsolutePath(), this.cdbPassword, !this.cdbFile.exists(), true);
                return;
            }
            RootUpdater.logger.info(String.format("Using the cdb %s. Its size is %d KB", file.getAbsolutePath(), file.length() / 1024L));
            Utils.copyFile(file, this.cdbFile);
            this.cdb = CertDB.getInstance(this.cdbFile.getAbsolutePath(), this.cdbPassword, false, true);
            RootUpdater.logger.info("The installer's cdb was copied to default cdb folder");
        }
        catch (CertDBException certDBException) {
            throw new CapiException("Error opening or loading cdb file", 1003, certDBException);
        }
        catch (IOException iOException) {
            throw new CapiException("Error copying cdb file", 1003, iOException);
        }
        catch (Exception exception) {
            throw new CapiException("General cdb file error", 1003, exception);
        }
    }

    public void setReportFileName(String string) {
        this.reportFileName = string;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setMergeDiffFileName(String string) {
        this.mergeFileName = string;
    }

    public String getMergeDiffFileName() {
        return this.mergeFileName;
    }

    public String getTSLHistoryFolder() {
        return this.TSLHistoryFolder;
    }

    public void setTSLHistoryFolder(String string) {
        this.TSLHistoryFolder = string;
    }

    public void setForcedUpdate(boolean bl) {
        this.forcedUpdate = bl;
    }

    public boolean isForcedUpdate() {
        return this.forcedUpdate;
    }

    public void setForceHTTPSConnections(boolean bl) {
        if (this.parserFactory != null) {
            this.parserFactory.setForceHTTPSConnections(bl);
        }
    }

    public boolean isCheckAdditionalSrvInfo() {
        return this.checkAdditionalSrvInfo;
    }

    public void setCheckAdditionalSrvInfo(boolean bl) {
        this.checkAdditionalSrvInfo = bl;
    }

    public boolean isForcedToHTTPSConnections() {
        if (this.parserFactory != null) {
            return this.parserFactory.isForcedToHTTPSConnections();
        }
        return false;
    }

    public void setUntrustedStates(String[] stringArray) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setUntrustedStates(stringArray);
    }

    public void setTrustedStates(String[] stringArray) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setTrustedStates(stringArray);
    }

    public void setWarningStates(String[] stringArray) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setWarningStates(stringArray);
    }

    public void setRemoveStates(String[] stringArray) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setRemoveStates(stringArray);
    }

    public String getTSLUrlDSIta() {
        return TSL.URL_DSList.getUrl();
    }

    public void setTSLUrlDSIta(String string) {
        TSL.URL_DSList.setUrl(string);
    }

    public String getTSLUrlEU() {
        return TSL.URL_ListOfList.getUrl();
    }

    public void setTSLUrlEU(String string) {
        TSL.URL_ListOfList.setUrl(string);
    }

    public void setConnectionTimeout(int n) {
        this.parserFactory.setReadTimeout(n);
        this.parserFactory.setConnectionTimeout(n);
    }

    public void enableFileProgress() {
        this.fileProgressEnabled = true;
    }

    public void disableFileProgress() {
        this.fileProgressEnabled = false;
    }

    public boolean isProgressEnabled() {
        return this.fileProgressEnabled;
    }

    public File getProgressFile() {
        return this.progressFile;
    }

    public boolean isUpdateNeeded() {
        if (this.isRebuildFromScratchNeeded()) {
            return true;
        }
        switch (this.updateMode) {
            case TSL: {
                return this.isTSLUpdated(TSL.URL_DSList.getUrl()) || this.isTSLUpdated(TSL.URL_ListOfList.getUrl());
            }
            case ATSL: {
                return this.isTSLUpdated("https://updatesfirma.aruba.it/cdb/cert.cdb");
            }
            case ATSL_SIGNED: {
                return this.isTSLUpdated("https://updatesfirma.aruba.it/cdb/cert.cdb.p7m");
            }
            case DEBUG: {
                return true;
            }
        }
        return false;
    }

    protected boolean isRebuildFromScratchNeeded() {
        if (!this.cdbFile.exists()) {
            logger.info("no cdb file found in " + this.cdbFile.getAbsolutePath() + ". It will be rebuilt from scratch");
            return true;
        }
        if (this.cdb.getSize() == 0) {
            logger.info("cdb is empty. It will be rebuilt from scratch");
            return true;
        }
        if (this.updateMode.equals((Object)UpdateMode.TSL)) {
            if (!this.indexLastUpdFile.exists()) {
                logger.info("no index file found. Cdb will be rebuilt from scratch");
                return true;
            }
        } else if ((this.updateMode.equals((Object)UpdateMode.ATSL) || this.updateMode.equals((Object)UpdateMode.ATSL_SIGNED)) && !this.lastUpdFile.exists()) {
            logger.info("no update file found. Cdb will be downloaded");
            return true;
        }
        return false;
    }

    public CertDB getCertificateDB() {
        return this.cdb;
    }

    public void setGUI(RootUpdaterGUI rootUpdaterGUI) {
        this.updaterGUI = rootUpdaterGUI;
    }

    /*
     * Exception decompiling
     */
    public boolean doUpdate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[CATCHBLOCK], 25[CATCHBLOCK], 6[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RootUpdaterReport getReport() {
        return this.report;
    }

    protected File validateCdb(File file) throws CapiException {
        if (this.updateMode != UpdateMode.ATSL_SIGNED) {
            return file;
        }
        ValidatedDocument validatedDocument = null;
        InputStream inputStream = null;
        InputHandler inputHandler = null;
        try {
            Object object = new ValidatorConfig();
            ((ValidatorConfig)object).setElement("certdb.file", this.cdb.getFilePath());
            ((ValidatorConfig)object).setElement("certdb.pwd", "1234567890AAbbCCdd");
            ((ValidatorConfig)object).setNetConfiguration(this.parserFactory.getNetworkConfig());
            object = new Validator((ValidatorConfig)object, (Logger)EllipsLoggerFactory.getLogger((String)"TEST"));
            Object object2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            ((DateFormat)object2).setTimeZone(Constants.DEFAULT_TIMEZONE);
            object2 = new ValidationDate(new Date(), DateSource.SYSTEM);
            inputHandler = DataHandlerBuilder.get().setFile(file).buildInput();
            validatedDocument = ((Validator)object).validate(inputHandler, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, (ValidationDate)object2, null);
            if (!validatedDocument.isOverAllOk() || validatedDocument.getSubResults().isEmpty()) {
                throw new CapiException("Invalid ATSL cdb signature", 1003);
            }
            inputStream = validatedDocument.getSubResults().get(0).getHandler().getInputAsNewStream();
            file = TmpFileUtils.createTempFile("extracted", ".cdb");
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            try {
                throw new CapiException(exception.getMessage(), 1003, exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(inputHandler);
                Util.closeQuietly(inputStream);
                if (validatedDocument != null) {
                    Util.closeQuietly(validatedDocument.getHandler());
                }
                throw throwable;
            }
        }
        Util.closeQuietly(inputHandler);
        Util.closeQuietly(inputStream);
        if (validatedDocument != null) {
            Util.closeQuietly(validatedDocument.getHandler());
        }
        return file;
    }

    public void setIgnoreTSLList(List<String> list) {
        this.ignoreTSL.clear();
        for (int i = 0; i < list.size(); ++i) {
            String string = RootUpdater.a(list.get(i).toLowerCase());
            this.ignoreTSL.add(string);
        }
    }

    public void setIgnoreVerificationTSLList(List<String> list) {
        this.ignoreVerificationTSL.clear();
        for (int i = 0; i < list.size(); ++i) {
            String string = RootUpdater.a(list.get(i).toLowerCase());
            this.ignoreVerificationTSL.add(string);
        }
    }

    public String getCertDBFilePath() {
        return this.cdbFile.getAbsolutePath();
    }

    public void useCustomTSLDSIta(String string, String string2) {
        this.customTSLItaUrl = string;
        this.customTSLItaCert = string2;
    }

    protected void finalize() {
        block6: {
            try {
                if (this.updaterGUI == null) break block6;
                this.updaterGUI.closeGUI();
            }
            catch (Throwable throwable) {
                try {
                    super.finalize();
                }
                catch (Throwable throwable2) {
                    logger.error(throwable2.getMessage());
                }
                throw throwable;
            }
        }
        try {
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage());
            return;
        }
    }

    private static String a(String string) {
        return string.replace("http://", "").replace("https://", "");
    }

    public boolean isPrintTSLEndPoints() {
        return this.printTSLEndpoints;
    }

    public void setPrintTSLEndPoints(boolean bl) {
        this.printTSLEndpoints = bl;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    protected boolean updateProgress(double d2, String string, String string2) {
        if (this.updaterGUI != null) {
            this.updaterGUI.updateProgress(d2);
            this.updaterGUI.updateDetailArea(string2);
            this.updaterGUI.updateStatus(string);
        }
        if (!this.fileProgressEnabled) {
            return false;
        }
        try {
            if (!this.progressFile.exists()) {
                this.progressFile.createNewFile();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.format("%d", this.iProgressStep));
            arrayList.add(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.progressFile), "UTF-8"));
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    bufferedWriter.write((String)arrayList.get(i) + "\n");
                }
            }
            finally {
                Util.closeQuietly(bufferedWriter);
            }
            return true;
        }
        catch (IOException iOException) {
            logger.error("error writing last ita TSL update data");
            return false;
        }
        catch (SecurityException securityException) {
            logger.error("error writing last ita TSL update data");
            return false;
        }
    }

    protected boolean writeToReport(String string) {
        if (this.reportFileName.isEmpty()) {
            return false;
        }
        if (this.reportFile == null) {
            return false;
        }
        if (!this.reportFile.exists()) {
            return false;
        }
        if (!this.reportFile.canWrite()) {
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.reportFile.getAbsoluteFile(), true);
            fileWriter.write(string + '\n');
        }
        catch (IOException iOException) {
            try {
                logger.error("error writing report", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(fileWriter);
                throw throwable;
            }
            Util.closeQuietly(fileWriter);
            return false;
        }
        Util.closeQuietly(fileWriter);
        logger.debug(string);
        return true;
    }

    protected boolean isTSLUpdated(String string) {
        if (this.forcedUpdate) {
            return true;
        }
        Date date = new Date(this.cdbFile.lastModified());
        Date date2 = TSLUtils.getLastTSLModifiedDate(string, this.parserFactory.getNetworkConfig(), logger);
        if (date2 != null && !date2.after(date)) {
            logger.info(string + "  not modified");
            return false;
        }
        return true;
    }

    protected Date getLastTSLUpdateDate(String string) throws ParseException {
        if (!this.indexLastUpdFile.exists() || Util.isNullOrEmpty(string)) {
            return null;
        }
        Object object = RootUpdater.a(string);
        if (((String[])(object = object.split("/"))).length <= 0) {
            return null;
        }
        object = object[0];
        try {
            Object object2 = new IniPreferences(new Ini(this.indexLastUpdFile));
            object = object2.node("TSL").get((String)object, "");
            if (Util.isNullOrEmpty((String)object)) {
                return null;
            }
            object2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            return object2.parse((String)object);
        }
        catch (IOException iOException) {
            logger.warn("local date for " + string + " not found");
        }
        catch (IllegalStateException illegalStateException) {
            logger.warn("local date for " + string + " not found");
        }
        return null;
    }

    protected boolean setLastTSLUpdateDate(String string, Date date) {
        if (Util.isNullOrEmpty(string) || date == null) {
            return false;
        }
        Object object = RootUpdater.a(string);
        if (((String[])(object = object.split("/"))).length <= 0) {
            return false;
        }
        object = object[0];
        try {
            if (!this.indexLastUpdFile.exists()) {
                this.indexLastUpdFile.createNewFile();
            }
            Ini ini = new Ini(this.indexLastUpdFile);
            IniPreferences iniPreferences = new IniPreferences(ini);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            iniPreferences.node("TSL").put((String)object, simpleDateFormat.format(date));
            try {
                iniPreferences.sync();
                ini.store();
            }
            catch (BackingStoreException backingStoreException) {
                logger.error(String.format("unable to update local date file", backingStoreException.getMessage()));
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            logger.error("unable to get local date for " + string + " " + exception.getMessage());
            return false;
        }
    }

    protected int doUpdateNationalTSL(TSLPointer tSLPointer, CertDB certDB) {
        return this.doUpdateNationalTSL(tSLPointer, certDB, null);
    }

    protected int doUpdateNationalTSL(TSLPointer tSLPointer, CertDB certDB, File file) {
        if (tSLPointer == null || tSLPointer.getUrl().isEmpty()) {
            return 1;
        }
        String string = tSLPointer.getUrl();
        if (TSL.URL_ListOfList.getUrl().equals(string)) {
            return 2;
        }
        ParsingResults parsingResults = null;
        TSLInfo tSLInfo = new TSLInfo(string);
        try {
            Object object;
            Object object2 = TSLUtils.getNationalityFromUrl(string);
            tSLInfo.setNationalId(TSLUtils.extendedNationId((String)object2));
            object2 = RootUpdater.a(string.toLowerCase());
            if (this.ignoreVerificationTSL.contains(object2)) {
                tSLPointer.setVerifyXMLSignature(false);
            }
            if (tSLPointer.getArchivedFile() != null) {
                try {
                    parsingResults = this.parserFactory.parseEUStateList(tSLPointer, certDB, file);
                    tSLInfo.setParsingResults(parsingResults);
                }
                catch (Throwable throwable) {
                    this.writeToReport(String.format("archived tsl parsing failed: %s", throwable.getMessage()));
                    tSLInfo.setLastError(throwable.getMessage());
                    if (this.report != null) {
                        this.report.addTSLInfo(tSLInfo);
                    }
                    return 1;
                }
            } else {
                object2 = this.getLastTSLUpdateDate(string);
                object = TSLUtils.getLastTSLModifiedDate(string, this.parserFactory.getNetworkConfig(), logger);
                tSLInfo.setLastModification((Date)object);
                boolean bl = object2 == null || object == null;
                boolean bl2 = true;
                if (object2 != null && object != null) {
                    bl2 = ((Date)object).after((Date)object2);
                }
                if (this.isForcedUpdate() || bl || bl2) {
                    parsingResults = this.parserFactory.parseEUStateList(tSLPointer, certDB, file);
                    tSLInfo.setParsingResults(parsingResults);
                }
                if (!this.setLastTSLUpdateDate(string, new Date())) {
                    this.writeToReport("error updating local index date file!");
                    tSLInfo.setLastError("error updating local index date file!");
                    return 1;
                }
            }
            if (parsingResults == null) {
                this.writeToReport("no parsing results for TSL " + string + ": skip it");
                return 2;
            }
            this.writeToReport(String.format("%d providers found with %d services and %d TSL certificates", parsingResults.nProviders, parsingResults.nServices, parsingResults.nTotalCerts));
            if (parsingResults.nServiceTrusted > 0) {
                this.writeToReport(String.format("  %d services are in <trusted> statuses", parsingResults.nServiceTrusted));
            }
            if (parsingResults.nServiceWarning > 0) {
                this.writeToReport(String.format("  %d services are in <warnings> statuses", parsingResults.nServiceWarning));
            }
            if (parsingResults.nServiceUntrusted > 0) {
                this.writeToReport(String.format("  %d services are in <untrusted> statuses ", parsingResults.nServiceUntrusted));
            }
            if (parsingResults.nServiceRemoved > 0) {
                this.writeToReport(String.format("  %d services are in <removed> statuses", parsingResults.nServiceRemoved));
            }
            object2 = "  ";
            object = String.format((String)object2 + "certificates:  %d imported into db - %d updated - %d removed - %d skipped (import or remove) - %d imported by CAIssuer - %d on error", parsingResults.nCertImported, parsingResults.nCertUpdated, parsingResults.nCertRemoved, parsingResults.nCertImportSkipped + parsingResults.nCertRemoveSkipped + parsingResults.nCertUpdateSkipped, parsingResults.nCertImportedByCAIssuer, parsingResults.nCertErrors);
            this.writeToReport((String)object);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            simpleDateFormat.setTimeZone(Constants.DEFAULT_TIMEZONE);
            if (parsingResults.lastUpdate != null) {
                this.writeToReport(String.format((String)object2 + "TSL last update: %s", simpleDateFormat.format(parsingResults.lastUpdate)));
            }
            if (parsingResults.nextUpdate != null) {
                this.writeToReport(String.format((String)object2 + "TSL next update: %s", simpleDateFormat.format(parsingResults.nextUpdate)));
            }
            if (this.checkAdditionalSrvInfo) {
                if (parsingResults.serviceTypeWithoutAdditionalSrvInfo.contains(TSLServiceType.urlToId("http://uri.etsi.org/TrstSvc/Svctype/CA/QC"))) {
                    this.writeToReport(String.format((String)object2 + "Warning: QC service type without any AdditionalServiceInformation", new Object[0]));
                }
                String string2 = "";
                for (int i = 0; i < parsingResults.serviceTypeWithAdditionalSrvInfo.size(); ++i) {
                    if (parsingResults.serviceTypeWithAdditionalSrvInfo.get(i).equals(TSLServiceType.urlToId("http://uri.etsi.org/TrstSvc/Svctype/CA/QC"))) continue;
                    string2 = string2 + parsingResults.serviceTypeWithAdditionalSrvInfo.get(i) + ";";
                }
                if (!string2.isEmpty()) {
                    this.writeToReport(String.format((String)object2 + "Warning: %s services type with some AdditionalServiceInformation", string2));
                }
            }
        }
        finally {
            if (this.report != null) {
                this.report.addTSLInfo(tSLInfo);
            }
        }
        logger.debug(String.format("TSL update done: %d certificates processed. Local date file updated", 0));
        if (tSLPointer.getArchivedFile() != null) {
            return 5;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean doUpdateEuropeanListOfTSL(CertDB var1_1) throws IOException {
        var2_4 = 0;
        var3_5 = 0;
        var4_6 = 0;
        var5_7 = 0;
        var7_8 = null;
        try {
            var8_9 = this.parserFactory.parseListOfTSL(TSL.URL_ListOfList.getUrl());
            var6_11 = var8_9.size();
            if (var6_11 > 0) {
                this.setLastTSLUpdateDate(TSL.URL_ListOfList.getUrl(), new Date());
            }
            if (this.printTSLEndpoints) {
                try {
                    this.tslEndPointFile.delete();
                    this.tslEndPointFile.createNewFile();
                    var7_8 = new BufferedWriter(new FileWriter(this.tslEndPointFile, true));
                }
                catch (IOException var9_12) {
                    RootUpdater.logger.error("error creating endpoints " + var9_12.getMessage());
                }
            }
            for (var9_13 = 0; var9_13 < var6_11; ++var9_13) {
                block57: {
                    block56: {
                        var10_14 = var8_9.get(var9_13);
                        var11_16 = TSLUtils.getNationalityFromUrl(var10_14.getUrl()).toUpperCase();
                        var12_18 = var10_14.getUrl();
                        if (var11_16.isEmpty()) {
                            var11_16 = "EU";
                            var12_18 = TSL.URL_ListOfList.getUrl();
                        }
                        RootUpdater.logger.info(String.format("===================================================================", new Object[0]));
                        var13_19 = "";
                        if (this.ignoreTSL.contains(RootUpdater.a(var10_14.getUrl().toLowerCase()))) {
                            var13_19 = " (ignored)";
                        }
                        var14_21 = "";
                        if (this.ignoreVerificationTSL.contains(RootUpdater.a(var10_14.getUrl().toLowerCase()))) {
                            var14_21 = " (no signature verification)";
                        }
                        RootUpdater.logger.info(String.format("%d) %s", new Object[]{var9_13 + 1, var12_18}) + (String)var13_19 + (String)var14_21);
                        RootUpdater.logger.info(String.format("===================================================================\n", new Object[0]));
                        if (var7_8 != null) {
                            try {
                                var7_8.write(var12_18 + "\n");
                            }
                            catch (IOException v0) {}
                        }
                        this.writeToReport(String.format("\n%d) %s - %s", new Object[]{var9_13 + 1, TSLUtils.extendedNationId(var11_16), var12_18}));
                        var12_17 = 3;
                        if (!var11_16.equals("IT") && !var11_16.equals("EU")) break block56;
                        v1 = this;
                        v1.updateProgress((double)(++v1.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(var11_16), var9_13 + 1, var6_11}));
                        ++var2_4;
                        this.writeToReport("=== Updated");
                        RootUpdater.logger.info("parsed");
                        continue;
                    }
                    var13_19 = null;
                    if (!this.ignoreTSL.contains(RootUpdater.a(var10_14.getUrl().toLowerCase()))) ** GOTO lbl79
                    var14_21 = this.b(var11_16);
                    if (var14_21 != null) break block57;
                    RootUpdater.logger.info("unable to find a copy of TSL in archive: it is really ignored");
                    var12_17 = 4;
                    v2 = this;
                    v2.updateProgress((double)(++v2.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(var11_16), var9_13 + 1, var6_11}));
                    ++var5_7;
                    this.writeToReport("!!! Ignored");
                    RootUpdater.logger.info("ignored");
                    continue;
                }
                try {
                    block58: {
                        block60: {
                            RootUpdater.logger.info("continue with the archived copy of TSL");
                            var10_14.setArchivedFile((File)var14_21);
                            break block60;
lbl79:
                            // 1 sources

                            var13_19 = TmpFileUtils.createTempFile("tsl_", ".xml");
                        }
                        var12_17 = this.doUpdateNationalTSL((TSLPointer)var10_14, var1_1, (File)var13_19);
                        if (var12_17 == 1 && !this.isForcedToHTTPSConnections() && var10_14.getUrl().startsWith("http://")) {
                            v3 = var10_14;
                            v3.setUrl(v3.getUrl().replace("http://", "https://"));
                            var12_17 = this.doUpdateNationalTSL((TSLPointer)var10_14, var1_1, (File)var13_19);
                        }
                        if (var12_17 == 0 && !var11_16.equals("EU")) {
                            var15_22 = var13_19;
                            var14_21 = var11_16;
                            var10_14 = this;
                            if (var10_14.TSLHistoryFolder != null) {
                                var16_24 = new File(var10_14.TSLHistoryFolder);
                                var16_24.mkdirs();
                                var16_23 = false;
                                var17_25 = super.b((String)var14_21);
                                if (var17_25 == null || var17_25 != null && !FileUtils.areIdenticalFile((File)var15_22, var17_25)) {
                                    var16_23 = true;
                                }
                                if (var16_23) {
                                    var10_14 = super.c((String)var14_21);
                                    Files.copy(var15_22.toPath(), var10_14.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                                    RootUpdater.logger.info("TSL " + (String)var14_21 + " was archived to " + var10_14.getAbsolutePath());
                                }
                            }
                        }
                        break block58;
                        {
                            catch (Throwable var10_15) {
                                throw var10_15;
                            }
                        }
                        finally {
                            if (var13_19 != null) {
                                var13_19.delete();
                            }
                        }
                    }
                    v4 = this;
                }
                catch (Exception var13_20) {
                    try {
                        RootUpdater.logger.error(String.format("error processing TSL %s\n%s", new Object[]{var8_9.get(var9_13), var13_20.getMessage()}));
                        v5 = this;
                        v5.updateProgress((double)(++v5.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" * %s: FAIL update TSL (%d/%d)", new Object[]{TSLUtils.extendedNationId(var11_16), var9_13 + 1, var6_11}));
                        this.writeToReport(">>> GENERIC ERROR (see log) <<<");
                        ++var3_5;
                        v6 = this;
                    }
                    catch (Throwable var1_2) {
                        v7 = this;
                        v7.updateProgress((double)(++v7.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(var11_16), var9_13 + 1, var6_11}));
                        switch (var12_17) {
                            case 0: {
                                this.writeToReport("=== Updated");
                                RootUpdater.logger.info("parsed");
                                break;
                            }
                            case 1: {
                                this.writeToReport(">>> Error");
                                RootUpdater.logger.info("error");
                                break;
                            }
                            case 2: {
                                this.writeToReport("*** Skipped");
                                RootUpdater.logger.info("skipped");
                                break;
                            }
                            case 3: {
                                this.writeToReport("??? Error");
                                RootUpdater.logger.info("unknown error");
                                break;
                            }
                            case 4: {
                                this.writeToReport("!!! Ignored");
                                RootUpdater.logger.info("ignored");
                                break;
                            }
                            case 5: {
                                this.writeToReport("### From archive");
                                RootUpdater.logger.info("from archive");
                            }
                        }
                        throw var1_2;
                    }
                    v6.updateProgress((double)(++v6.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(var11_16), var9_13 + 1, var6_11}));
                    switch (var12_17) {
                        case 0: {
                            ++var2_4;
                            this.writeToReport("=== Updated");
                            RootUpdater.logger.info("parsed");
                            break;
                        }
                        case 1: {
                            ++var3_5;
                            this.writeToReport(">>> Error");
                            RootUpdater.logger.info("error");
                            break;
                        }
                        case 2: {
                            ++var4_6;
                            this.writeToReport("*** Skipped");
                            RootUpdater.logger.info("skipped");
                            break;
                        }
                        case 3: {
                            ++var3_5;
                            this.writeToReport("??? Error");
                            RootUpdater.logger.info("unknown error");
                            break;
                        }
                        case 4: {
                            ++var5_7;
                            this.writeToReport("!!! Ignored");
                            RootUpdater.logger.info("ignored");
                            break;
                        }
                        case 5: {
                            ++var5_7;
                            this.writeToReport("### From archive");
                            RootUpdater.logger.info("from archive");
                            break;
                        }
                    }
                    continue;
                }
                v4.updateProgress((double)(++v4.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(var11_16), var9_13 + 1, var6_11}));
                switch (var12_17) {
                    case 0: {
                        ++var2_4;
                        this.writeToReport("=== Updated");
                        RootUpdater.logger.info("parsed");
                        break;
                    }
                    case 1: {
                        ++var3_5;
                        this.writeToReport(">>> Error");
                        RootUpdater.logger.info("error");
                        break;
                    }
                    case 2: {
                        ++var4_6;
                        this.writeToReport("*** Skipped");
                        RootUpdater.logger.info("skipped");
                        break;
                    }
                    case 3: {
                        ++var3_5;
                        this.writeToReport("??? Error");
                        RootUpdater.logger.info("unknown error");
                        break;
                    }
                    case 4: {
                        ++var5_7;
                        this.writeToReport("!!! Ignored");
                        RootUpdater.logger.info("ignored");
                        break;
                    }
                    case 5: {
                        ++var5_7;
                        this.writeToReport("### From archive");
                        RootUpdater.logger.info("from archive");
                        break;
                    }
                }
                continue;
            }
        }
        catch (CapiException var8_10) {
            RootUpdater.logger.error(String.format("error processing EU TSL %s", new Object[]{var8_10.getMessage()}));
            this.writeToReport("!!! GENERAL ERROR (see log) !!!");
            return false;
        }
        finally {
            Util.closeQuietly(var7_8);
        }
        RootUpdater.logger.debug(String.format("%d/%d TSL processed", new Object[]{var2_4, var6_11}));
        RootUpdater.logger.debug(String.format("%d/%d TSL NOT processed", new Object[]{var3_5, var6_11}));
        RootUpdater.logger.debug(String.format("%d/%d TSL skipped", new Object[]{var4_6, var6_11}));
        this.writeToReport(String.format("\n- - - - -\n>> %d TSL processed\n>> %d TSL NOT processed\n>> %d TSL skipped or ignored", new Object[]{var2_4, var3_5, var4_6 + var5_7}));
        return true;
    }

    private File b(String string) {
        if (this.TSLHistoryFolder == null) {
            return null;
        }
        int n = 1;
        File file = null;
        File file2 = new File(this.TSLHistoryFolder + File.separator + String.format("%s-%05d.xml", string, 1));
        while (file2.exists()) {
            file = file2;
            file2 = new File(this.TSLHistoryFolder + File.separator + String.format("%s-%05d.xml", string, ++n));
        }
        return file;
    }

    private File c(String string) {
        if (this.TSLHistoryFolder == null) {
            return null;
        }
        int n = 1;
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        ++n;
        objectArray[1] = 1;
        File file = new File(this.TSLHistoryFolder + File.separator + String.format("%s-%05d.xml", objectArray));
        while (file.exists()) {
            file = new File(this.TSLHistoryFolder + File.separator + String.format("%s-%05d.xml", string, n++));
        }
        return file;
    }

    public static void main(String[] object) {
        block35: {
            if (((String[])object).length == 0) {
                System.exit(0);
            }
            Constructor<?> constructor = null;
            String string = null;
            String string2 = null;
            Object object2 = null;
            boolean bl = false;
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].startsWith("-guiApp")) {
                    constructor = object[++i];
                    System.out.println("-guiApp " + (String)((Object)constructor));
                    continue;
                }
                if (object[i].startsWith("-updaterModel")) {
                    string = object[++i];
                    System.out.println("-updaterModel " + string);
                    continue;
                }
                if (object[i].startsWith("-cdbConfig")) {
                    string2 = object[++i];
                    System.out.println("-cdbConfig " + string2);
                    continue;
                }
                if (object[i].startsWith("-mode")) {
                    object2 = object[++i];
                    System.out.println("-mode " + (String)object2);
                    continue;
                }
                if (object[i].startsWith("-createFolder")) {
                    bl = true;
                    System.out.println("-createFolder");
                    continue;
                }
                System.out.println("Argument not recognized: " + object[i]);
            }
            String string3 = object2;
            if (!Util.isNullOrEmpty(string2)) {
                Object object32;
                File file = new File(new File(string2).getParent());
                if (object2 != null && object2.equals("AK")) {
                    System.setProperty("user.name", "ArubaKey_user");
                    if (!file.exists() && bl) {
                        try {
                            object2 = new File(file + File.separator + "TSL");
                            Object object4 = new File(file + File.separator + "log");
                            object32 = new File(string2);
                            Files.createDirectory(file.toPath(), new FileAttribute[0]);
                            if (!object2.exists()) {
                                Files.createDirectory(object2.toPath(), new FileAttribute[0]);
                            }
                            if (!((File)object4).exists()) {
                                Files.createDirectory(((File)object4).toPath(), new FileAttribute[0]);
                            }
                            if (!((File)object32).exists()) {
                                object4 = object32;
                                object32 = new ConfigFile(((File)object4).getAbsolutePath());
                                ((ConfigFile)object32).setElement("homeFolder", "TSL");
                                ((ConfigFile)object32).setElement("certdb.file", "TSL" + File.separator + "cert.cdb");
                                ((ConfigFile)object32).setElement("certdb.pwd", SecretStore.CryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)"1234567890AAbbCCdd"));
                                ((ConfigFile)object32).setElement("reportFileName", "LastUpdateReport.txt");
                                ((ConfigFile)object32).setElement("proxyType", "direct");
                                ((ConfigFile)object32).setElement("ldapProxyType", "direct");
                                ((ConfigFile)object32).setElement("connectionTimeOut", "20000");
                                ((ConfigFile)object32).setElement("forceHttpsConnection", "false");
                                ((ConfigFile)object32).setElement("maxDaysFromLastUpdateEU", "30");
                                ((ConfigFile)object32).setElement("forcedUpdate", "false");
                                ((ConfigFile)object32).setElement("fileProgressEnabled", "false");
                                ((ConfigFile)object32).setElement("printTSLEndpoints", "false");
                                ((ConfigFile)object32).setElement("updateMode", "ATSL");
                                ((ConfigFile)object32).setElement("fileAppender", "log" + File.separator + "rootUpdater.log");
                                ((ConfigFile)object32).setElement("level", "INFO");
                                ((ConfigFile)object32).setElement("consoleAppender", "false");
                                ((ConfigFile)object32).saveConfigFile();
                            }
                        }
                        catch (IOException iOException) {
                            object2 = iOException;
                            iOException.printStackTrace();
                        }
                    }
                }
                if (file.exists()) {
                    try {
                        object2 = new ConfigFile(string2);
                        object2.loadConfigFile();
                        LoggerConfig loggerConfig = new LoggerConfig();
                        object32 = object2.getElement("fileAppender", null);
                        loggerConfig.setFileAppender(object32 != null ? file.toPath().resolve(((String)object32).replace("\\", "/")).toFile() : null);
                        System.out.println("logAppender: " + loggerConfig.getFileAppender().getAbsolutePath());
                        loggerConfig.setConsoleAppender(object2.getBinElement("consoleAppender", false));
                        logger = EllipsLoggerFactory.createLogger((String)"RootUpdater", (String)"%d [%t] [%p] %C{1}.%M(%F:%L) - %m%n", (LoggerLevel)LoggerLevel.valueOf((String)object2.getElement("level", "INFO")), (LoggerConfig)loggerConfig);
                        EllipsLoggerFactory.setMasterLogger((String)"RootUpdater");
                        logger.info("\n-------------------------\nRootUpdater - start logger\n-------------------------");
                        for (Object object32 : object) {
                            logger.info((String)object32);
                        }
                        object32 = file;
                        Object object5 = new ValidatorConfig((ConfigFile)object2);
                        if (!((ValidatorConfig)object5).getElement("homeFolder", "").equals("")) {
                            ((ValidatorConfig)object5).setElement("homeFolder", ((File)object32).toPath().resolve(((ValidatorConfig)object5).getElement("homeFolder", "")).toString().replace("\\", "/"));
                        }
                        if (!((ValidatorConfig)object5).getElement("certdb.file", "").equals("")) {
                            ((ValidatorConfig)object5).setElement("certdb.file", ((File)object32).toPath().resolve(((ValidatorConfig)object5).getElement("certdb.file", "")).toString().replace("\\", "/"));
                        }
                        if (!((ValidatorConfig)object5).getElement("certdb.pwd", "").equals("")) {
                            String string4 = SecretStore.DecryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)((ValidatorConfig)object5).getElement("certdb.pwd", ""));
                            if (Util.isNullOrEmpty(string4)) {
                                string4 = SecretStore.DecryptByPassword((String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)ConfigParameter.USER_NAME, (String)((ValidatorConfig)object5).getElement("certdb.pwd", ""));
                            }
                            ((ValidatorConfig)object5).setElement("certdb.pwd", string4);
                        }
                        object = object5;
                        object5 = object2;
                        object32 = new NetworkConfig();
                        object32.setProxyType(((ConfigFile)object5).getElement("proxyType", ""));
                        object32.setProxy(((ConfigFile)object5).getElement("proxyHost", ""));
                        object32.setProxyPort(((ConfigFile)object5).getElement("proxyPort", ""));
                        object32.setUserProxy(((ConfigFile)object5).getElement("proxyUser", ""));
                        Object object6 = ((ConfigFile)object5).getElement("proxyPassword", "");
                        if (object6 != null && !((String)object6).equals("")) {
                            object2 = SecretStore.DecryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)object6);
                            if (Util.isNullOrEmpty((String)object2)) {
                                object2 = SecretStore.DecryptByPassword((String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)ConfigParameter.USER_NAME, (String)object6);
                            }
                            object6 = !Util.isNullOrEmpty((String)object2) ? object2 : "";
                        }
                        object32.setPasswordProxy((String)object6);
                        object32.setLdapProxyType(((ConfigFile)object5).getElement("ldapProxyType", ""));
                        object32.setLdapProxy(((ConfigFile)object5).getElement("ldapProxyHost", ""));
                        object32.setLdapProxyPort(((ConfigFile)object5).getElement("ldapProxyPort", ""));
                        object32.setLdapUserProxy(((ConfigFile)object5).getElement("ldapProxyUser", ""));
                        object6 = ((ConfigFile)object5).getElement("ldapProxyPassword", "");
                        if (object6 != null && !((String)object6).equals("")) {
                            object2 = SecretStore.DecryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)object6);
                            if (Util.isNullOrEmpty((String)object2)) {
                                object2 = SecretStore.DecryptByPassword((String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)ConfigParameter.USER_NAME, (String)object6);
                            }
                            object6 = !Util.isNullOrEmpty((String)object2) ? object2 : "";
                        }
                        object32.setLdapPasswordProxy((String)object6);
                        object32.setConnectionTimeOut(((ConfigFile)object5).getElement("connectionTimeOut", ""));
                        ((ValidatorConfig)object).setNetConfiguration((NetworkConfig)object32);
                        object6 = new File(((ValidatorConfig)object).getElement("homeFolder", "") + File.separator + "rootUpdater.lck");
                        if (!LockApplication.lockInstance(((File)object6).getAbsolutePath())) {
                            logger.info("RootUpdater already opened");
                            break block35;
                        }
                        logger.info("Start RootUpdater");
                        object5 = object;
                        object32 = new RootUpdater(((ValidatorConfig)object5).getElement("homeFolder", ""), (ValidatorConfig)object5, logger);
                        ((RootUpdater)object32).setForcedUpdate(((ValidatorConfig)object5).getBinElement("forceUpdate", false));
                        ((RootUpdater)object32).setPrintTSLEndPoints(((ValidatorConfig)object5).getBinElement("printTSLEndpoints", false));
                        ((RootUpdater)object32).setReportFileName(((ValidatorConfig)object5).getElement("reportFileName", "LastUpdateReport.txt"));
                        ((RootUpdater)object32).setMergeDiffFileName(((ValidatorConfig)object5).getElement("mergeFileName", ""));
                        ((RootUpdater)object32).setUpdateMode(UpdateMode.valueOf(((ValidatorConfig)object5).getElement("updateMode", UpdateMode.ATSL_SIGNED.name())));
                        ((RootUpdater)object32).useCustomTSLDSIta(((ValidatorConfig)object5).getElement("customTSLItaUrl", ""), ((ValidatorConfig)object5).getElement("customTSLItaCert", ""));
                        ((RootUpdater)object32).setForceHTTPSConnections(((ValidatorConfig)object5).getBinElement("forceHttpsConnection", false));
                        if (((ValidatorConfig)object5).getBinElement("fileProgressEnabled", false)) {
                            ((RootUpdater)object32).enableFileProgress();
                        }
                        if (!((String)(object6 = ((ValidatorConfig)object5).getElement("ignorelist", ""))).isEmpty()) {
                            object2 = ((String)object6).split(";");
                            ((RootUpdater)object32).setIgnoreTSLList(new ArrayList<String>(Arrays.asList(object2)));
                        }
                        object5 = object32;
                        if (!Util.isNullOrEmpty((String)((Object)constructor)) && !Util.isNullOrEmpty(string)) {
                            try {
                                logger.info("Found GUI class path, try to instantiate");
                                object32 = RootUpdater.class.getClassLoader();
                                object = ((ClassLoader)object32).loadClass(string);
                                object = ((Class)object).getConstructors()[0];
                                object = (RootUpdaterGUI)((Constructor)object).newInstance(new Object[0]);
                                ((RootUpdater)object5).setGUI((RootUpdaterGUI)object);
                                constructor = ((ClassLoader)object32).loadClass((String)((Object)constructor));
                                constructor = ((Class)((Object)constructor)).getConstructors()[0];
                                constructor.newInstance(object, new a((RootUpdater)object5, string3, (RootUpdaterGUI)object));
                            }
                            catch (Throwable throwable) {
                                logger.error(throwable.getMessage(), throwable);
                            }
                        }
                        if (((RootUpdater)object5).isUpdateNeeded()) {
                            object32 = new Thread(new c((RootUpdater)object5));
                            ((Thread)object32).start();
                            ((Thread)object32).join();
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Exception exception) {
                        if (logger != null) {
                            logger.error(exception.getMessage(), (Throwable)exception);
                        }
                        exception.printStackTrace();
                    }
                }
            }
        }
        System.exit(0);
    }

    public String getDebugTSL() {
        return this.debugTSL;
    }

    public void setDebugTSL(String string) {
        this.debugTSL = string;
    }
}

