/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsl.ParsingResults;
import it.actalis.ellips.capi.tsl.TSL;
import it.actalis.ellips.capi.tsl.TSLPointer;
import it.actalis.ellips.capi.tsl.TSLServiceType;
import it.actalis.ellips.capi.tsl.TSLStatus;
import it.actalis.ellips.capi.tsl.TSPService;
import it.actalis.ellips.capi.tsl.TrustServiceProvider;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class TSLParserFactory {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private LinkedList<String> b = new LinkedList();
    private boolean c = false;
    private boolean d = true;
    private NetworkConfig e = new NetworkConfig();

    public void setForceHTTPSConnections(boolean bl) {
        this.c = bl;
    }

    public boolean isForcedToHTTPSConnections() {
        return this.c;
    }

    public void setServiceTypeIDs(LinkedList<String> linkedList) {
        this.b = linkedList;
    }

    public boolean setNetworkConfig(NetworkConfig networkConfig) {
        if (networkConfig == null) {
            return false;
        }
        this.e = networkConfig;
        return true;
    }

    public NetworkConfig getNetworkConfig() {
        return this.e;
    }

    public void setConnectionTimeout(int n) {
        this.e.setConnectionTimeOut(String.format("%d", n));
    }

    public void setReadTimeout(int n) {
        this.e.setReadTimeOut(String.format("%d", n));
    }

    private InputStream a(String object) {
        try {
            UrlClient urlClient = new UrlClient(this.e, a);
            URLCredentials uRLCredentials = new URLCredentials(this.e.getUserProxy(), this.e.getPasswordProxy(), null, null);
            RequestData requestData = new RequestData();
            object = urlClient.downloadUrl((String)object, requestData, uRLCredentials);
            if (!object.getStatus().equals("OK")) {
                return null;
            }
            object = object.getData();
            object = new ByteArrayInputStream((byte[])object);
        }
        catch (Exception exception) {
            a.error("remote download exception: " + exception.getMessage());
            return null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTSLHash(String string) {
        byte[] byArray;
        InputStream inputStream = this.a(string);
        if (inputStream == null) {
            a.error("unable to get the remote " + string);
            return "";
        }
        try {
            byArray = Util.digestStreams(Constants.SHA256, inputStream);
        }
        catch (Exception exception) {
            try {
                a.error("error evaluating hash of " + string);
                string = "";
            }
            catch (Throwable throwable) {
                try {
                    Util.closeQuietly(inputStream);
                    throw throwable;
                }
                catch (Exception exception2) {
                    a.error(String.format("error evaluating TSL hash: %s", exception2.getMessage()));
                    return "";
                }
            }
            Util.closeQuietly(inputStream);
            return string;
        }
        Util.closeQuietly(inputStream);
        return new String(Hex.encode((byte[])byArray));
    }

    public List<TSLPointer> parseListOfTSL(String object) throws CapiException {
        if (object == null || ((String)object).length() == 0) {
            return null;
        }
        object = new TSLPointer((String)object);
        try {
            Object object2 = new TSL((TSLPointer)object, this.e, this.b, !this.c);
            Date date = ((TSL)object2).getIssueDate();
            int n = ((TSL)object2).getSequenceNumber();
            object2 = ((TSL)object2).getTSLLocations();
            a.info(String.format("TSL issue date: %s\nTSL sequence number:%d\nNational TSL locations found:%d\n", date.toString(), n, object2.size()));
            return object2;
        }
        catch (CapiException capiException) {
            a.debug("[manageListOfList] Exception " + capiException.getMessage() + " code:" + capiException.getErrorCode() + " parsing TSL " + ((TSLPointer)object).getUrl());
            throw capiException;
        }
    }

    public ParsingResults parseEUStateList(TSLPointer tSLPointer, CertDB certDB) throws CapiException {
        return this.parseEUStateList(tSLPointer, certDB, null);
    }

    public ParsingResults parseEUStateList(TSLPointer tSLPointer, CertDB certDB, File object) throws CapiException {
        LinkedList<TSPService> linkedList;
        Object object2;
        ParsingResults parsingResults = new ParsingResults();
        if (tSLPointer == null || certDB == null) {
            return parsingResults;
        }
        a.debug("Parsing TSL " + tSLPointer.getUrl());
        object = tSLPointer.getArchivedFile() != null ? new TSL(tSLPointer, this.b, !this.c) : new TSL(tSLPointer, this.e, this.b, !this.c, (File)object);
        if (((TSL)object).getIssueDate() != null) {
            parsingResults.lastUpdate = ((TSL)object).getIssueDate();
        }
        if (((TSL)object).getNextIssueDate() != null) {
            parsingResults.nextUpdate = ((TSL)object).getNextIssueDate();
        }
        int n = ((TSL)object).getSequenceNumber();
        if (tSLPointer.isVerifyXMLSignature()) {
            a.debug("[parse] TSL sequence number: " + n);
            X509Certificate x509Certificate = ((TSL)object).getTslSignerCertificate();
            a.debug("[parse] TSL signer: " + x509Certificate.getSubjectDN().getName());
        }
        if ((object2 = ((TSL)object).getTrustServiceProvider()) == null || object2.isEmpty()) {
            a.debug("[parse] No TrustServiceProviders");
            a.debug("[parse] Found 0 certificates in TSL " + tSLPointer.getUrl());
            return parsingResults;
        }
        a.debug("Found " + object2.size() + " TrustServiceProviders");
        parsingResults.nProviders = object2.size();
        object = new ArrayList<Object>();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            LinkedList<X509Certificate> linkedList2 = (TrustServiceProvider)object2.next();
            Object object3 = ((TrustServiceProvider)((Object)linkedList2)).getName();
            a.debug("[parse] TSL provider: " + (String)object3);
            linkedList = ((TrustServiceProvider)((Object)linkedList2)).getTSPService();
            a.debug("[parse] Found " + linkedList.size() + " TSL service");
            parsingResults.nServices += linkedList.size();
            for (TSPService object4 : linkedList) {
                CertDBItem certDBItem;
                byte[] byArray;
                a.debug("[parse] TSL service: " + object4.getName());
                linkedList2 = object4.getCertificates();
                if (linkedList2.isEmpty()) continue;
                parsingResults.nTotalCerts += linkedList2.size();
                object3 = object4.getStatus();
                if (TSLStatus.isStatusIn(TSLStatus.StatusGroup.TRUSTED, (String)object3)) {
                    a.debug("[parse] TSL service accredited certificate: found " + linkedList2.size() + " certificates");
                    ++parsingResults.nServiceTrusted;
                    for (int i = 0; i < linkedList2.size(); ++i) {
                        try {
                            byArray = ((X509Certificate)linkedList2.get(i)).getEncoded();
                            certDBItem = certDB.contains(byArray);
                            if (certDBItem == null) {
                                if (TSLParserFactory.a(certDB, object4, byArray)) {
                                    ++parsingResults.nCertImported;
                                    certDBItem = certDB.contains(byArray);
                                    parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).add(certDBItem);
                                } else {
                                    ++parsingResults.nCertImportSkipped;
                                }
                            } else if (TSLParserFactory.a(certDB, certDBItem, 2, object4)) {
                                ++parsingResults.nCertUpdated;
                                parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).add(certDBItem);
                            } else {
                                ++parsingResults.nCertUpdateSkipped;
                            }
                            object3 = this.isSuitableIntermediateRoot(certDBItem);
                            if (object3 == null) continue;
                            object.add(object3);
                            continue;
                        }
                        catch (Exception exception) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    if (object4.getAdditionalServiceInfo().isEmpty()) {
                        if (!parsingResults.serviceTypeWithoutAdditionalSrvInfo.contains(TSLServiceType.urlToId(object4.getType()))) {
                            parsingResults.serviceTypeWithoutAdditionalSrvInfo.add(TSLServiceType.urlToId(object4.getType()));
                        }
                        ++parsingResults.nServiceWithoutAdditionalSrvInfo;
                        continue;
                    }
                    if (parsingResults.serviceTypeWithAdditionalSrvInfo.contains(TSLServiceType.urlToId(object4.getType()))) continue;
                    parsingResults.serviceTypeWithAdditionalSrvInfo.add(TSLServiceType.urlToId(object4.getType()));
                    continue;
                }
                if (TSLStatus.isStatusIn(TSLStatus.StatusGroup.WARNING, (String)object3)) {
                    a.debug("[parse] TSL service unqualified certificate: found " + linkedList2.size() + " certificates");
                    ++parsingResults.nServiceWarning;
                    for (int i = 0; i < linkedList2.size(); ++i) {
                        try {
                            byArray = ((X509Certificate)linkedList2.get(i)).getEncoded();
                            certDBItem = certDB.contains(byArray);
                            if (certDBItem == null) {
                                if (TSLParserFactory.a(certDB, object4, byArray)) {
                                    ++parsingResults.nCertImported;
                                    certDBItem = certDB.contains(byArray);
                                    parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).add(certDBItem);
                                } else {
                                    ++parsingResults.nCertImportSkipped;
                                }
                            } else if (TSLParserFactory.a(certDB, certDBItem, 2, object4)) {
                                ++parsingResults.nCertUpdated;
                                parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).add(certDBItem);
                            } else {
                                ++parsingResults.nCertUpdateSkipped;
                            }
                            object3 = this.isSuitableIntermediateRoot(certDBItem);
                            if (object3 == null) continue;
                            object.add(object3);
                            continue;
                        }
                        catch (Exception exception) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    if (object4.getAdditionalServiceInfo().isEmpty()) {
                        if (!parsingResults.serviceTypeWithoutAdditionalSrvInfo.contains(TSLServiceType.urlToId(object4.getType()))) {
                            parsingResults.serviceTypeWithoutAdditionalSrvInfo.add(TSLServiceType.urlToId(object4.getType()));
                        }
                        ++parsingResults.nServiceWithoutAdditionalSrvInfo;
                        continue;
                    }
                    if (parsingResults.serviceTypeWithAdditionalSrvInfo.contains(TSLServiceType.urlToId(object4.getType()))) continue;
                    parsingResults.serviceTypeWithAdditionalSrvInfo.add(TSLServiceType.urlToId(object4.getType()));
                    continue;
                }
                if (TSLStatus.isStatusIn(TSLStatus.StatusGroup.UNTRUSTED, (String)object3)) {
                    a.debug("[parse] TSL service accreditationrevoked certificate: found " + linkedList2.size() + " certificates");
                    ++parsingResults.nServiceUntrusted;
                    for (int i = 0; i < linkedList2.size(); ++i) {
                        try {
                            byArray = ((X509Certificate)linkedList2.get(i)).getEncoded();
                            certDBItem = certDB.contains(byArray);
                            if (certDBItem == null) {
                                if (TSLParserFactory.a(certDB, object4, byArray)) {
                                    certDBItem = certDB.contains(byArray);
                                    certDBItem.setTrust(0);
                                    certDBItem.setStatus((String)object3);
                                    if (certDB.update(certDBItem)) {
                                        certDB.store();
                                        ++parsingResults.nCertImported;
                                        parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).add(certDBItem);
                                        continue;
                                    }
                                    ++parsingResults.nCertErrors;
                                    continue;
                                }
                                ++parsingResults.nCertImportSkipped;
                                continue;
                            }
                            if (TSLParserFactory.a(certDB, certDBItem, 0, object4)) {
                                ++parsingResults.nCertUpdated;
                                parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).add(certDBItem);
                                continue;
                            }
                            ++parsingResults.nCertUpdateSkipped;
                            continue;
                        }
                        catch (Exception exception) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    continue;
                }
                if (!TSLStatus.isStatusIn(TSLStatus.StatusGroup.REMOVED, (String)object3)) continue;
                ++parsingResults.nServiceRemoved;
                a.debug("[parse] TSL service accreditationceased certificate: found " + linkedList2.size() + " certificates");
                for (int i = 0; i < linkedList2.size(); ++i) {
                    try {
                        byArray = ((X509Certificate)linkedList2.get(i)).getEncoded();
                        certDBItem = certDB.contains(byArray);
                        if (certDBItem != null) {
                            certDB.delete(certDBItem);
                            certDB.store();
                            ++parsingResults.nCertRemoved;
                            parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).add(certDBItem);
                            continue;
                        }
                        ++parsingResults.nCertRemoveSkipped;
                        continue;
                    }
                    catch (Exception exception) {
                        ++parsingResults.nCertErrors;
                    }
                }
            }
        }
        if (!object.isEmpty() && !tSLPointer.getUrl().equals(TSL.URL_DSList)) {
            a.info(String.format("%d intermediate roots found", object.size()));
            a.info("-- start parsing caIssuer --");
            object2 = this.e.getConnectionTimeOut();
            this.e.setConnectionTimeOut("5000");
            this.e.setFollowRedirect(true);
            int n2 = 0;
            try {
                for (int i = 0; i < object.size(); ++i) {
                    linkedList = new LinkedList();
                    if (!certDB.resolveChainOnLine(this.e, ((CertDBItem)object.get(i)).getCert(true), linkedList)) continue;
                    for (int j = 0; j < linkedList.size(); ++j) {
                        CertDBItem certDBItem = (CertDBItem)((Object)linkedList.get(j));
                        certDBItem.setSource(5);
                        certDBItem.resetEllipsUsage();
                        certDBItem.addEllipsUsage(CertDBItem.EllipsUsage.GENERIC_TRUSTED_ROOT);
                        certDBItem.setTslId("");
                        try {
                            certDB.add(certDBItem);
                            ++parsingResults.nCertImportedByCAIssuer;
                            parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).add(certDBItem);
                            ++n2;
                            continue;
                        }
                        catch (Exception exception) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    certDB.store();
                }
            }
            catch (Throwable throwable) {
                this.e.setConnectionTimeOut((String)object2);
                this.e.setFollowRedirect(false);
                a.info(String.format("%d caIssuer added", n2));
                a.info("-- end parsing caIssuer --");
                throw throwable;
            }
            this.e.setConnectionTimeOut((String)object2);
            this.e.setFollowRedirect(false);
            a.info(String.format("%d caIssuer added", n2));
            a.info("-- end parsing caIssuer --");
        }
        return parsingResults;
    }

    private static boolean a(CertDB certDB, CertDBItem certDBItem, int n, TSPService tSPService) throws CertDBException, CapiException {
        boolean bl = false;
        if (certDBItem.getTrust() != n) {
            certDBItem.setTrust(n);
            bl = true;
        }
        if (certDBItem.getStatus() == null || certDBItem.getStatus().isEmpty() || !certDBItem.getStatus().equals(tSPService.getStatus())) {
            certDBItem.setStatus(tSPService.getStatus());
            bl = true;
        }
        if ((n = certDBItem.getSource()) == 3 || n == 4 || n == 5) {
            certDBItem.setSource(1);
            bl = true;
        }
        List<CertDBItem.EllipsUsage> list = tSPService.getEllipsUsagesForService();
        List<CertDBItem.EllipsUsage> list2 = certDBItem.getEllipsUsages();
        boolean bl2 = false;
        if (list.size() != list2.size()) {
            bl2 = true;
        } else {
            for (CertDBItem.EllipsUsage ellipsUsage : list) {
                if (list2.contains((Object)ellipsUsage)) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            certDBItem.addEllipsUsages(list);
            bl = true;
        }
        if (!certDBItem.getTslId().equals(tSPService.getTslId())) {
            certDBItem.setTslId(tSPService.getTslId());
            bl = true;
        }
        return bl &= certDB.update(certDBItem);
    }

    private static boolean a(CertDB certDB, TSPService tSPService, byte[] object) throws CapiException {
        try {
            CertDBItem certDBItem = certDB.canImport((byte[])object);
            object = certDBItem;
            Certificate certificate = certDBItem.getCertificate();
            ((CertDBItem)object).setName(certificate.getName());
            ((CertDBItem)object).setSubjectAndIssuer(certificate);
            ((CertDBItem)object).setSource(1);
            ((CertDBItem)object).setTslId(tSPService.getTslId());
            ((CertDBItem)object).setStatus(tSPService.getStatus());
            ((CertDBItem)object).resetEllipsUsage();
            ((CertDBItem)object).addEllipsUsages(tSPService.getEllipsUsagesForService());
            certDB.add((CertDBItem)object);
            a.debug("[importCert] successfully done.");
            return true;
        }
        catch (CapiException capiException) {
            a.debug("[importCert] Capi Exception " + capiException.getErrorCode() + " importing cert: " + capiException.getMessage());
            int n = capiException.getErrorCode();
            if (n == 80000 || n == 80003 || n == 80004 || n == 80005 || n == 80006 || n == 80007) {
                a.debug("[importCert] restoring certDB...");
                throw capiException;
            }
            return false;
        }
    }

    public boolean isCompleteChain() {
        return this.d;
    }

    public void setCompleteChain(boolean bl) {
        this.d = bl;
    }

    public CertDBItem isSuitableIntermediateRoot(CertDBItem certDBItem) throws CapiException {
        if (!this.d) {
            return null;
        }
        if (certDBItem.getCertificate().getSubjectDN().equals(certDBItem.getCertificate().getIssuerDN())) {
            a.debug(certDBItem.getName() + " is not suitable to be an intermediate root in the chain because seems self-signed");
            return null;
        }
        if (certDBItem.getCertificate().getCaIssuer() == null) {
            a.debug(certDBItem.getName() + " is not suitable to be an intermediate root in the chain because caIssuer link is null");
            return null;
        }
        return certDBItem;
    }
}

