/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisProvider;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;

public class ProvUtils {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final Provider bcProvider = new BouncyCastleProvider();
    public static final Provider actalisProvider = new ActalisProvider();

    public static final void removeProvider(String string) {
        while (Security.getProvider(string) != null) {
            a.debug("removingProvider name=" + string);
            Security.removeProvider(string);
        }
    }

    public static Provider retrieveBestProviderForKey(PrivateKey privateKey) {
        Object object = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        Iterator<TokenManager> iterator = ((ServiceLoader)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if ((object = object.retrieveProviderForKey(privateKey)) == null) continue;
            return object;
        }
        return bcProvider;
    }

    public static TokenSpi retrieveTokenByAlias(String string) {
        Object object = null;
        Object object2 = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        object2 = ((ServiceLoader)object2).iterator();
        while (object2.hasNext()) {
            object = (TokenManager)object2.next();
            if ((object = object.retrieveTokenByAlias(string)) == null) continue;
        }
        return object;
    }
}

