/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import it.actalis.ellips.capi.core.ProvUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class OCSPRequest {
    private final OCSPReq a;
    private final X509Certificate b;
    private final X509Certificate c;
    private CertificateID d;
    private byte[] e;

    public OCSPRequest(X509Certificate object, X509Certificate x509Certificate, boolean bl, boolean bl2) throws Exception {
        this.b = object;
        this.c = x509Certificate;
        boolean bl3 = bl;
        bl = bl2;
        boolean bl4 = bl3;
        object = this;
        DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
        digestCalculatorProvider = digestCalculatorProvider.get(CertificateID.HASH_SHA1);
        ((OCSPRequest)object).d = new CertificateID((DigestCalculator)digestCalculatorProvider, (X509CertificateHolder)new JcaX509CertificateHolder(((OCSPRequest)object).c), ((OCSPRequest)object).b.getSerialNumber());
        digestCalculatorProvider = new OCSPReqBuilder();
        digestCalculatorProvider.addRequest(((OCSPRequest)object).d);
        Extension extension = null;
        Extension extension2 = null;
        if (bl) {
            BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
            extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(bigInteger.toByteArray()));
            ((OCSPRequest)object).e = extension.getExtnValue().getEncoded();
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        object = new DERSequence(aSN1EncodableVector);
        if (bl4) {
            extension2 = new Extension(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.4"), false, (ASN1OctetString)new DEROctetString(object.getEncoded()));
        }
        if (extension != null && extension2 != null) {
            digestCalculatorProvider.setRequestExtensions(new Extensions(new Extension[]{extension, extension2}));
        } else if (extension == null && extension2 != null) {
            digestCalculatorProvider.setRequestExtensions(new Extensions(new Extension[]{extension2}));
        } else if (extension != null) {
            digestCalculatorProvider.setRequestExtensions(new Extensions(new Extension[]{extension}));
        }
        object = digestCalculatorProvider.build();
        this.a = object;
    }

    public X509Certificate getSubjectCert() {
        return this.b;
    }

    public X509Certificate getIssuerCert() {
        return this.c;
    }

    public byte[] getNonce() {
        return this.e;
    }

    public byte[] getEncodedOCSPReq() {
        try {
            return this.a.getEncoded();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OCSPReq getOCSPReq() {
        return this.a;
    }

    public CertificateID getReqCert() {
        return this.d;
    }
}

