/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

public class StepX509TimestampKeyUsageCompliance
extends SingleValidationSubStepImpl {
    public StepX509TimestampKeyUsageCompliance() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> cloneable, ValidationContextParameters validationContextParameters) {
        block6: {
            cloneable = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            ((DateFormat)cloneable).setTimeZone(validationContextParameters.getTimeZone());
            cloneable = validationContextParameters.getCalculatedValidationDate().getDate();
            if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getFormat() != null && validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST) && validationContextParameters.getSignerCertificate().getCert() != null) {
                String string;
                Certificate certificate = validationContextParameters.getSignerCertificate().getCert();
                try {
                    string = validationContextParameters.getSignerCertificate().getCert().keyUsageToString(certificate.getKeyUsage());
                }
                catch (CapiException capiException) {
                    string = "";
                }
                try {
                    String[] stringArray = certificate.getExtendedKeyUsage();
                    if ((!string.contains("digitalSignature") || stringArray.length != 1 || !stringArray[0].equalsIgnoreCase("1.3.6.1.5.5.7.3.8") || certificate.getPolicies(';').length == 0 || certificate.getAuthorityKeyIdentifier().length == 0 || certificate.getSubjectKeyIdentifier().length == 0) && ((Date)cloneable).after(Constants.DPCM_CNIPA_45_2009) && ((Date)cloneable).before(Constants.DPCM_AGID_121_2019)) {
                        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0013_CERT_TSA_NOCNIPA45, this.getClass().getName());
                    }
                }
                catch (CapiException capiException) {
                    this.logger.error(capiException.getMessage(), (Throwable)capiException);
                    if (!((Date)cloneable).after(Constants.DPCM_CNIPA_45_2009) || !((Date)cloneable).before(Constants.DPCM_AGID_121_2019)) break block6;
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0013_CERT_TSA_NOCNIPA45, this.getClass().getName());
                }
            }
        }
        return null;
    }
}

