/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Utils;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;

public class TimeStampStepSignatureDetailsInfo
extends MultipleValidationSubStepImpl {
    public TimeStampStepSignatureDetailsInfo() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        linkedList = new LinkedList();
        if (validationContextParameters != null && validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getTstSpecific() != null) {
            Object object;
            try {
                object = new TimeStampToken(validationContextParameters.getSignature().getSignatureInfo());
            }
            catch (CapiException capiException) {
                return linkedList;
            }
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0007_MARK_DATE, validationContextParameters.getSignature().getSignatureDate()));
            if (((TimeStampToken)object).getPolicyId() != null) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0008_MARK_POLICY_ID, ((TimeStampToken)object).getPolicyId()));
            }
            if (((TimeStampToken)object).getSerialNumber() != null) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0009_MARK_SERIAL_NUMBER, ((TimeStampToken)object).getSerialNumber().toString(16)));
            }
            try {
                if (((TimeStampToken)object).getSigningCertificateV2HashAlg() != null) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0010_MARK_HASH_ALGORITHM, Utils.oidToHashAlgName(((TimeStampToken)object).getSigningCertificateV2HashAlg())));
                }
            }
            catch (CapiException capiException) {}
            if (!((TimeStampToken)object).isEIDASCompliance()) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0010_TIMESTAMP_NOEIDASCOMPLIANCE, new Object[0]));
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0011_TIMESTAMP_VALIDITY, new Object[0]));
            } else {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0011_MARK_EIDAS_COMPLIANCE, new Object[0]));
                try {
                    object = ((TimeStampToken)object).getAccuracy();
                    if (object != null) {
                        object = object.getSeconds();
                        object = object.getValue();
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0012_MARK_ACCURACY, String.format("%d", ((BigInteger)object).intValue() * 1000)));
                    }
                }
                catch (ApiGeneralException apiGeneralException) {}
            }
        }
        return linkedList;
    }
}

