/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.filter.Base64InputFilter;
import it.actalis.ellips.capi.datahandlers.inputs.filter.PEMInputFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.x500.X500Name;

public class DerParserUtils {
    private static InputHandler a(InputHandler inputHandler, boolean bl) throws CapiException {
        InputHandler inputHandler2;
        if (inputHandler == null) {
            return null;
        }
        try {
            int n = inputHandler.getInputAsNewStream().read();
            boolean bl2 = n == 48;
            if ((n = n == 45 ? 1 : 0) == 0 && !bl2) {
                inputHandler.addFilter(new Base64InputFilter());
            } else if (n != 0) {
                inputHandler.addFilter(new PEMInputFilter());
            }
            inputHandler2 = inputHandler;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            if (bl) {
                inputHandler.resetFilter();
            }
        }
        return inputHandler2;
    }

    public static String retrieveDerID(InputHandler inputHandler, boolean bl) throws CapiException {
        try {
            inputHandler = DerParserUtils.a(inputHandler, bl);
            inputHandler = new ASN1StreamParser(inputHandler.getInputAsNewStream());
            inputHandler = (ASN1SequenceParser)inputHandler.readObject();
            ASN1Encodable aSN1Encodable = inputHandler.readObject();
            if (aSN1Encodable.toASN1Primitive() instanceof ASN1Sequence) {
                aSN1Encodable = inputHandler.readObject();
                inputHandler = ((ASN1Sequence)aSN1Encodable.toASN1Primitive()).parser();
                aSN1Encodable = inputHandler.readObject();
            }
            if (aSN1Encodable == null || !(aSN1Encodable instanceof ASN1ObjectIdentifier)) {
                return null;
            }
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Encodable;
            if (aSN1ObjectIdentifier.getId().equals("1.2.840.113549.1.7.2")) {
                aSN1Encodable = inputHandler.readObject();
                if (aSN1Encodable instanceof ASN1TaggedObject) {
                    aSN1Encodable = ((ASN1TaggedObject)aSN1Encodable).getObject();
                    inputHandler = ((ASN1Sequence)aSN1Encodable.toASN1Primitive()).parser();
                    inputHandler.readObject();
                    inputHandler.readObject();
                    aSN1Encodable = inputHandler.readObject();
                    inputHandler = ((ASN1Sequence)aSN1Encodable.toASN1Primitive()).parser();
                    aSN1Encodable = inputHandler.readObject();
                    if (aSN1Encodable == null || !(aSN1Encodable instanceof ASN1ObjectIdentifier)) {
                        return null;
                    }
                    aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Encodable;
                    return aSN1ObjectIdentifier.getId();
                }
                if (aSN1Encodable instanceof BERTaggedObjectParser && DerParserUtils.a((ASN1SequenceParser)(inputHandler = (ASN1SequenceParser)((BERTaggedObjectParser)aSN1Encodable).getObjectParser(0, true)), "1.2.840.113549.1.9.16.1.4")) {
                    return "1.2.840.113549.1.9.16.1.4";
                }
            } else {
                return aSN1ObjectIdentifier.getId();
            }
            return aSN1ObjectIdentifier.getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean a(ASN1SequenceParser aSN1SequenceParser, String string) {
        try {
            ASN1Encodable aSN1Encodable = aSN1SequenceParser.readObject();
            while (aSN1Encodable != null) {
                boolean bl;
                if (aSN1Encodable instanceof ASN1ObjectIdentifier ? (aSN1Encodable = (ASN1ObjectIdentifier)aSN1Encodable).getId().equals(string) : aSN1Encodable instanceof DERSequenceParser && (bl = DerParserUtils.a(((ASN1Sequence)aSN1Encodable.toASN1Primitive()).parser(), string))) {
                    return true;
                }
                aSN1Encodable = aSN1SequenceParser.readObject();
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void validateESSCertID(ESSCertID object, X509Certificate x509Certificate) throws CapiException {
        try {
            if (!MessageDigest.isEqual(object.getCertHash(), MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider).digest(x509Certificate.getEncoded()))) {
                throw new CapiException("ESSCertIDv1 certificate hash does not match certID hash", 30003);
            }
            if (object.getIssuerSerial() != null) {
                if (!object.getIssuerSerial().getSerial().getValue().equals(x509Certificate.getSerialNumber())) {
                    throw new CapiException("ESSCertIDv1 certificate serial number does not match certID serial number", 30003);
                }
                object = object.getIssuerSerial().getIssuer().getNames();
                x509Certificate = X500Name.getInstance((Object)ASN1Primitive.fromByteArray((byte[])x509Certificate.getIssuerX500Principal().getEncoded()));
                boolean bl = false;
                for (int i = 0; i != ((Object)object).length; ++i) {
                    if (object[i].getTagNo() != 4 || !X500Name.getInstance((Object)object[i].getName()).equals((Object)x509Certificate)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new CapiException("ESSCertIDv1 certificate Issuer Name does not match certID Issuer Name", 30003);
                }
            }
            return;
        }
        catch (Exception exception) {
            object = exception;
            if (exception instanceof CapiException) {
                throw new CapiException(((Throwable)object).getMessage(), ((CapiException)object).getErrorCode(), (Throwable)object);
            }
            throw new CapiException(((Throwable)object).getMessage(), 3010, (Throwable)object);
        }
    }

    public static void validateESSCertID(ESSCertIDv2 object, X509Certificate x509Certificate) throws CapiException {
        try {
            if (!MessageDigest.isEqual(object.getCertHash(), MessageDigest.getInstance(object.getHashAlgorithm().getAlgorithm().getId(), ProvUtils.bcProvider).digest(x509Certificate.getEncoded()))) {
                throw new CapiException("ESSCertIDv2 certificate hash does not match certID hash", 30003);
            }
            if (object.getIssuerSerial() != null) {
                if (!object.getIssuerSerial().getSerial().getValue().equals(x509Certificate.getSerialNumber())) {
                    throw new CapiException("ESSCertIDv2 certificate serial number does not match certID serial number", 30003);
                }
                object = object.getIssuerSerial().getIssuer().getNames();
                x509Certificate = X500Name.getInstance((Object)ASN1Primitive.fromByteArray((byte[])x509Certificate.getIssuerX500Principal().getEncoded()));
                boolean bl = false;
                for (int i = 0; i != ((Object)object).length; ++i) {
                    if (object[i].getTagNo() != 4 || !X500Name.getInstance((Object)object[i].getName()).equals((Object)x509Certificate)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new CapiException("ESSCertIDv2 certificate Issuer Name does not match certID Issuer Name", 30003);
                }
            }
            return;
        }
        catch (Exception exception) {
            object = exception;
            if (exception instanceof CapiException) {
                throw new CapiException(((Throwable)object).getMessage(), ((CapiException)object).getErrorCode(), (Throwable)object);
            }
            throw new CapiException(((Throwable)object).getMessage(), 3010, (Throwable)object);
        }
    }
}

