/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.ldap;

import com.sun.jndi.ldap.LdapURL;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.ldap.LdapEntry;
import it.actalis.ellips.capi.ldap.LdapException;
import it.actalis.ellips.capi.net.CapiSocketFactory;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;

public class LdapClient {
    private Properties env = new Properties();
    private NetworkConfig config = new NetworkConfig();
    private LdapContext ctx;
    private String baseDN = null;
    private String baseUrl = null;

    public NetworkConfig getConfig() {
        return this.config;
    }

    public void setConfig(NetworkConfig config) {
        this.config = config;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public LdapClient(String host, int port, String baseDN) throws LdapException {
        this(host, port, baseDN, 0);
    }

    public LdapClient(String host, int port, String baseDN, int timeout) throws LdapException {
        this(host, port, baseDN, timeout, null, 0);
    }

    public LdapClient(String host, int port, String baseDN, int timeout, NetworkConfig conf) throws LdapException {
        this.config = conf;
        try {
            this.baseDN = baseDN;
            this.baseUrl = "ldap://" + host + ":" + port;
            this.env = new Properties();
            this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            this.env.put("java.naming.provider.url", this.baseUrl);
            this.env.put("java.naming.security.authentication", "none");
            this.env.put("com.sun.jndi.ldap.connect.timeout", "" + timeout);
            this.env.put("java.naming.ldap.attributes.binary", "userCertificate");
            this.env.put("java.naming.ldap.factory.socket", "it.actalis.ellips.capi.net.CapiSocketFactory");
            CapiSocketFactory.getThreadNetworkConfig().put("" + Thread.currentThread().getId(), this.config);
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
    }

    public LdapClient(String host, int port, String baseDN, int timeout, String sockProxy, int sockProxyPort) throws LdapException {
        try {
            this.baseDN = baseDN;
            this.baseUrl = "ldap://" + host + ":" + port;
            this.config.setLdapProxyType("socks");
            this.config.setLdapProxy(sockProxy);
            this.config.setLdapProxyPort(sockProxyPort != 0 ? "" + sockProxyPort : "");
            this.env = new Properties();
            this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            this.env.put("java.naming.provider.url", this.baseUrl);
            this.env.put("java.naming.security.authentication", "none");
            this.env.put("com.sun.jndi.ldap.connect.timeout", "" + timeout);
            this.env.put("java.naming.ldap.attributes.binary", "userCertificate");
            this.env.put("java.naming.ldap.factory.socket", "it.actalis.ellips.capi.net.CapiSocketFactory");
            CapiSocketFactory.getThreadNetworkConfig().put("" + Thread.currentThread().getId(), this.config);
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
    }

    public LdapClient(String host, int port, String username, String password) throws LdapException {
        this.baseUrl = "ldap://" + host + ":" + port;
        CapiSocketFactory.getThreadNetworkConfig().put("" + Thread.currentThread().getId(), this.config);
        this.env.put("java.naming.security.principal", username + "@" + host);
        this.env.put("java.naming.security.credentials", password);
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.provider.url", this.baseUrl);
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.ldap.attributes.binary", "userCertificate");
        this.env.put("java.naming.ldap.factory.socket", "it.actalis.ellips.capi.net.CapiSocketFactory");
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
    }

    public LdapClient(String host, int port, String username, String password, boolean secure) throws LdapException {
        this.baseUrl = "ldap://" + host + ":" + port;
        if (secure) {
            this.baseUrl = "ldaps://" + host + ":" + port;
        }
        CapiSocketFactory.getThreadNetworkConfig().put("" + Thread.currentThread().getId(), this.config);
        this.env.put("java.naming.security.principal", username);
        this.env.put("java.naming.security.credentials", password);
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.provider.url", this.baseUrl);
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.ldap.attributes.binary", "userCertificate");
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
    }

    public LdapClient(String host, int port, String username, String password, NetworkConfig networkConfig) throws LdapException {
        this.baseUrl = "ldap://" + host + ":" + port;
        this.config = networkConfig;
        CapiSocketFactory.getThreadNetworkConfig().put("" + Thread.currentThread().getId(), this.config);
        this.env.put("java.naming.security.principal", username + "@" + host);
        this.env.put("java.naming.security.credentials", password);
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.provider.url", this.baseUrl);
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.ldap.attributes.binary", "userCertificate");
        this.env.put("java.naming.ldap.factory.socket", "it.actalis.ellips.capi.net.CapiSocketFactory");
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
    }

    private static boolean objExists(DirContext ctx, String name) throws NamingException {
        boolean blnReturn = true;
        try {
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search(name, null);
        }
        catch (NameNotFoundException ex) {
            blnReturn = false;
        }
        catch (NamingException ex2) {
            throw ex2;
        }
        return blnReturn;
    }

    public LdapEntry[] advSearchEntries(String filter, int maxEntries) throws LdapException {
        ArrayList<LdapEntry> objReturn = new ArrayList<LdapEntry>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            byte[] cookie = null;
            this.ctx.setRequestControls(new Control[]{new PagedResultsControl(maxEntries, false)});
            int total = 0;
            if (LdapClient.objExists(this.ctx, this.baseDN)) {
                do {
                    NamingEnumeration<SearchResult> lstName = this.ctx.search(this.baseDN, filter, ctls);
                    while (lstName.hasMore()) {
                        SearchResult entrySearch = lstName.next();
                        LdapEntry entry = new LdapEntry(entrySearch.getAttributes(), entrySearch.getNameInNamespace());
                        objReturn.add(entry);
                        if (maxEntries <= 0 || objReturn.size() < maxEntries) continue;
                        break;
                    }
                    if (maxEntries > 0 && objReturn.size() >= maxEntries) break;
                    Control[] controls = this.ctx.getResponseControls();
                    if (controls != null) {
                        for (int i = 0; i < controls.length; ++i) {
                            if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                            PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                            total = prrc.getResultSize();
                            if (total != 0) {
                                System.out.println("***************** END-OF-PAGE (total : " + total + ") *****************\n");
                            } else {
                                System.out.println("***************** END-OF-PAGE (total: unknown) ***************\n");
                            }
                            cookie = prrc.getCookie();
                        }
                    } else {
                        System.out.println("No controls were sent from the server");
                    }
                    this.ctx.setRequestControls(new Control[]{new PagedResultsControl(maxEntries, cookie, true)});
                } while (cookie != null);
            }
            return objReturn.toArray(new LdapEntry[objReturn.size()]);
        }
        catch (NamingException ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
        catch (Exception ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
    }

    public LdapEntry getEntry(String DN) throws LdapException {
        LdapEntry findEntry = null;
        try {
            LdapName name = new LdapName(DN);
            Attributes attr = this.ctx.getAttributes(name);
            if (attr != null) {
                findEntry = new LdapEntry(attr, DN);
            }
            return findEntry;
        }
        catch (NamingException ex) {
            throw new LdapException(ex.getMessage(), 90003, ex);
        }
    }

    private void close() throws NamingException {
        if (this.ctx != null) {
            this.ctx.close();
        }
        if (CapiSocketFactory.getThreadNetworkConfig().containsKey(String.valueOf(Thread.currentThread().getId()))) {
            CapiSocketFactory.getThreadNetworkConfig().remove(String.valueOf(Thread.currentThread().getId()));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static String[] parseUrl(String ldapUrl) throws LdapException {
        String attributes;
        int slash_idx;
        int beg_url = ldapUrl.indexOf("//", 0);
        if (beg_url == -1) {
            throw new LdapException("Malformed URL", 90010);
        }
        int end_url = ldapUrl.indexOf("/", beg_url + 2);
        int query_url = ldapUrl.indexOf("?", end_url + 1);
        if (end_url != -1 && ldapUrl.length() > end_url && (slash_idx = ldapUrl.indexOf("/", end_url + 1)) != -1 && (query_url == -1 || slash_idx <= query_url)) {
            String ldapHost = ldapUrl.substring(0, end_url + 1);
            String ldapDn = ldapUrl.substring(end_url + 1);
            String escapedDn = ldapDn.replace("/", "%2f");
            ldapUrl = ldapHost + escapedDn;
        }
        String[] res = new String[4];
        LdapURL url = null;
        try {
            url = new LdapURL(ldapUrl);
        }
        catch (Exception e) {
            throw new LdapException("Malformed URL", 90010, e);
        }
        res[0] = url.getHost();
        if (res[0] == null) {
            throw new LdapException("Malformed URL: no server", 90010);
        }
        res[1] = "" + url.getPort();
        res[2] = url.getDN();
        if (res[2] == null) {
            res[2] = "";
        }
        res[3] = (attributes = url.getAttributes()) == null ? "certificateRevocationList;binary" : attributes;
        return res;
    }

    public DirContext getDirContext() {
        return this.ctx;
    }
}

