/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.util;

import java.util.Arrays;

public class LiveBytePushQueue {
    private byte[] data = null;
    private int maxSize = 0;
    private int count = 0;

    public int getCount() {
        return this.count;
    }

    public LiveBytePushQueue(int size) {
        this.maxSize = size;
        this.count = 0;
        this.data = new byte[this.maxSize];
    }

    public Byte getByte(int index) {
        if (index >= this.count) {
            return null;
        }
        return this.data[index];
    }

    public byte[] getDataCopy() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public byte[] getValidData() {
        return Arrays.copyOfRange(this.data, 0, this.count);
    }

    public boolean offer(byte b) {
        if (this.count >= this.maxSize) {
            return false;
        }
        this.data[this.count] = b;
        ++this.count;
        return true;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean isFull() {
        return this.count == this.maxSize;
    }

    public void clear() {
        this.count = 0;
    }
}

