/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.PathConverter;
import esecurity.dsd.client.cmd.Command;
import esecurity.dsd.client.cmd.commands.CommandAddUser;
import esecurity.dsd.client.cmd.commands.CommandChngPwdUser;
import esecurity.dsd.client.cmd.commands.CommandChngUserroles;
import esecurity.dsd.client.cmd.commands.CommandCreateDomain;
import esecurity.dsd.client.cmd.commands.CommandDelete;
import esecurity.dsd.client.cmd.commands.CommandEditDomain;
import esecurity.dsd.client.cmd.commands.CommandGenerate;
import esecurity.dsd.client.cmd.commands.CommandGet;
import esecurity.dsd.client.cmd.commands.CommandGetUser;
import esecurity.dsd.client.config.FilePropertiesConfigurationProvider;
import esecurity.dsd.client.config.RemoteConfigProvider;
import esecurity.dsd.core.LocalConfigurationProvider;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;

@Parameters(separators="=")
public class CommandLineExecutor {
    @Parameter(names={"--help", "?"}, help=true)
    private boolean help;
    @Parameter(names={"remote", "server", "--host"}, description="URL of remote server")
    private String remote;
    @Parameter(names={"proxy", "--proxy"}, description="URL of proxy server")
    private String proxy = null;
    @Parameter(names={"--proxyPort"}, description="Port of proxy server")
    private Integer proxyPort;
    @Parameter(names={"--proxyUser"}, description="username of proxy server")
    private String proxyUsername;
    @Parameter(names={"--proxyPassword"}, password=true, description="Specify a Proxy password", echoInput=false)
    private String proxyPassword = null;
    @Parameter(names={"--nosecure"}, description="No SSL connection ")
    private boolean nosecure = false;
    @Parameter(names={"--secure"}, description="Force SSL connection ")
    private boolean secure = false;
    @Parameter(names={"--config", "-c", "-f"}, converter=PathConverter.class, description="Specify config filename")
    private Path configFile = null;
    @Parameter(names={"--username", "-u"}, description="Specify a connection username ")
    private String username = null;
    @Parameter(names={"--password", "-p"}, password=true, description="Specify a Connection password", echoInput=false)
    private String password = null;
    @Parameter(names={"--port"}, description="Specify a port")
    private Integer port = null;
    @Parameter(names={"--version"}, description="Software version ")
    private boolean version = false;
    private Command[] commands = new Command[]{new CommandGet(), new CommandCreateDomain(), new CommandEditDomain(), new CommandDelete(), new CommandAddUser(), new CommandGetUser(), new CommandChngPwdUser(), new CommandChngUserroles(), new CommandGenerate()};

    public Command[] getCommands() {
        return this.commands;
    }

    public void execute(JCommander commander) {
        if (this.help) {
            commander.usage();
            return;
        }
        String parsedCommand = Optional.ofNullable(commander.getParsedCommand()).orElse("").toUpperCase();
        boolean useSSL = true;
        if (!this.secure) {
            useSSL = !this.nosecure;
        }
        LocalConfigurationProvider localConfigurator = null;
        if (this.configFile != null) {
            localConfigurator = new FilePropertiesConfigurationProvider(this.getConfigFile());
        } else if (this.remote != null && this.username != null && this.password != null) {
            RemoteConfigProvider.Builder remoteBuilder = RemoteConfigProvider.create("DSN").host(this.remote).username(this.username).password(this.password).useSSL(useSSL);
            if (this.port != null) {
                remoteBuilder.port(this.port);
            }
            if (this.proxy != null) {
                remoteBuilder.proxyAddress(this.proxy).proxyPort(this.proxyPort).proxyAuthentication(this.proxyUsername, this.proxyPassword);
            }
            localConfigurator = remoteBuilder.build();
        }
        Optional<Command> command = Stream.of(this.commands).filter(cmd -> cmd.getCommand().equalsIgnoreCase(parsedCommand)).findFirst();
        if (command.isPresent()) {
            command.get().execute(localConfigurator);
        }
    }

    public Path getConfigFile() {
        return this.configFile;
    }

    public boolean isHelp() {
        return this.help;
    }
}

