/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import esecurity.dts.TimeStampToken;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CRLException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.TempFileOutputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pades.PadesSignatureOptions;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.pades.a;
import it.actalis.ellips.capi.pades.b;
import it.actalis.ellips.capi.pades.enums.PadesCertificationLevel;
import it.actalis.ellips.capi.pades.enums.PdfProfile;
import it.actalis.ellips.capi.pdf.AutenticaBinding;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.pdf.FeaInfo;
import it.actalis.ellips.capi.pdf.GraphometricInfo;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.RevisionInformation;
import it.actalis.ellips.capi.pdf.SignedPDF;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;

public class PadesSignatureGenerator
extends SignatureGenerator<PadesSignatureOptions> {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final byte[] b = new byte[]{37, 37, 69, 79, 70};
    private static final byte[] c = new byte[]{37, 37, 69, 79, 70, 10};
    private static final byte[] d = new byte[]{37, 37, 69, 79, 70, 13, 10};
    private static final int e = 6;
    private org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions f;

    private static PDDocument a(PadesSignatureOptions padesSignatureOptions, ScratchFile scratchFile, RandomAccessRead randomAccessRead) throws IOException, CapiException {
        String string = null;
        if (padesSignatureOptions.getOwnerPassword() == null) {
            a.debug("[initialize] decrypting password is null...");
        } else {
            a.debug("[initialize] decrypting password is not null...");
            string = padesSignatureOptions.getOwnerPassword();
        }
        padesSignatureOptions = string != null ? new PDFParser(randomAccessRead, string, null, null, scratchFile) : new PDFParser(randomAccessRead, scratchFile);
        padesSignatureOptions = padesSignatureOptions.parse();
        if (padesSignatureOptions.getCurrentAccessPermission() != null && !padesSignatureOptions.getCurrentAccessPermission().canModify() && !padesSignatureOptions.getCurrentAccessPermission().canModifyAnnotations()) {
            throw new CapiException("Cannot decrypt PDF, the password is incorrect", 50004);
        }
        return padesSignatureOptions;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerSign(PadesSignatureOptions padesSignatureOptions) throws CapiException {
        ScratchFile scratchFile = null;
        PDDocument pDDocument = null;
        InputHandler inputHandler = null;
        OutputHandler outputHandler = null;
        File file = null;
        try {
            Object object5;
            Object object2;
            Object object3;
            long l;
            scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
            InputStream inputStream = padesSignatureOptions.getInput().getInputAsNewStream();
            Serializable serializable = padesSignatureOptions.getInput().getTotalSize();
            OutputStream outputStream = padesSignatureOptions.getOutput().getAsOutputStream();
            inputStream = scratchFile.createBuffer(inputStream);
            if (serializable == null) {
                serializable = Long.valueOf(inputStream.length());
            }
            if ((l = this.a((RandomAccessRead)inputStream)) != -1L && l != (Long)serializable) {
                block48: {
                    inputStream = TmpFileUtils.createTempFile((String)"toSign", (String)".pdf");
                    object3 = new FileOutputStream((File)((Object)inputStream));
                    object2 = null;
                    try {
                        object5 = padesSignatureOptions.getInput().getInputAsNewStream();
                        serializable = null;
                        try {
                            int n;
                            byte[] byArray = new byte[8192];
                            long l2 = l;
                            while ((n = ((InputStream)object5).read(byArray)) > 0 && l2 > 0L) {
                                if ((l2 -= (long)n) < 0L) {
                                    n = (int)((long)n + l2);
                                }
                                ((FileOutputStream)object3).write(byArray, 0, n);
                            }
                            if (object5 == null) break block48;
                        }
                        catch (Throwable throwable) {
                            try {
                                Throwable throwable2 = throwable;
                                serializable = throwable;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (object5 == null) throw throwable3;
                                if (serializable == null) {
                                    ((InputStream)object5).close();
                                    throw throwable3;
                                }
                                try {
                                    ((InputStream)object5).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    ((Throwable)serializable).addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        ((InputStream)object5).close();
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwable throwable5 = throwable;
                            object2 = throwable;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (object2 == null) {
                                ((FileOutputStream)object3).close();
                                throw throwable6;
                            }
                            try {
                                ((FileOutputStream)object3).close();
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                ((Throwable)object2).addSuppressed(throwable7);
                                throw throwable6;
                            }
                        }
                    }
                }
                ((FileOutputStream)object3).close();
                Util.closeQuietly((Closeable)scratchFile);
                scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
                inputStream = scratchFile.createBuffer((InputStream)new FileInputStream((File)((Object)inputStream)));
                serializable = Long.valueOf(l);
            }
            object3 = inputStream;
            boolean bl = false;
            Object object4 = new byte[5];
            if (object3.read(object4, 0, 5) != -1) {
                object2 = new String((byte[])object4);
                bl = ((String)object2).startsWith("%FDF-") || ((String)object2).startsWith("%PDF-");
            }
            object3.seek(0L);
            if (!bl) throw new IOException("Il file che stato sottoposto alla firma non \u00e8 di tipo PDF");
            pDDocument = PadesSignatureGenerator.a(padesSignatureOptions, scratchFile, (RandomAccessRead)inputStream);
            boolean bl2 = false;
            if (padesSignatureOptions.isPreservePdfA()) {
                object3 = pDDocument.getDocumentCatalog().getOutputIntents();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object5 = (PDOutputIntent)object2.next();
                    if (object5.getInfo() != null && object5.getInfo().contains("Dot Gain")) {
                        a.debug("OutputIntent{}", (Object)object5.getInfo());
                        bl2 = true;
                        break;
                    }
                    if (object5.getInfo() == null || object5.getInfo().contains("sRGB")) continue;
                    throw new CapiException("PDFA OutputIntent not supported.", 50023);
                }
            }
            object3 = new LinkedList();
            if (pDDocument.getDocumentCatalog().getAcroForm() != null) {
                PadesSignatureGenerator.a(pDDocument);
                for (Object object5 : pDDocument.getDocumentCatalog().getAcroForm().getFields()) {
                    object3.addAll(PadesUtils.parseEmptyField((PDField)object5));
                }
            }
            this.a(pDDocument, padesSignatureOptions, (Long)serializable, (List<PDSignatureField>)object3, bl2);
            if (padesSignatureOptions.getSignatureLevel().compareTo((Enum)SignatureLevel.T) > 0 || padesSignatureOptions.isIncludeCertificateChain()) {
                outputHandler = DataHandlerBuilder.get().setTemp("PDF_UPDATE", ".tmp").buildOutput();
                ((TempFileOutputHandler)outputHandler).setDeleteOnClose(false);
                pDDocument.saveIncremental(outputHandler.getAsOutputStream());
                Util.closeQuietly((Closeable)scratchFile);
                Util.closeQuietly((Closeable)pDDocument);
                file = ((TempFileOutputHandler)outputHandler).getFile();
                inputHandler = DataHandlerBuilder.get().setFile(file).buildInput();
                scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
                Object object6 = scratchFile.createBuffer(inputHandler.getInputAsNewStream());
                pDDocument = PadesSignatureGenerator.a(padesSignatureOptions, scratchFile, (RandomAccessRead)object6);
                object2 = PadesUtils.retrieveNotEmptySignatures(pDDocument);
                object5 = "" + (((LinkedList)object2).size() - 1);
                padesSignatureOptions.setSignaturePath((String)object5);
                object4 = (Object)padesSignatureOptions;
                PDDocument pDDocument2 = pDDocument;
                object6 = inputHandler;
                object3 = this;
                object2 = PadesUtils.retrieveNotEmptySignatures(pDDocument2);
                try {
                    int n = Integer.parseInt(object4.getSignaturePath());
                    if (n >= ((LinkedList)object2).size()) {
                        throw new CRLException("Pades Signature index invalid", 50040);
                    }
                    PadesSignatureInformation padesSignatureInformation = ((LinkedList)object2).get(n);
                    padesSignatureInformation.verify((InputHandler)object6);
                    object6 = object3.getLTResourceResolver((SignatureOptions)object4, object4.isIncludeCertificateChain());
                    if (object6 == null) {
                        throw new CRLException("Ubable to upgrade Bes Signature", 50040);
                    }
                    if (padesSignatureInformation.getSignatureTimeStampToken() == null && object4.getSignatureLevel().compareTo((Enum)SignatureLevel.BES) > 0) {
                        throw new CapiException("Unable Update to LT LTA signature without mark", 50040);
                    }
                    if (padesSignatureInformation.getSignatureTimeStampToken() != null || object4.isIncludeCertificateChain()) {
                        Object object7 = object3;
                        PDDocument pDDocument3 = pDDocument2;
                        pDDocument2 = object6;
                        object3 = padesSignatureInformation;
                        padesSignatureInformation = pDDocument3;
                        object6 = object7;
                        Object object8 = object3;
                        super.a((PDDocument)padesSignatureInformation, (PadesSignatureInformation)object8, ((PadesSignatureInformation)object8).getSignatureTimeStampToken(), (LTResourceResolver)pDDocument2);
                        object4.getSignatureLevel();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CapiException("Pades Signature index invalid", 50040, (Throwable)numberFormatException);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new CapiException("Unable To parse Cert", 50040, (Throwable)certificateEncodingException);
                }
                catch (IOException iOException) {
                    throw new CapiException("Unable To generate Dss", 50040, (Throwable)iOException);
                }
                catch (java.security.cert.CRLException cRLException) {
                    throw new CapiException("Unable To parse CRL", 50040, (Throwable)cRLException);
                }
                catch (CertificateException certificateException) {
                    throw new CapiException("Unable To parse Cert", 50040, (Throwable)certificateException);
                }
                padesSignatureOptions.setSignaturePath("");
            }
            pDDocument.saveIncremental(outputStream);
            outputStream.flush();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            try {
                throw new CapiException(invalidPasswordException.getMessage(), 50004, (Throwable)invalidPasswordException);
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    if (iOException.getCause() != null && iOException2.getCause() instanceof TSAException) {
                        throw (TSAException)iOException2.getCause();
                    }
                    if (iOException2.getCause() == null) throw new CapiException("Pades generation IOException: " + iOException2.getMessage(), 50040);
                    if (!(iOException2.getCause() instanceof CapiException)) throw new CapiException("Pades generation IOException: " + iOException2.getMessage(), 50040);
                    throw (CapiException)iOException2.getCause();
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new CapiException("Pades generation URISyntaxException: " + uRISyntaxException.getMessage(), 50040);
                }
                catch (KeyStoreException keyStoreException) {
                    throw new CapiException("Pades generation KeyStoreException: " + keyStoreException.getMessage(), 50040);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new CapiException("Pades generation NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage(), 50040);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    throw new CapiException("Pades generation UnrecoverableKeyException: " + unrecoverableKeyException.getMessage(), 50040);
                }
                catch (KeyManagementException keyManagementException) {
                    throw new CapiException("Pades generation KeyManagementException: " + keyManagementException.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(scratchFile);
                Util.closeQuietly(pDDocument);
                Util.closeQuietly(inputHandler);
                Util.closeQuietly(outputHandler);
                if (file != null && file.exists()) {
                    file.delete();
                }
                IOUtils.closeQuietly((Closeable)this.f);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)scratchFile);
        Util.closeQuietly((Closeable)pDDocument);
        Util.closeQuietly(inputHandler);
        Util.closeQuietly((Closeable)outputHandler);
        if (file != null && file.exists()) {
            file.delete();
        }
        IOUtils.closeQuietly((Closeable)this.f);
    }

    private void a(PDDocument pDDocument, PadesSignatureOptions padesSignatureOptions, Long object, List<PDSignatureField> object2, boolean bl) throws CapiException, IOException {
        COSString cOSString;
        COSDictionary cOSDictionary;
        PadesCertificationLevel padesCertificationLevel2;
        PDSignature pDSignature = PadesUtils.retrieveNotEmptySignatures(pDDocument);
        if ((pDSignature != null && pDSignature.isEmpty() || padesSignatureOptions.getApparence() != null) && pDDocument.getDocumentCatalog().getAcroForm() != null && pDDocument.getDocumentCatalog().getAcroForm().getNeedAppearances()) {
            pDDocument.getDocumentCatalog().getAcroForm().getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
        pDSignature = new PDSignature();
        pDSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        pDSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        Object object3 = this.retrieveCertCapi(padesSignatureOptions);
        if (object3 == null) {
            throw new CapiException("Internal error: unable to get signer X509 certificate", 1003);
        }
        String string = object3.getName();
        pDSignature.setName(string);
        if (string != null) {
            string = string.toUpperCase();
        }
        String string2 = null;
        Object object4 = object3.getSubjectDNAttribute("organization");
        if (object4 != null && ((String[])object4).length > 0) {
            string2 = object4[0].toUpperCase();
        }
        object4 = null;
        if ((object3 = object3.getSubjectDNAttribute("title")) != null && ((String[])object3).length > 0) {
            object4 = object3[0];
        }
        if (padesSignatureOptions.getReason() != null) {
            pDSignature.setReason(padesSignatureOptions.getReason());
        }
        if (padesSignatureOptions.getLocation() != null) {
            pDSignature.setLocation(padesSignatureOptions.getLocation());
        }
        if (padesSignatureOptions.getProfile() == PdfProfile.PADES) {
            pDSignature.setSubFilter(PDSignature.SUBFILTER_ETSI_CADES_DETACHED);
        }
        object3 = Calendar.getInstance();
        if (padesSignatureOptions.getSigningTime() != null) {
            ((Calendar)object3).setTime(padesSignatureOptions.getSigningTime());
        }
        pDSignature.setSignDate((Calendar)object3);
        if (padesSignatureOptions.getAdditionalDictionaryInfo() != null) {
            if (padesSignatureOptions.getAdditionalDictionaryInfo() instanceof GraphometricInfo) {
                object = new long[]{0L, (Long)object};
                padesCertificationLevel2 = padesSignatureOptions.getAdditionalDictionaryInfo().getDictionary((long[])object);
                pDSignature.getCOSObject().setItem("biometric_data", (COSBase)padesCertificationLevel2);
            } else if (padesSignatureOptions.getAdditionalDictionaryInfo() instanceof AutenticaBinding) {
                pDSignature.getCOSObject().setItem("binding_dictionary", (COSBase)padesSignatureOptions.getAdditionalDictionaryInfo().getDictionary());
            } else if (padesSignatureOptions.getAdditionalDictionaryInfo() instanceof FeaInfo) {
                object = new long[]{0L, (Long)object};
                padesCertificationLevel2 = padesSignatureOptions.getAdditionalDictionaryInfo().getDictionary((long[])object);
                pDSignature.getCOSObject().setItem("fea_dictionary", (COSBase)padesCertificationLevel2);
            } else {
                for (PadesCertificationLevel padesCertificationLevel2 : padesSignatureOptions.getAdditionalDictionaryInfo().getDictionary().keySet()) {
                    cOSDictionary = padesSignatureOptions.getAdditionalDictionaryInfo().getDictionary().getItem((COSName)padesCertificationLevel2);
                    pDSignature.getCOSObject().setItem((COSName)padesCertificationLevel2, (COSBase)cOSDictionary);
                }
            }
        }
        if (padesSignatureOptions.getAssignedCertificationLevel() != PadesCertificationLevel.NOT_CERTIFIED) {
            padesCertificationLevel2 = padesSignatureOptions.getAssignedCertificationLevel();
            object = pDSignature;
            cOSDictionary = new COSDictionary();
            cOSDictionary.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"SigRef"));
            cOSDictionary.setItem(COSName.getPDFName((String)"TransformMethod"), (COSBase)COSName.getPDFName((String)"DocMDP"));
            cOSString = new COSDictionary();
            cOSString.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"TransformParams"));
            cOSString.setItem(COSName.getPDFName((String)"V"), (COSBase)COSName.getPDFName((String)"1.2"));
            cOSString.setInt("P", padesCertificationLevel2.getLiv());
            cOSString.setDirect(true);
            cOSDictionary.setItem(COSName.getPDFName((String)"TransformParams"), (COSBase)cOSString);
            cOSDictionary.setDirect(true);
            padesCertificationLevel2 = new COSArray();
            padesCertificationLevel2.add((COSBase)cOSDictionary);
            padesCertificationLevel2.setDirect(true);
            object.getCOSObject().setItem(COSName.getPDFName((String)"Reference"), (COSBase)padesCertificationLevel2);
        }
        object = padesSignatureOptions.getApparence();
        if (padesSignatureOptions.getFieldName() != null) {
            for (int i = 0; i < object2.size(); ++i) {
                padesCertificationLevel2 = object2.get(i);
                cOSString = (COSString)padesCertificationLevel2.getCOSObject().getDictionaryObject(COSName.T);
                String string3 = "";
                if (cOSString != null && cOSString.getString() != null) {
                    string3 = cOSString.getString();
                }
                if (!padesSignatureOptions.getFieldName().equalsIgnoreCase(string3)) continue;
                a.debug("[addSigner] found emptySignatureFields to fill ");
                try {
                    padesCertificationLevel2.getCOSObject().setNeedToBeUpdated(true);
                    if (padesCertificationLevel2.getWidgets().size() > 0) {
                        if (((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getRectangle() != null) {
                            if (((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getRectangle().getWidth() != 0.0f || ((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getRectangle().getHeight() != 0.0f) {
                                padesCertificationLevel2.getCOSObject().setItem(COSName.V, (COSObjectable)pDSignature);
                                if (object == null) {
                                    object = new CapiPDFApparence();
                                    ((CapiPDFApparence)object).setFontSize(8);
                                }
                                ((CapiPDFApparence)object).setPosX(((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getRectangle().getLowerLeftX());
                                ((CapiPDFApparence)object).setPosY(((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getRectangle().getUpperRightY());
                                ((CapiPDFApparence)object).setWidth(((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getRectangle().getWidth());
                                ((CapiPDFApparence)object).setHeight(((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getRectangle().getHeight());
                                ((CapiPDFApparence)object).setPage(pDDocument.getPages().indexOf(((PDAnnotationWidget)padesCertificationLevel2.getWidgets().get(0)).getPage()) + 1);
                                padesSignatureOptions.setApparence((CapiPDFApparence)object);
                                break;
                            }
                            padesCertificationLevel2.setValue(pDSignature);
                            break;
                        }
                        padesCertificationLevel2.setValue(pDSignature);
                        break;
                    }
                    padesCertificationLevel2.setValue(pDSignature);
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    iOException.printStackTrace();
                }
                break;
            }
        }
        if (object != null) {
            if (Util.isNullOrEmpty((String)((CapiPDFApparence)object).getName())) {
                ((CapiPDFApparence)object).setName(string);
                ((CapiPDFApparence)object).setOrganization(string2);
                ((CapiPDFApparence)object).setTitle((String)object4);
            }
            if (((CapiPDFApparence)object).getPage() <= 0) {
                throw new CapiException("Invalid page index", 1006);
            }
            ((CapiPDFApparence)object).setFieldName(padesSignatureOptions.getFieldName());
            ((CapiPDFApparence)object).setPDFASignature(padesSignatureOptions.isPreservePdfA());
            ((CapiPDFApparence)object).setGray(bl);
            ((CapiPDFApparence)object).setSigningTimeCal((Calendar)object3);
            ((CapiPDFApparence)object).setLocation(padesSignatureOptions.getLocation());
            ((CapiPDFApparence)object).setReason(padesSignatureOptions.getReason());
            ((CapiPDFApparence)object).setPdDocument(pDDocument);
            padesSignatureOptions.setApparence((CapiPDFApparence)object);
        }
        this.f = new org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions();
        if (object != null) {
            a.debug("Adding visible Signature ....");
            try {
                this.f.setVisualSignature(PadesUtils.createVisualSignature((CapiPDFApparence)object));
                this.f.setPage(((CapiPDFApparence)object).getPage() - 1);
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
        if (pDDocument.getDocumentId() == null) {
            this.a(pDDocument, padesSignatureOptions);
        }
        pDDocument.addSignature(pDSignature, (SignatureInterface)new a(padesSignatureOptions), this.f);
    }

    private void a(PDDocument object, PadesSignatureOptions padesSignatureOptions) throws IOException {
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256", ProvUtils.bcProvider);
            byte[] byArray = new byte[4096];
            if (padesSignatureOptions.getSigningTime() == null) {
                padesSignatureOptions.setSigningTime(new Date());
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(padesSignatureOptions.getSigningTime().toString().getBytes());
            while ((n = byteArrayInputStream.read(byArray)) >= 0) {
                messageDigest.update(byArray, 0, n);
            }
            Object object2 = messageDigest.digest();
            PDDocument pDDocument = object;
            object = object2;
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            object2 = byteBuffer;
            byteBuffer.put((byte[])object, 0, 8);
            ((ByteBuffer)object2).flip();
            pDDocument.setDocumentId(Long.valueOf(((ByteBuffer)object2).getLong()));
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            return;
        }
    }

    protected void innerAddSign(PadesSignatureOptions padesSignatureOptions) throws CapiException {
        this.innerSign(padesSignatureOptions);
    }

    private static void a(PDDocument pDDocument) throws CapiException {
        if (!PadesUtils.isBlockedPdf(pDDocument)) {
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("Document certified and no changes allowed");
        }
        throw new CapiException("Document is certified and no changes are allowed.", 50026);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerUpdateSign(PadesSignatureOptions var1_1) throws CapiException {
        var2_3 = null;
        var3_4 = null;
        var4_5 = null;
        try {
            var5_6 = null;
            if (var1_1.getOwnerPassword() != null && !var1_1.getOwnerPassword().isEmpty()) {
                var5_6 = var1_1.getOwnerPassword().getBytes();
            }
            if ((var6_12 = (var4_5 = new SignedPDF(var1_1.getInput().getInputAsNewStream(), (byte[])var5_6)).getDocument()).getDocumentCatalog().getAcroForm() != null) {
                PadesSignatureGenerator.a(var6_12);
            }
            if ((var8_15 = var4_5.getSignature(var7_13 = Integer.parseInt(var1_1.getSignaturePath()))) == null) {
                throw new CRLException("Pades Signature index invalid", 50040);
            }
            if (!PadesSignatureGenerator.a((PadesSignatureInformation)var8_15)) ** GOTO lbl62
            var10_16 = var1_1;
            var9_17 = var6_12;
            var8_15 = this;
            var11_18 = new PDSignature();
            var11_18.setType(COSName.DOC_TIME_STAMP);
            var11_18.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            var11_18.setSubFilter(COSName.getPDFName((String)"ETSI.RFC3161"));
            var8_15.f = new org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions();
            if (var9_17.getDocumentId() == null) {
                super.a((PDDocument)var9_17, var10_16);
            }
            var9_17.addSignature(var11_18, (SignatureInterface)new b(var10_16.getTimeStampOptions()), var8_15.f);
            if (SignatureLevel.T.equals((Object)var1_1.getSignatureLevel())) {
                var6_12.saveIncremental(var1_1.getOutput().getAsOutputStream());
            }
            ** GOTO lbl-1000
        }
        catch (IOException v0) {
            try {
                var5_6 = v0;
                if (v0.getCause() != null && var5_6.getCause() instanceof TSAException) {
                    throw (TSAException)var5_6.getCause();
                }
                if (var5_6.getCause() != null && var5_6.getCause() instanceof CapiException) {
                    throw (CapiException)var5_6.getCause();
                }
                throw new CapiException("Pades generation Exception :" + var5_6.getMessage(), 50040);
                catch (URISyntaxException var5_7) {
                    throw new CapiException("Pades generation URISyntaxException: " + var5_7.getMessage(), 50040);
                }
                catch (KeyStoreException var5_8) {
                    throw new CapiException("Pades generation KeyStoreException: " + var5_8.getMessage(), 50040);
                }
                catch (NoSuchAlgorithmException var5_9) {
                    throw new CapiException("Pades generation NoSuchAlgorithmException: " + var5_9.getMessage(), 50040);
                }
                catch (UnrecoverableKeyException var5_10) {
                    throw new CapiException("Pades generation UnrecoverableKeyException: " + var5_10.getMessage(), 50040);
                }
                catch (KeyManagementException var5_11) {
                    throw new CapiException("Pades generation KeyManagementException: " + var5_11.getMessage(), 50040);
                }
            }
            catch (Throwable var1_2) {
                Util.closeQuietly(var2_3);
                Util.closeQuietly(var3_4);
                if (var4_5 != null) {
                    var4_5.close();
                }
                throw var1_2;
            }
        }
        Util.closeQuietly(null);
        Util.closeQuietly(null);
        var4_5.close();
        return;
lbl-1000:
        // 1 sources

        {
            block20: {
                var2_3 = DataHandlerBuilder.get().setTemp("PDF_UPDATE", ".tmp").buildOutput();
                ((TempFileOutputHandler)var2_3).setDeleteOnClose(false);
                var8_15 = ((TempFileOutputHandler)var2_3).getFile();
                var6_12.saveIncremental(var2_3.getAsOutputStream());
                var3_4 = DataHandlerBuilder.get().setFile((File)var8_15).buildInput();
                break block20;
lbl62:
                // 1 sources

                var3_4 = var1_1.getInput();
            }
            if (!SignatureLevel.T.equals((Object)var1_1.getSignatureLevel())) ** GOTO lbl-1000
        }
        Util.closeQuietly(var2_3);
        Util.closeQuietly((Closeable)var3_4);
        var4_5.close();
        return;
lbl-1000:
        // 1 sources

        {
            var4_5.close();
            var4_5 = new SignedPDF(var3_4.getInputAsNewStream(), (byte[])var5_6);
            var11_19 = var7_13;
            var10_16 = var1_1;
            var9_17 = var4_5;
            var8_15 = this;
            var1_1 = var9_17.getDocument();
            var5_6 = var9_17.getSignature(var11_19);
            if (var5_6 == null) {
                throw new CRLException("Pades Signature index invalid", 50040);
            }
            super.a((SignedPDF)var9_17, (PadesSignatureInformation)var5_6, var10_16);
            var5_6 = (COSDictionary)var1_1.getDocument().getTrailer().getDictionaryObject(COSName.ROOT);
            var6_12 = new COSDictionary();
            var7_14 = new COSDictionary();
            var6_12.setItem("ADBE", (COSBase)var7_14);
            var5_6.setItem("Extensions", (COSBase)var6_12);
            var7_14.setName("BaseVersion", "1.7");
            var7_14.setInt("ExtensionLevel", 5);
            var1_1.saveIncremental(var10_16.getOutput().getAsOutputStream());
        }
        Util.closeQuietly((Closeable)var2_3);
        Util.closeQuietly((Closeable)var3_4);
        var4_5.close();
    }

    private static boolean a(PadesSignatureInformation iterator) {
        Object object;
        try {
            object = ((PadesSignatureInformation)((Object)iterator)).getSignatureTimeStampToken();
            if (object != null) {
                return false;
            }
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        for (object = (Object)((PadesSignatureInformation)((Object)iterator)).getRevision(); object != null; object = ((RevisionInformation)object).getNextRevision()) {
            iterator = ((RevisionInformation)object).getSignatures();
            iterator = ((AbstractSequentialList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                PadesSignatureInformation padesSignatureInformation = (PadesSignatureInformation)iterator.next();
                if (!"ETSI.RFC3161".equals(padesSignatureInformation.getSubFilter())) continue;
                return false;
            }
        }
        return true;
    }

    private void a(SignedPDF signedPDF, PadesSignatureInformation padesSignatureInformation, PadesSignatureOptions padesSignatureOptions) throws CapiException {
        byte[] byArray = PadesSignatureGenerator.b(padesSignatureInformation);
        try {
            PadesSignatureOptions padesSignatureOptions2 = padesSignatureOptions;
            LTResourceResolver lTResourceResolver = this.getLTResourceResolver(padesSignatureOptions2, padesSignatureOptions2.isIncludeCertificateChain());
            if (lTResourceResolver == null) {
                throw new CRLException("Ubable to upgrade Bes Signature", 50040);
            }
            if (byArray == null) {
                throw new CapiException("Unable Update to LT LTA signature without mark", 50040);
            }
            this.a(signedPDF.getDocument(), padesSignatureInformation, byArray, lTResourceResolver);
            padesSignatureOptions.getSignatureLevel();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new CapiException("Pades Signature index invalid", 50040, (Throwable)numberFormatException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CapiException("Unable To parse Cert", 50040, (Throwable)certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new CapiException("Unable To generate Dss", 50040, (Throwable)iOException);
        }
        catch (java.security.cert.CRLException cRLException) {
            throw new CapiException("Unable To parse CRL", 50040, (Throwable)cRLException);
        }
        catch (CertificateException certificateException) {
            throw new CapiException("Unable To parse Cert", 50040, (Throwable)certificateException);
        }
    }

    private static void a(X509Certificate iterator, Date date, LinkedList<X509Certificate> linkedList, LTResourceResolver object2, PadesDssInfo padesDssInfo, String string) throws CapiException, CertificateException, IOException, java.security.cert.CRLException {
        date = object2.resolve((X509Certificate)((Object)iterator), date);
        if (!linkedList.contains(iterator)) {
            linkedList.add((X509Certificate)((Object)iterator));
        }
        for (Object object2 : date.getCerts()) {
            if (linkedList.contains(object2)) continue;
            linkedList.add((X509Certificate)object2);
        }
        for (Object object2 : date.getOcsps()) {
            padesDssInfo.addOcsp((OCSPResponse)object2, string);
        }
        for (Object object2 : date.getCrls()) {
            padesDssInfo.addCrl((CRL)object2, string);
        }
    }

    private static byte[] b(PadesSignatureInformation object) {
        try {
            Object object2 = ((PadesSignatureInformation)object).getSignatureTimeStampToken();
            if (object2 != null) {
                return object2;
            }
            for (object = ((PadesSignatureInformation)object).getRevision(); object != null; object = ((RevisionInformation)object).getNextRevision()) {
                LinkedList<PadesSignatureInformation> linkedList = ((RevisionInformation)object).getSignatures();
                object2 = linkedList;
                object2 = linkedList.iterator();
                while (object2.hasNext()) {
                    PadesSignatureInformation padesSignatureInformation = (PadesSignatureInformation)object2.next();
                    if (!"ETSI.RFC3161".equals(padesSignatureInformation.getSubFilter())) continue;
                    return padesSignatureInformation.getSignature();
                }
            }
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void a(PDDocument object4, PadesSignatureInformation padesSignatureInformation, byte[] object2, LTResourceResolver lTResourceResolver) throws CapiException, CertificateException, IOException, java.security.cert.CRLException {
        void var1_4;
        void var4_9;
        Certificate certificate;
        void var2_7;
        Object object = object4.getDocument().getTrailer();
        if (object == null) {
            throw new CapiException("no trailer", 50040);
        }
        if ((object = (COSDictionary)object.getDictionaryObject(COSName.ROOT)) == null) {
            throw new CapiException("no root", 50040);
        }
        PadesDssInfo padesDssInfo = var2_7.getPadesDssInfo();
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        if (padesDssInfo == null) {
            padesDssInfo = new COSDictionary();
            object.setItem("DSS", (COSBase)padesDssInfo);
            padesDssInfo = new PadesDssInfo((PDDocument)object4, (COSDictionary)padesDssInfo);
        }
        linkedList.addAll(padesDssInfo.getCerts());
        object.setNeedToBeUpdated(true);
        Object var1_2 = null;
        if (certificate != null) {
            certificate = new TimeStampToken((byte[])certificate);
            object = certificate.getTSACert();
            Date date = certificate.getDate();
            PadesSignatureGenerator.a(object.getInternalCert(), date, linkedList, (LTResourceResolver)var4_9, padesDssInfo, null);
        }
        certificate = var2_7.getSignerCertificate();
        PadesSignatureGenerator.a(certificate.getInternalCert(), (Date)var1_4, linkedList, (LTResourceResolver)var4_9, padesDssInfo, var2_7.getVri());
        for (X509Certificate x509Certificate : linkedList) {
            padesDssInfo.addCertificate(x509Certificate, null);
        }
    }

    private long a(RandomAccessRead randomAccessRead) {
        try {
            long l;
            long l2 = l = randomAccessRead.length();
            randomAccessRead.seek(l);
            byte[] byArray = null;
            int n = 0;
            while ((long)(n * 8192) < l) {
                int n2 = l - (long)(n * 8192) < 8192L ? (int)l - n * 8192 : 8192;
                randomAccessRead.rewind(n2);
                byte[] byArray2 = new byte[n2 + e];
                randomAccessRead.read(byArray2, 0, n2);
                if (byArray != null) {
                    System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
                }
                l2 += (long)e;
                int n3 = byArray2.length;
                while (n3 > 0) {
                    boolean bl;
                    boolean bl2;
                    boolean bl3;
                    int n4 = n3;
                    byte[] byArray3 = byArray2;
                    if (n4 < 5) {
                        bl3 = false;
                    } else {
                        byArray3 = Arrays.copyOfRange(byArray3, n4 - 5, n4);
                        bl3 = Arrays.equals(byArray3, b);
                    }
                    if (bl3) {
                        randomAccessRead.seek(0L);
                        return l2;
                    }
                    n4 = n3;
                    byArray3 = byArray2;
                    if (n4 < 6) {
                        bl2 = false;
                    } else {
                        byArray3 = Arrays.copyOfRange(byArray3, n4 - 6, n4);
                        bl2 = Arrays.equals(byArray3, c);
                    }
                    if (bl2) {
                        randomAccessRead.seek(0L);
                        return l2;
                    }
                    n4 = n3;
                    byArray3 = byArray2;
                    if (n4 < 7) {
                        bl = false;
                    } else {
                        byArray3 = Arrays.copyOfRange(byArray3, n4 - 7, n4);
                        bl = Arrays.equals(byArray3, d);
                    }
                    if (bl) {
                        randomAccessRead.seek(0L);
                        return l2;
                    }
                    --n3;
                    --l2;
                }
                byArray = Arrays.copyOfRange(byArray2, 0, e);
                randomAccessRead.rewind(n2);
                ++n;
            }
            return -1L;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            return -1L;
        }
    }

    protected void parameterValidation(PadesSignatureOptions padesSignatureOptions) throws CapiException {
        super.parameterValidation((SignatureOptions)padesSignatureOptions);
        if (padesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_224 || padesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_256 || padesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_384 || padesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_512) {
            throw new CapiException("Unsupported Digest Algorithm", 3011);
        }
    }
}

