/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.pades;

import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.steps.SignatureValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.steps.core.StepFormat;
import esecurity.validator.steps.core.StepSignatureIntegrityRelaxedCheck;
import esecurity.validator.steps.core.StepValidationProfile;
import esecurity.validator.steps.pades.PadesStepGraphometricData;
import esecurity.validator.steps.pades.PadesStepSignatureDPCM45Compliance;
import esecurity.validator.steps.pades.PadesStepSignatureEIDASCompliance;
import esecurity.validator.steps.pades.PadesStepSignatureETSICompliance;
import esecurity.validator.steps.pades.PadesStepSignatureIntegrity;
import esecurity.validator.steps.pades.PadesStepSignatureValidCertificationCheck;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=1)
@StepContext(formats={ValidationSignatureFormats.PADES})
public class PadesStepSignatureValidity
extends SignatureValidationStep {
    public PadesStepSignatureValidity() {
        this.subSteps.add(new StepFormat());
        this.subSteps.add(new PadesStepSignatureIntegrity());
        this.subSteps.add(new StepSignatureIntegrityRelaxedCheck());
        this.subSteps.add(new PadesStepSignatureValidCertificationCheck());
        this.subSteps.add(new PadesStepSignatureETSICompliance());
        this.subSteps.add(new PadesStepSignatureDPCM45Compliance());
        this.subSteps.add(new PadesStepSignatureEIDASCompliance());
        this.subSteps.add(new StepValidationProfile());
        this.subSteps.add(new PadesStepGraphometricData());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> messageLevel, ValidationContextParameters validationContextParameters) {
        if ((messageLevel = StepsUtils.retrieveWorstLevel(messageLevel)) == MessageLevel.ERROR) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0001_INVALID_SIGNATURE, new Object[0]);
        }
        if (validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignerCertificate().hasMessage(ValidatorMessageEnum.EC0003_CERT_NOT_RELIABLE)) {
            messageLevel = MessageLevel.WARNING;
        }
        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.IS0005_SIGN_VALID, new Object[0]);
    }
}

