/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.Cursor;
import esecurity.desktop.swt.Drawable;
import esecurity.desktop.swt.Image;
import esecurity.desktop.swt.KeyEvent;
import esecurity.desktop.swt.Listener;
import esecurity.desktop.swt.Point;
import esecurity.desktop.swt.Rectangle;
import esecurity.desktop.swt.SWTClass;
import esecurity.desktop.swt.SWTFacade;
import esecurity.desktop.swt.Widget;
import java.lang.reflect.Proxy;

abstract class Control
extends Widget
implements Drawable {
    private Object keyListener = null;
    private Object mouseListener = null;
    private Object mouseTrackListener = null;

    Control() {
    }

    public long getHandle() {
        try {
            return this.innerObject.getLong("handle");
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return 0L;
        }
    }

    public void setSize(int width, int height) {
        try {
            this.innerObject.callMethod("setSize", width, height);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setLocation(int x, int y) {
        try {
            this.innerObject.callMethod("setLocation", x, y);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public Point getLocation() {
        try {
            return new Point(this.innerObject.callMethod("getLocation", new Object[0]));
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    public void setCursor(Cursor cursor) {
        try {
            this.innerObject.callMethod("setCursor", cursor.innerObject.getObj());
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setBounds(Rectangle rect) {
        try {
            this.innerObject.callMethod("setBounds", rect.innerObject.getObj());
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        try {
            this.innerObject.callMethod("setBounds", x, y, width, height);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void moveBelow(Control control) {
        try {
            this.innerObject.callMethod("moveBelow", control.innerObject.getObj());
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void moveAbove(Control control) {
        try {
            if (control == null) {
                this.innerObject.callMethod("moveAbove", new Object[]{null});
            } else {
                this.innerObject.callMethod("moveAbove", control.innerObject.getObj());
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void redraw() {
        try {
            this.innerObject.callMethod("redraw", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setBackgroundImage(Image image) {
        try {
            this.innerObject.callMethod("setBackgroundImage", image.innerObject.getObj());
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setRedraw(boolean redraw) {
        try {
            this.innerObject.callMethod("setRedraw", redraw);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void addKeyListener(Listener keyReleasedListener, Listener keyPressedListener) {
        try {
            this.keyListener = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.KeyListener.getClss()}, (proxy, method, args) -> {
                try {
                    if (method.getName().equals("keyPressed")) {
                        if (keyPressedListener != null) {
                            keyPressedListener.handleEvent(new KeyEvent(args[0]));
                        }
                    } else if (keyReleasedListener != null) {
                        keyReleasedListener.handleEvent(new KeyEvent(args[0]));
                    }
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                return null;
            });
            this.innerObject.callMethod("addKeyListener", this.keyListener);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void addMouseListener(Listener mouseDoubleClickListener, Listener mouseDownListener, Listener mouseUpListener) {
        try {
            this.mouseListener = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.MouseListener.getClss()}, (proxy, method, args) -> {
                try {
                    switch (method.getName()) {
                        case "mouseDoubleClick": {
                            if (mouseDoubleClickListener == null) break;
                            mouseDoubleClickListener.handleEvent(new KeyEvent(args[0]));
                            break;
                        }
                        case "mouseDown": {
                            if (mouseDownListener == null) break;
                            mouseDownListener.handleEvent(new KeyEvent(args[0]));
                            break;
                        }
                        case "mouseUp": {
                            if (mouseUpListener == null) break;
                            mouseUpListener.handleEvent(new KeyEvent(args[0]));
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                return null;
            });
            this.innerObject.callMethod("addMouseListener", this.mouseListener);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void addMouseTrackListener(Listener mouseEnterListener, Listener mouseExitListener, Listener mouseHoverListener) {
        try {
            this.mouseTrackListener = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.MouseTrackListener.getClss()}, (proxy, method, args) -> {
                try {
                    switch (method.getName()) {
                        case "mouseEnter": {
                            if (mouseEnterListener == null) break;
                            mouseEnterListener.handleEvent(new KeyEvent(args[0]));
                            break;
                        }
                        case "mouseExit": {
                            if (mouseExitListener == null) break;
                            mouseExitListener.handleEvent(new KeyEvent(args[0]));
                            break;
                        }
                        case "mouseHover": {
                            if (mouseHoverListener == null) break;
                            mouseHoverListener.handleEvent(new KeyEvent(args[0]));
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                return null;
            });
            this.innerObject.callMethod("addMouseTrackListener", this.mouseTrackListener);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void removeMouseListener() {
        if (this.mouseListener != null) {
            try {
                this.innerObject.callMethod("removeMouseListener", this.mouseListener);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
            this.mouseListener = null;
        }
    }

    public void removeMouseTrackListener() {
        if (this.mouseTrackListener != null) {
            try {
                this.innerObject.callMethod("removeMouseTrackListener", this.mouseTrackListener);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
            this.mouseTrackListener = null;
        }
    }
}

