/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop;

import esecurity.desktop.Constants;
import esecurity.desktop.View;
import esecurity.desktop.swt.MessageBox;
import esecurity.desktop.swt.Shell;

public class Alert {
    private final View view;
    private final AlertType alertType;
    private String title;
    private String message;

    public Alert(View view, AlertType type) {
        this.view = view;
        this.alertType = type;
    }

    public Alert(View view, AlertType type, String title, String message) {
        this.view = view;
        this.alertType = type;
        this.title = title;
        this.message = message;
    }

    public ButtonType show() {
        if (!Constants.DEVELOP) {
            int byteMask = 0;
            switch (this.alertType) {
                case ERROR: {
                    byteMask |= 0x21;
                    break;
                }
                case WARNING: {
                    byteMask |= 0x28;
                    break;
                }
                case INFORMATION: {
                    byteMask |= 0x22;
                    break;
                }
                case QUESTION: {
                    byteMask |= 0xC4;
                }
            }
            MessageBox messageBox = new MessageBox((Shell)this.view.getWindow(), byteMask);
            messageBox.setText(this.title);
            messageBox.setMessage(this.message);
            int buttonID = messageBox.open();
            switch (buttonID) {
                case 32: {
                    return ButtonType.OK;
                }
                case 64: {
                    return ButtonType.YES;
                }
                case 128: {
                    return ButtonType.NO;
                }
                case 256: {
                    return ButtonType.CANCEL;
                }
            }
            return ButtonType.CANCEL;
        }
        return ButtonType.CANCEL;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static enum ButtonType {
        OK,
        YES,
        NO,
        CANCEL;

    }

    public static enum AlertType {
        ERROR,
        INFORMATION,
        QUESTION,
        WARNING;

    }
}

