/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.mc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.sqlite.SQLiteConfig;

public class SQLiteMCConfig
extends SQLiteConfig {
    private static final SQLiteConfig.Pragma[] CIPHER_PRAGMA_ORDER = new SQLiteConfig.Pragma[]{SQLiteConfig.Pragma.CIPHER, SQLiteConfig.Pragma.LEGACY, SQLiteConfig.Pragma.HMAC_CHECK, SQLiteConfig.Pragma.LEGACY_PAGE_SIZE, SQLiteConfig.Pragma.KDF_ITER, SQLiteConfig.Pragma.FAST_KDF_ITER, SQLiteConfig.Pragma.HMAC_USE, SQLiteConfig.Pragma.HMAC_PGNO, SQLiteConfig.Pragma.HMAC_SALT_MASK, SQLiteConfig.Pragma.KDF_ALGORITHM, SQLiteConfig.Pragma.HMAC_ALGORITHM, SQLiteConfig.Pragma.PLAINTEXT_HEADER_SIZE};

    public SQLiteMCConfig() {
    }

    public SQLiteMCConfig(Properties prop) {
        super(prop);
    }

    protected boolean isValid(Integer value, int min, int max) {
        return value >= min && value <= max;
    }

    protected SQLiteMCConfig setCipher(CipherAlgorithm cipherAlgorithm) {
        this.setPragma(SQLiteConfig.Pragma.CIPHER, cipherAlgorithm.getValue());
        return this;
    }

    public SQLiteMCConfig withKey(String key) {
        this.setPragma(SQLiteConfig.Pragma.KEY, key);
        this.setPragma(SQLiteConfig.Pragma.PASSWORD, key);
        return this;
    }

    protected SQLiteMCConfig setLegacy(int value) {
        this.setPragma(SQLiteConfig.Pragma.LEGACY, String.valueOf(value));
        return this;
    }

    protected SQLiteMCConfig setLegacyPageSize(int value) {
        this.setPragma(SQLiteConfig.Pragma.LEGACY_PAGE_SIZE, String.valueOf(value));
        return this;
    }

    protected SQLiteMCConfig setKdfIter(int value) {
        this.setPragma(SQLiteConfig.Pragma.KDF_ITER, String.valueOf(value));
        return this;
    }

    protected SQLiteMCConfig setFastKdfIter(int value) {
        this.setPragma(SQLiteConfig.Pragma.FAST_KDF_ITER, String.valueOf(value));
        return this;
    }

    protected SQLiteMCConfig setHmacUse(boolean value) {
        this.setPragma(SQLiteConfig.Pragma.HMAC_USE, String.valueOf(value ? 1 : 0));
        return this;
    }

    protected SQLiteMCConfig setHmacPgno(HmacPgno value) {
        this.setPragma(SQLiteConfig.Pragma.HMAC_PGNO, String.valueOf(value.ordinal()));
        return this;
    }

    protected SQLiteMCConfig setHmacSaltMask(int value) {
        this.setPragma(SQLiteConfig.Pragma.HMAC_SALT_MASK, String.valueOf(value));
        return this;
    }

    protected SQLiteMCConfig setKdfAlgorithm(KdfAlgorithm value) {
        this.setPragma(SQLiteConfig.Pragma.KDF_ALGORITHM, String.valueOf(value.ordinal()));
        return this;
    }

    protected SQLiteMCConfig setHmacAlgorithm(HmacAlgorithm value) {
        this.setPragma(SQLiteConfig.Pragma.HMAC_ALGORITHM, String.valueOf(value.ordinal()));
        return this;
    }

    protected SQLiteMCConfig setPlaintextHeaderSize(int value) {
        this.setPragma(SQLiteConfig.Pragma.PLAINTEXT_HEADER_SIZE, String.valueOf(value));
        return this;
    }

    public SQLiteMCConfig useSQLInterface(boolean sqlInterface) {
        this.setPragma(SQLiteConfig.Pragma.MC_USE_SQL_INTERFACE, sqlInterface ? "true" : "false");
        return this;
    }

    public void applyCipherParameters(Connection conn, Statement stat) throws SQLException {
        this.applyCipherParametersByNames(CIPHER_PRAGMA_ORDER, conn, stat);
    }

    protected void applyCipherParametersByNames(SQLiteConfig.Pragma[] pragmas, Connection conn, Statement statement) throws SQLException {
        Properties p = super.toProperties();
        boolean useSQLInterface = Boolean.parseBoolean(p.getProperty(SQLiteConfig.Pragma.MC_USE_SQL_INTERFACE.getPragmaName(), "false"));
        String cipherProperty = p.getProperty(SQLiteConfig.Pragma.CIPHER.getPragmaName(), null);
        if (cipherProperty == null) {
            throw new SQLException("Cipher name could not be empty at this stage");
        }
        for (SQLiteConfig.Pragma pragma : pragmas) {
            String sql;
            String property = p.getProperty(pragma.getPragmaName(), null);
            if (property == null) continue;
            if (!useSQLInterface) {
                statement.execute(String.format("PRAGMA %s = %s", pragma.getPragmaName(), property));
                continue;
            }
            if (pragma.equals((Object)SQLiteConfig.Pragma.CIPHER)) {
                sql = String.format("SELECT sqlite3mc_config('default:%s', '%s');", pragma.getPragmaName(), cipherProperty);
                conn.createStatement().execute(sql);
                continue;
            }
            sql = String.format("SELECT sqlite3mc_config('%s', 'default:%s', %s);", cipherProperty, pragma.getPragmaName(), property);
            conn.createStatement().execute(sql);
        }
    }

    public static enum CipherAlgorithm {
        SQL_CIPHER("sqlcipher"),
        RC4("rc4"),
        CHACHA20("chacha20"),
        WX_AES128("aes128cbc"),
        WX_AES256("aes256cbc");

        private final String cipherName;

        private CipherAlgorithm(String name) {
            this.cipherName = name;
        }

        public String getValue() {
            return this.cipherName;
        }
    }

    public static enum HmacPgno {
        NATIVE,
        LITTLE_ENDIAN,
        BIG_ENDIAN;

    }

    public static enum KdfAlgorithm {
        SHA1,
        SHA256,
        SHA512;

    }

    public static enum HmacAlgorithm {
        SHA1,
        SHA256,
        SHA512;

    }

    public static class Builder
    extends SQLiteMCConfig {
        @Override
        public Builder setPlaintextHeaderSize(int value) {
            return (Builder)super.setPlaintextHeaderSize(value);
        }

        @Override
        public Builder setLegacy(int value) {
            return (Builder)super.setLegacy(value);
        }

        @Override
        public Builder setKdfIter(int value) {
            return (Builder)super.setKdfIter(value);
        }

        @Override
        public Builder setKdfAlgorithm(KdfAlgorithm value) {
            return (Builder)super.setKdfAlgorithm(value);
        }

        @Override
        public Builder setHmacUse(boolean value) {
            return (Builder)super.setHmacUse(value);
        }

        @Override
        public Builder setHmacSaltMask(int value) {
            return (Builder)super.setHmacSaltMask(value);
        }

        @Override
        public Builder setHmacPgno(HmacPgno value) {
            return (Builder)super.setHmacPgno(value);
        }

        @Override
        public Builder setHmacAlgorithm(HmacAlgorithm value) {
            return (Builder)super.setHmacAlgorithm(value);
        }

        @Override
        public Builder setFastKdfIter(int value) {
            return (Builder)super.setFastKdfIter(value);
        }

        @Override
        public Builder setLegacyPageSize(int value) {
            return (Builder)super.setLegacyPageSize(value);
        }

        @Override
        public Builder setCipher(CipherAlgorithm cipherAlgorithm) {
            return (Builder)super.setCipher(cipherAlgorithm);
        }

        public SQLiteMCConfig toSQLiteMCConfig() {
            return this;
        }
    }
}

