window.addEventListener("load", function (e) {
    $controller$.viewOnLoad();
});

function mainEvent(e) {
    var caller = this;//e.target || e.srcElement || e.currentTarget;
    if (caller != undefined && caller != null) {
        if (caller.id != null && caller.id != undefined) {

            var event = {
                "type": e.type,
                "callerId": caller.id,
                "offsetX": e.offsetX,
                "offsetY": e.offsetY,
                "pageX": e.pageX,
                "pageY": e.pageY,
                "clientX": e.clientX,
                "clientY": e.clientY,
                "screenX": e.screenX,
                "screenY": e.screenY,
                "movementX": e.movementX,
                "movementY": e.movementY,
                "keyCode": e.keyCode
            }
            var jsonEvent = JSON.stringify(event);
            $controller$.eventDispacher(jsonEvent);
        }
    }
    if (e.type === "contextmenu" || e.type === "drag" || e.type === "zoom")
    {
        e.preventDefault();
    }
    e.stopPropagation();

    $(window).bind('mousewheel DOMMouseScroll', function (event) {
        if (event.ctrlKey == true) {
            event.preventDefault();
        }
    });
}

function preventDef(e) {
    e.preventDefault();
    e.stopPropagation();
    return false;
}

/**
 * Call BaseController.info for logging at info level
 * 
 * @param {String} info the string sent to logger 
 */
function info(info) {
    $controller$.info(info);
}

/**
 * Call BaseController.error for logging at error level
 * 
 * @param {String} error the string sent to logger 
 */
function error(error) {
    $controller$.error(error);
}

function removeClass(elementId, className) {
    $("#" + elementId).removeClass(className);
}

function addClass(elementId, className) {
    $("#" + elementId).addClass(className);
}

function toggleClass(elementId, className) {
    $("#" + elementId).toggleClass(className);
}

function hasClass(elementId, className) {
    return $("#" + elementId).hasClass(className);
}

function remove(elementId) {
    $("#" + elementId).remove();
}

function clearSelect(elementId) {
    $("#" + elementId).parent().find('option').remove();
}

function getBoundingClientRect(elementId) {
    var rect = $("#" + elementId)[0].getBoundingClientRect();
    return rect.top + ";" + rect.right + ";" + rect.bottom + ";" + rect.left;
}

/**
 * Test is an element is contained in another
 * 
 * @param {String} elementId id of the element to check if it is contained
 * @param {String} containerId id of the element to check if it is the container
 * @returns {Boolean} true if the element with id elementId is contained in the element with id containerId
 */
function isContained(elementId, containerId) {
    // Distance from parent top
    var elementTop = $("#" + elementId).offset().top;
    var elementBottom = elementTop + $("#" + elementId).height();

    var containerTop = 0;
    var containerBottom = $("#" + containerId).height();

    return elementBottom > containerTop && elementTop < containerBottom;
}

function insertAfter(toMove, afterMe) {
    $("#" + toMove).insertAfter($("#" + afterMe));
}

function insertBefore(toMove, beforeMe) {
    $("#" + toMove).insertBefore($("#" + beforeMe));
}

function getScrollTop(elementId) {
    return $("#" + elementId).scrollTop();
}