/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class FileAppender {
    protected String appenderPath;
    protected int nReferences;
    protected boolean bFullLockAppender;

    public FileAppender(String logFilePath) throws FileNotFoundException, IOException {
        this.appenderPath = logFilePath;
        this.nReferences = 1;
        this.bFullLockAppender = false;
    }

    public abstract void release() throws IOException;

    public synchronized void writeTo(String message, Charset charset) throws IOException {
        if (this.nReferences == 0) {
            return;
        }
        if (this.bFullLockAppender) {
            this.lock();
        }
        this.writeData(message.getBytes(charset));
        if (this.bFullLockAppender) {
            this.unlock();
        }
    }

    abstract void writeData(byte[] var1) throws IOException;

    public synchronized void addReference() {
        ++this.nReferences;
    }

    public int getReferences() {
        return this.nReferences;
    }

    protected abstract void lock() throws IOException;

    protected abstract void unlock() throws IOException;

    public abstract boolean isLocked();

    public boolean isFullLockAppender() {
        return this.bFullLockAppender;
    }

    public void setFullLockAppender(boolean bLockAppender) {
        this.bFullLockAppender = bLockAppender;
    }

    public synchronized void backup(String backupFilePath, String backupFileExtension, boolean compress) throws IOException {
        this.backup(backupFilePath, backupFileExtension, -1, compress);
    }

    public abstract void backup(String var1, String var2, int var3, boolean var4) throws IOException;
}

