/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.loader;

import com.sun.jna.Pointer;
import esecurity.crypto.gui.pdf.bean.PdfAnnotation;
import esecurity.crypto.gui.pdf.loader.PdfPagesLoader$PdfLoaderServer;
import esecurity.crypto.gui.pdf.loader.mmmvqbvp;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfPagesLoader {
    private static final EllipsLogger logger = PdfPagesLoader.og("16qtbuo", Constants.CAPI_LOGGER_NAME);
    private static final Object CLOSE_LOCK = new Object();
    private static ExecutorService EXECUTOR_SERVICE;
    private static Future<PdfPagesLoader> pdfParserLoader;
    private static PDFRenderer pdfRenderer;
    static Pointer pdfDocument;
    private static PDDocument pdd;
    private static int pages;
    private static Dimension[] pagesDimensions;
    private static boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncInitialize(File pdfFile) {
        closed = false;
        EXECUTOR_SERVICE = PdfPagesLoader.og("-11uujvg");
        Object object = CLOSE_LOCK;
        synchronized (object) {
            pdfParserLoader = EXECUTOR_SERVICE.submit(() -> {
                try {
                    return new PdfPagesLoader(pdfFile);
                }
                catch (IOException ex) {
                    PdfPagesLoader.og("10upbus", logger, PdfPagesLoader.og("-1n5ek29", ex), (Object)ex);
                    return null;
                }
            });
        }
    }

    private PdfPagesLoader(File pdfFile) throws IOException {
        Object convertedTmp = pdfFile;
        if (PdfPagesLoader.og("83c0h", pdfFile) != false) {
            convertedTmp = PdfPagesLoader.og("vtpc0e", pdfFile);
        }
        ScratchFile SCRATCH_FILE_TEMP = new ScratchFile((MemoryUsageSetting)PdfPagesLoader.og("asbc0f", 10000000L));
        Object pdfFileBuffer = PdfPagesLoader.og("-1n9kk2c", SCRATCH_FILE_TEMP, new FileInputStream((File)convertedTmp));
        PDFParser parser = new PDFParser((RandomAccessRead)pdfFileBuffer, SCRATCH_FILE_TEMP);
        PdfPagesLoader.og("-1rsik2b", parser);
        pdd = PdfPagesLoader.og("-1942k2e", parser);
        pdfRenderer = new PDFRenderer(pdd);
        pages = (int)PdfPagesLoader.og("-18qok2d", pdd);
        pagesDimensions = new Dimension[pages];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BufferedImage loadPage(int page, float zoom) throws IOException {
        if (closed) {
            return null;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        Object object = CLOSE_LOCK;
        synchronized (object) {
            Object image = null;
            try {
                image = PdfPagesLoader.og("-g3ek28", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
                if (pagesDimensions[page] == null) {
                    PdfPagesLoader.pagesDimensions[page] = new Dimension((int)((float)PdfPagesLoader.og("14t1btp", image) / zoom), (int)((float)PdfPagesLoader.og("1e8jbtm", image) / zoom));
                }
            }
            catch (IOException ex) {
                PdfPagesLoader.og("10upbus", logger, PdfPagesLoader.og("-1n5ek29", ex), (Object)ex);
            }
            return image;
        }
    }

    public static int getPageCount() throws IOException {
        if (closed) {
            return 0;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        return pages;
    }

    public static boolean isLoaded() {
        return pdfParserLoader.isDone();
    }

    public static synchronized Dimension getPageDimension(int page, float zoom) throws IOException {
        if (closed) {
            return new Dimension();
        }
        PdfPagesLoader.getLoaderOrThrowException();
        if (pagesDimensions[page] != null) {
            return pagesDimensions[page];
        }
        try {
            Object image = PdfPagesLoader.og("-g3ek28", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
            PdfPagesLoader.pagesDimensions[page] = new Dimension((int)PdfPagesLoader.og("14t1btp", image), (int)PdfPagesLoader.og("1e8jbtm", image));
            return pagesDimensions[page];
        }
        catch (IOException ex) {
            PdfPagesLoader.og("10upbus", logger, PdfPagesLoader.og("-1n5ek29", ex), (Object)ex);
            return new Dimension(0, 0);
        }
    }

    public static List<PdfAnnotation> getPageAnnotations(int page) throws IOException {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        PdfPagesLoader.getLoaderOrThrowException();
        try {
            Object annotationList = PdfPagesLoader.og("1kq1btt", PdfPagesLoader.og("-1q88k24", pdd, page));
            Iterator iterator = annotationList.iterator();
            while (iterator.hasNext()) {
                Object annotationType;
                PDAnnotation annotation = (PDAnnotation)iterator.next();
                Object annotationDict = PdfPagesLoader.og("-1u3qk26", annotation);
                if (PdfPagesLoader.og("2slbtr", annotationDict, COSName.V) != null || (annotationType = PdfPagesLoader.og("-19u8k30", annotationDict, COSName.FT)) == null) continue;
                char[] cArray = "\u42df\u3d6a\u2765\u7edb".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0x3C98);
                if (PdfPagesLoader.og("-1p0ak32", PdfPagesLoader$PdfLoaderServer.q(cArray, (short)15562, (short)3, (byte)3), PdfPagesLoader.og("-1dd4k2v", annotationType)) == false) continue;
                Object rect = PdfPagesLoader.og("gqpbsv", annotationDict, COSName.RECT);
                Object annotationName = PdfPagesLoader.og("15c1c44", annotationDict, COSName.T);
                Object llx = PdfPagesLoader.og("-eocjrr", rect, 0);
                Object lly = PdfPagesLoader.og("-eocjrr", rect, 1);
                Object urx = PdfPagesLoader.og("-eocjrr", rect, 2);
                Object ury = PdfPagesLoader.og("-eocjrr", rect, 3);
                annotations.add(new PdfAnnotation(new Rectangle((int)llx, (int)ury, (int)(urx - llx), (int)(ury - lly)), (String)annotationName));
            }
        }
        catch (IOException ex) {
            PdfPagesLoader.og("10upbus", logger, PdfPagesLoader.og("-1n5ek29", ex), (Object)ex);
        }
        return annotations;
    }

    public static PDDocument getPDDocument() throws IOException {
        PdfPagesLoader.getLoaderOrThrowException();
        return pdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDocument() {
        Object object = CLOSE_LOCK;
        synchronized (object) {
            closed = true;
            try {
                PdfPagesLoader.og("4ijc42", pdd);
            }
            catch (IOException ex) {
                PdfPagesLoader.og("10upbus", logger, PdfPagesLoader.og("-1n5ek29", ex), (Object)ex);
            }
        }
    }

    public static void shutDown() {
        EXECUTOR_SERVICE.shutdownNow();
        if (!closed) {
            PdfPagesLoader.closeDocument();
        }
    }

    private static PdfPagesLoader getLoaderOrThrowException() throws IOException {
        PdfPagesLoader loader = null;
        try {
            loader = pdfParserLoader.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            PdfPagesLoader.og("10upbus", logger, PdfPagesLoader.og("-19cck19", ex), (Object)ex);
        }
        if (loader == null) {
            char[] cArray = "\u9a8a\ud3b4\ua637\u4ca0\uc37a\u9fdf\u49e0\u7699\ub7de\uc4dd\ucad0\u556a\uc110\ub4fb\u8ce6\ubc71\uac72\u8a2e\ued6f\ue05d\u9b5e\u8038\uafa9\u57b7\ue9f3\u3f17".toCharArray();
            cArray[19] = (char)(cArray[19] ^ 0x3C2A);
            throw new IOException(PdfPagesLoader$PdfLoaderServer.q(cArray, (short)25971, (short)1, (byte)3));
        }
        return loader;
    }

    static {
        pages = 0;
        closed = false;
    }

    private static Object og(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(mmmvqbvp.X(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

