/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.EncryptedEnvelope;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.cms.ContentInfoParser;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class StreamEncryptedEnvelope {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int DES_EDE3_CBC = 0;
    public static final int RC2_CBC = 1;
    public static final int AES256_CBC = 2;
    public static final int CAMELLIA256_CBC = 3;
    private int b = -1;
    private InputStream c = null;
    protected CMSEnvelopedDataParser envelopedData = null;
    private CMSEnvelopedDataStreamGenerator d = null;
    protected ASN1ObjectIdentifier contentEA = CMSAlgorithm.DES_EDE3_CBC;

    public StreamEncryptedEnvelope() throws CapiException {
        this.b = 0;
        this.contentEA = CMSAlgorithm.DES_EDE3_CBC;
        a.debug("data encryption algorithm set to DES_EDE3_CBC");
        this.envelopedData = null;
    }

    public StreamEncryptedEnvelope(int n) throws CapiException {
        this.b = 0;
        if (n == 3) {
            this.contentEA = CMSAlgorithm.CAMELLIA256_CBC;
            a.debug("Content encryption algorithm set to CAMELLIA256_CBC");
            this.envelopedData = null;
            return;
        }
        if (n == 2) {
            this.contentEA = CMSAlgorithm.AES256_CBC;
            a.debug("Content encryption algorithm set to AES256_CBC");
            this.envelopedData = null;
            return;
        }
        if (n == 1) {
            this.contentEA = CMSAlgorithm.RC2_CBC;
            a.debug("Content encryption algorithm set to RC2_CBC");
            this.envelopedData = null;
            return;
        }
        if (n == 0) {
            this.contentEA = CMSAlgorithm.DES_EDE3_CBC;
            a.debug("Content encryption algorithm set to DES_EDE3_CBC");
            this.envelopedData = null;
            return;
        }
        throw new CapiException("Supplied mode is invalid", 1002);
    }

    public void addRecipient(byte[] object) throws CapiException {
        object = new Certificate(object).getInternalCert();
        StreamEncryptedEnvelope streamEncryptedEnvelope = this;
        Object object2 = object;
        object = streamEncryptedEnvelope;
        streamEncryptedEnvelope.a((X509Certificate)object2, null);
    }

    public void addRecipient(byte[] object, boolean bl) throws CapiException {
        Certificate certificate = new Certificate(object);
        object = certificate;
        X509Certificate x509Certificate = certificate.getInternalCert();
        if (x509Certificate == null) {
            throw new CapiException("No certificate", 30005);
        }
        if (!bl) {
            StreamEncryptedEnvelope streamEncryptedEnvelope = this;
            X509Certificate x509Certificate2 = x509Certificate;
            object = streamEncryptedEnvelope;
            streamEncryptedEnvelope.a(x509Certificate2, null);
            return;
        }
        if ((object = object.getSubjectKeyIdentifier()) != null && ((byte[])object).length > 0) {
            this.a(x509Certificate, (byte[])object);
            return;
        }
        throw new CapiException("Missing Extension Subject Key Identifier", 30006);
    }

    public void addRecipientFromToken(String object) throws CapiException {
        TokenSpi tokenSpi = ProvUtils.retrieveTokenByAlias((String)object);
        try {
            a.debug("[addRecipientFromToken] getting credential...");
            object = Util.getBytes((String)tokenSpi.getCert((String)object));
            a.debug("[addRecipientFromToken] getting credential ok");
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        this.addRecipient((byte[])object);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getEncoded(InputStream inputStream, OutputStream outputStream, boolean bl) throws CapiException {
        OutputStream outputStream2 = null;
        try {
            OutputStream outputStream3;
            if (inputStream == null) throw new CapiException("Null data", 1001);
            if (outputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.b < 2) {
                throw new CapiException("Recipient(s) must be set before", 51001);
            }
            if (this.b == 4) throw new CapiException("Cannot ciphered", 51002);
            if (this.b == 3) {
                throw new CapiException("Cannot ciphered", 51002);
            }
            a.debug("Creating envelopedData ...");
            if (this.envelopedData != null) {
                throw new CapiException("Why envelopedData not null ?", 51002);
            }
            if (this.d == null) {
                throw new CapiException("Factory is null ?", 51002);
            }
            Object object = new JceCMSContentEncryptorBuilder(this.contentEA).setProvider(ProvUtils.bcProvider);
            if (bl) {
                outputStream2 = new Base64OutputStream(outputStream, true);
                outputStream3 = this.d.open(outputStream2, object.build());
            } else {
                outputStream3 = this.d.open(outputStream, object.build());
            }
            object = new byte[4096];
            int n = inputStream.read((byte[])object);
            while (n > 0) {
                outputStream3.write((byte[])object, 0, n);
                n = inputStream.read((byte[])object);
            }
            outputStream3.close();
            this.b = 3;
            a.debug("Envelope saved.");
        }
        catch (Exception exception) {
            try {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Error encoding envelope", 50022);
                catch (CapiError capiError) {
                    a.debug(capiError.getMessage(), (Throwable)capiError);
                    throw capiError.getCapiException();
                }
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream2 != null) {
                        outputStream2.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception2) {}
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception3) {}
                throw throwable;
            }
        }
        try {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException iOException) {}
        try {
            outputStream.close();
        }
        catch (Exception exception) {}
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void getEncoded(InputStream inputStream, OutputStream outputStream) throws CapiException {
        this.getEncoded(inputStream, outputStream, false);
    }

    public StreamEncryptedEnvelope(InputStream inputStream) throws CapiException {
        try {
            if (inputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            InputStream inputStream2 = inputStream;
            StreamEncryptedEnvelope streamEncryptedEnvelope = this;
            try {
                inputStream2 = new BufferedInputStream(inputStream2);
                streamEncryptedEnvelope.envelopedData = new CMSEnvelopedDataParser(inputStream2);
                a.debug("Content encryption algorithm: " + streamEncryptedEnvelope.envelopedData.getEncryptionAlgOID() + " (" + EncryptedEnvelope.getContentEncryptionAlgName(streamEncryptedEnvelope.envelopedData.getEncryptionAlgOID()) + ")");
                a.debug("parsed enveloped data ok");
            }
            catch (CMSException cMSException) {
                try {
                    inputStream2.close();
                }
                catch (Exception exception) {}
                a.debug(cMSException.getMessage(), (Throwable)cMSException);
                throw new CapiException("Envelope format unknown or not implemented", 50023);
            }
            catch (IOException iOException) {
                try {
                    inputStream2.close();
                }
                catch (Exception exception) {}
                a.debug(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Envelope format unknown or not implemented", 50023);
            }
            catch (RuntimeException runtimeException) {
                try {
                    inputStream2.close();
                }
                catch (Exception exception) {}
                a.debug(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new CapiException("RuntimeException", 50050);
            }
            catch (Exception exception) {
                try {
                    inputStream2.close();
                }
                catch (Exception exception2) {}
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
            a.debug("parsed ok");
            this.b = 4;
            this.c = inputStream;
            return;
        }
        finally {
            a.debug("der_encoded close after decrypt method");
        }
    }

    public String getEncryptionAlgorithm() {
        if (this.b == 0 || this.b == 2) {
            return this.contentEA.getId();
        }
        return this.envelopedData.getEncryptionAlgOID();
    }

    public String[] listRecipients(String string) throws CapiException {
        if (this.envelopedData == null) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        try {
            a.debug("getting recipients...");
            Object object = this.envelopedData.getRecipientInfos();
            object = object.getRecipients();
            object = new Vector(object);
            a.debug("recipients are " + ((Vector)object).size());
            String[] stringArray = new String[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                RecipientInformation recipientInformation = (RecipientInformation)((Vector)object).elementAt(i);
                recipientInformation = (KeyTransRecipientId)recipientInformation.getRID();
                stringArray[i] = recipientInformation.getSerialNumber().toString() + string + recipientInformation.getIssuer().toString();
            }
            return stringArray;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    public Map<String, X500Name> listRecipients() throws CapiException {
        if (this.envelopedData == null) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        try {
            a.debug("getting recipients...");
            Object object = this.envelopedData.getRecipientInfos();
            object = object.getRecipients();
            object = new Vector(object);
            a.debug("recipients are " + ((Vector)object).size());
            HashMap<String, X500Name> hashMap = new HashMap<String, X500Name>();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                RecipientInformation recipientInformation = (RecipientInformation)((Vector)object).elementAt(i);
                recipientInformation = (KeyTransRecipientId)recipientInformation.getRID();
                hashMap.put(recipientInformation.getSerialNumber().toString(), recipientInformation.getIssuer());
            }
            return hashMap;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    public void decrypt(String object, OutputStream outputStream) throws CapiException {
        try {
            if (outputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.b < 3) {
                throw new CapiException("Data must be encrypted before", 51001);
            }
            TokenSpi tokenSpi = ProvUtils.retrieveTokenByAlias((String)object);
            try {
                a.debug("[decrypt] getting credential from token...");
                Object object2 = tokenSpi.getCert((String)object);
                if (object2 == null) {
                    throw new CapiException("alias not found", 51010);
                }
                Object object3 = new Certificate(Util.getBytes((String)object2));
                object2 = object3.getInternalCert();
                a.debug("...cert ok");
                object2 = new KeyTransRecipientId(JcaX500NameUtil.getIssuer((X509Certificate)object2), ((X509Certificate)object2).getSerialNumber());
                RecipientInformationStore recipientInformationStore = this.envelopedData.getRecipientInfos();
                object2 = (KeyTransRecipientInformation)recipientInformationStore.get((RecipientId)object2);
                if (object2 != null) {
                    a.debug("[decrypt] recipient Issuer and Serial number match token alias certificate");
                } else {
                    a.debug("[decrypt] try using subject key identifier...");
                    byte[] byArray = object3.getSubjectKeyIdentifier();
                    object3 = byArray;
                    if (byArray == null || ((Certificate)object3).length == 0) {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                    object2 = new KeyTransRecipientId((byte[])object3);
                    if ((object2 = (KeyTransRecipientInformation)recipientInformationStore.get((RecipientId)object2)) != null) {
                        a.debug("[decrypt] recipient SubjectKeyIdentifier match token alias certificate");
                    } else {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                }
                object = tokenSpi.getPrivateKey((String)object);
                object3 = new JceKeyTransEnvelopedRecipient((PrivateKey)object);
                object3.setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)object));
                object3.setContentProvider(ProvUtils.bcProvider);
                object = object2.getContentStream((Recipient)object3);
                object = object.getContentStream();
                a.debug("decrypting data...");
                Streams.pipeAll((InputStream)object, (OutputStream)outputStream);
                a.debug("[decrypt] done.");
            }
            catch (CapiException capiException) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
            }
            catch (IOException iOException) {
                a.debug(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("IOException", 50050);
            }
            catch (CMSException cMSException) {
                a.debug(cMSException.getMessage(), (Throwable)cMSException);
                throw new CapiException("CMSException", 50050);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
            catch (CapiError capiError) {
                a.debug(capiError.getMessage(), (Throwable)capiError);
                throw capiError.getCapiException();
            }
        }
        catch (Throwable throwable) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            a.debug("closing der_encoded stream ...");
            try {
                this.c.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
        a.debug("closing der_encoded stream ...");
        try {
            this.c.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean decrypt(TokenSpi object, String string, OutputStream outputStream) throws CapiException {
        try {
            if (outputStream == null || object == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.b < 3) {
                throw new CapiException("Data must be encrypted before", 51001);
            }
            try {
                a.debug("[decrypt] getting credential from token...");
                Object object2 = object.getCert(string);
                if (object2 == null) {
                    throw new CapiException("alias not found", 51010);
                }
                Object object3 = new Certificate(Util.getBytes((String)object2));
                object2 = object3.getInternalCert();
                a.debug("...cert ok");
                object2 = new KeyTransRecipientId(JcaX500NameUtil.getIssuer((X509Certificate)object2), ((X509Certificate)object2).getSerialNumber());
                RecipientInformationStore recipientInformationStore = this.envelopedData.getRecipientInfos();
                object2 = (KeyTransRecipientInformation)recipientInformationStore.get((RecipientId)object2);
                if (object2 != null) {
                    a.debug("[decrypt] recipient Issuer and Serial number match token alias certificate");
                } else {
                    a.debug("[decrypt] try using subject key identifier...");
                    byte[] byArray = object3.getSubjectKeyIdentifier();
                    object3 = byArray;
                    if (byArray == null || ((Certificate)object3).length == 0) {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                    object2 = new KeyTransRecipientId((byte[])object3);
                    if ((object2 = (KeyTransRecipientInformation)recipientInformationStore.get((RecipientId)object2)) != null) {
                        a.debug("[decrypt] recipient SubjectKeyIdentifier match token alias certificate");
                    } else {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                }
                object = object.getPrivateKey(string);
                object3 = new JceKeyTransEnvelopedRecipient((PrivateKey)object);
                object3.setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)object));
                object3.setContentProvider(ProvUtils.bcProvider);
                object = object2.getContentStream((Recipient)object3);
                object = object.getContentStream();
                a.debug("decrypting data...");
                Streams.pipeAll((InputStream)object, (OutputStream)outputStream);
                a.debug("[decrypt] done.");
            }
            catch (CapiException capiException) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
            }
            catch (IOException iOException) {
                a.debug(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("IOException", 50050);
            }
            catch (CMSException cMSException) {
                a.debug(cMSException.getMessage(), (Throwable)cMSException);
                throw new CapiException("CMSException", 50050);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
            catch (CapiError capiError) {
                a.debug(capiError.getMessage(), (Throwable)capiError);
                throw capiError.getCapiException();
            }
        }
        catch (Throwable throwable) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            a.debug("closing der_encoded stream ...");
            try {
                this.c.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
        a.debug("closing der_encoded stream ...");
        try {
            this.c.close();
        }
        catch (IOException iOException) {}
        return true;
    }

    public String toString() {
        try {
            switch (this.b) {
                case 0: {
                    return "Envelope not ciphered yet";
                }
                case 3: 
                case 4: {
                    return this.envelopedData.toString();
                }
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        return this.getClass().getName();
    }

    /*
     * Loose catch block
     */
    public static boolean isEncryptedEnvelope(InputStream inputStream) {
        block18: {
            if (inputStream == null) {
                return false;
            }
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
            aSN1StreamParser = (ASN1SequenceParser)aSN1StreamParser.readObject();
            aSN1StreamParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser);
            if (aSN1StreamParser.getContentType().getId().compareToIgnoreCase(PKCSObjectIdentifiers.envelopedData.getId()) != 0) break block18;
            a.debug("[StreamEncryptedEnvelope] isEncryptedEnvelope true");
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return true;
        }
        a.debug("[StreamEncryptedEnvelope] isEncryptedEnvelope false");
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return false;
        catch (ClassCastException classCastException) {
            a.debug("[StreamEncryptedEnvelope] ClassCastException");
            a.debug(classCastException.getMessage(), (Throwable)classCastException);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return false;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            {
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    private void a(X509Certificate x509Certificate, byte[] byArray) throws CapiException {
        if (this.b == 4 || this.b == 3) {
            throw new CapiException("Cannot add recipient", 51002);
        }
        a.debug("adding Recipient ...");
        try {
            if (this.b != 2) {
                this.d = new CMSEnvelopedDataStreamGenerator();
            }
            if (byArray != null) {
                a.debug("Recipient subjectkeyidentifier ...");
                x509Certificate = new JceKeyTransRecipientInfoGenerator(byArray, x509Certificate.getPublicKey());
            } else {
                a.debug("Recipient Issuer and Serial number ...");
                x509Certificate = new JceKeyTransRecipientInfoGenerator(x509Certificate);
            }
            this.d.addRecipientInfoGenerator((RecipientInfoGenerator)x509Certificate.setProvider(ProvUtils.bcProvider));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        a.debug("Recipient added.");
        this.b = 2;
    }
}

