/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.utils;

import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeGenerator;
import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeOptions;
import it.actalis.ellips.capi.cms.encrypt.EncryptionAlgorithm;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.StreamEncryptedEnvelope;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;

public class EncryptionUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void encryptSafeEnvelop(InputHandler object, OutputHandler outputHandler, X509Certificate[] x509CertificateArray, EncryptionAlgorithm encryptionAlgorithm) throws CapiException, Throwable {
        try {
            EncryptEnvelopeOptions encryptEnvelopeOptions = new EncryptEnvelopeOptions();
            if (x509CertificateArray.length == 0) {
                throw new Throwable("No encryption certificates found");
            }
            encryptEnvelopeOptions.setRecipients(Arrays.asList(x509CertificateArray));
            if (encryptionAlgorithm == null) {
                encryptionAlgorithm = EncryptionAlgorithm.DES_EDE3_CBC;
            }
            encryptEnvelopeOptions.setAlgorithm(encryptionAlgorithm);
            encryptEnvelopeOptions.setInput((InputHandler)object);
            encryptEnvelopeOptions.setOutput(outputHandler);
            object = new EncryptEnvelopeGenerator();
            object.encrypt(encryptEnvelopeOptions);
            return;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
    }

    public static boolean decryptSafeEnvelop(InputHandler object, OutputHandler object2, TokenSpi tokenSpi) throws CapiException, IOException {
        boolean bl = false;
        Object object3 = new ArrayList<String>(Arrays.asList(TokenHelper.listObjects((TokenSpi)tokenSpi, null, (byte)4)));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = object.getInputAsNewStream();
            outputStream = object2.getAsOutputStream();
            object = new StreamEncryptedEnvelope(inputStream);
            object2 = ((StreamEncryptedEnvelope)object).listRecipients();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                String string = (String)object3.next();
                try {
                    String string2 = new Certificate(tokenSpi.getCert(string).getBytes()).getSerialNumber().toString();
                    if (!object2.containsKey(string2)) continue;
                    bl = ((StreamEncryptedEnvelope)object).decrypt(tokenSpi, string, outputStream);
                    break;
                }
                catch (CapiException capiException) {
                    a.error(capiException.getMessage(), (Throwable)capiException);
                }
            }
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
        }
        return bl;
    }
}

