/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.cms.CadesUnSignedAttributeGenerator;
import it.actalis.ellips.capi.cms.a;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.SignedEnvelopeUtils;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;

public class CadesSignatureUpdater {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private CadesSignatureOptions b;
    private CMSSignedDataParser c;
    private a d;
    private LinkedList<X509Certificate> e;
    private LTResourceResolver f;

    CadesSignatureUpdater(CadesSignatureOptions cadesSignatureOptions, CMSSignedDataParser cMSSignedDataParser, a a2, LinkedList<X509Certificate> linkedList, LTResourceResolver lTResourceResolver) {
        this.b = cadesSignatureOptions;
        this.c = cMSSignedDataParser;
        this.d = a2;
        this.e = linkedList;
        this.f = lTResourceResolver;
    }

    final void a() throws CapiException, IOException, NumberFormatException, CertificateException, CertificateEncodingException, CMSException, CRLException {
        SignerInformationStore signerInformationStore;
        Object object = signerInformationStore = this;
        object = signerInformationStore.b.getSignaturePath().split(":");
        Object object2 = new int[((String[])object).length];
        for (int i = 0; i < ((int[])object2).length; ++i) {
            object2[i] = Integer.parseInt(object[i]);
        }
        object = object2;
        object2 = new LinkedList(signerInformationStore.c.getSignerInfos().getSigners());
        signerInformationStore = super.a((int[])object, (LinkedList<SignerInformation>)object2);
        this.d.a(signerInformationStore);
    }

    private SignerInformationStore a(int[] nArray, LinkedList<SignerInformation> linkedList) throws CapiException, IOException, NumberFormatException, CertificateException, CertificateEncodingException, CMSException, CRLException {
        SignerInformation signerInformation = linkedList.get(nArray[0]);
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        if (nArray.length > 1) {
            Object object = Arrays.copyOfRange(nArray, 1, nArray.length);
            LinkedList<SignerInformation> linkedList2 = new LinkedList<SignerInformation>(signerInformation.getCounterSignatures().getSigners());
            object = this.a((int[])object, linkedList2);
            signerInformation = CadesSignatureUpdater.a(signerInformation, attributeTable);
            signerInformation = SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)object);
        } else {
            signerInformation = this.a(attributeTable, signerInformation);
        }
        linkedList.set(nArray[0], signerInformation);
        return new SignerInformationStore(linkedList);
    }

    private static SignerInformation a(SignerInformation signerInformation, AttributeTable object) {
        if (object == null) {
            return signerInformation;
        }
        a.debug("replacing unsigned attribute... ");
        object = object.toHashtable();
        object.remove(CMSAttributes.counterSignature);
        object = new AttributeTable((Hashtable)object);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)object);
    }

    private SignerInformation a(AttributeTable object, SignerInformation signerInformation) throws CapiException, IOException, CMSException, CRLException, CertificateException {
        TimeStampToken timeStampToken = null;
        if (object != null) {
            timeStampToken = SignedEnvelopeUtils.getTimeStampToken(object);
            object = object.toHashtable();
        } else {
            object = new Hashtable();
        }
        if (timeStampToken == null) {
            a.debug("Adding signature TimeStampToken");
            timeStampToken = CadesUnSignedAttributeGenerator.generateTimeStamp(signerInformation.getSignature(), this.b.getTimeStampOptions());
            signerInformation = CadesSignatureUpdater.a(signerInformation, timeStampToken, (Hashtable)object);
            a.debug("Signature TimeStampToken adding OK");
        }
        if (this.b.getSignatureLevel().compareTo((Enum)SignatureLevel.T) > 0 || this.b.isIncludeCertificateChain()) {
            this.a(signerInformation, timeStampToken);
        }
        return signerInformation;
    }

    private static SignerInformation a(SignerInformation signerInformation, TimeStampToken timeStampToken, Hashtable hashtable) throws CapiException, IOException {
        timeStampToken = CadesUnSignedAttributeGenerator.getTSUnsignedAttribute(timeStampToken.toByteArray(false, true));
        hashtable.put(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, timeStampToken);
        timeStampToken = new AttributeTable(hashtable);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)timeStampToken);
    }

    private void a(SignerInformation object, TimeStampToken timeStampToken) throws CapiException, CMSException, CRLException, CertificateException, IOException {
        if ((object = SignedEnvelopeUtils.searchSigningCertificate(object, this.e)) == null) {
            throw new CapiException("Missing signing certificate", 30008);
        }
        CadesUnSignedAttributeGenerator.a(this.d, (X509Certificate)object, this.f, timeStampToken);
    }
}

