/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.Psapi;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.windows.WindowsFileSystem;
import oshi.software.os.windows.WindowsNetworkParams;
import oshi.software.os.windows.WindowsOSVersionInfoEx;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOperatingSystem.class);
    private static final String processProperties = "Name,ExecutablePath,CommandLine,ExecutionState,ProcessID,ParentProcessId,ThreadCount,Priority,VirtualSize,WorkingSetSize,KernelModeTime,UserModeTime,CreationDate,ReadTransferCount,WriteTransferCount,HandleCount,__PATH,__PATH";
    private static final WmiUtil.ValueType[] processPropertyTypes = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.DATETIME, WmiUtil.ValueType.UINT64, WmiUtil.ValueType.UINT64, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.PROCESS_GETOWNER, WmiUtil.ValueType.PROCESS_GETOWNERSID};
    private static final int UNKNOWN = 0;
    private static final int OTHER = 1;
    private static final int READY = 2;
    private static final int RUNNING = 3;
    private static final int BLOCKED = 4;
    private static final int SUSPENDED_BLOCKED = 5;
    private static final int SUSPENDED_READY = 6;
    private static final int TERMINATED = 7;
    private static final int STOPPED = 8;
    private static final int GROWING = 9;
    private static final int ERROR_ACCESS_DENIED = 5;

    public WindowsOperatingSystem() {
        this.manufacturer = "Microsoft";
        this.family = "Windows";
        this.version = new WindowsOSVersionInfoEx();
    }

    @Override
    public FileSystem getFileSystem() {
        return new WindowsFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        Map<String, List<Object>> procs = WmiUtil.selectObjectsFrom(null, "Win32_Process", processProperties, null, processPropertyTypes);
        List<OSProcess> procList = this.processMapToList(procs);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        Map<String, List<Object>> procs = WmiUtil.selectObjectsFrom(null, "Win32_Process", processProperties, String.format("WHERE ProcessId=%d", pid), processPropertyTypes);
        List<OSProcess> procList = this.processMapToList(procs);
        return procList.isEmpty() ? null : procList.get(0);
    }

    private List<OSProcess> processMapToList(Map<String, List<Object>> procs) {
        long now = System.currentTimeMillis();
        ArrayList<OSProcess> procList = new ArrayList<OSProcess>();
        ArrayList<String> groupList = new ArrayList<String>();
        ArrayList<String> groupIDList = new ArrayList<String>();
        int procCount = procs.get("Name").size();
        int myPid = this.getProcessId();
        for (int p = 0; p < procCount; ++p) {
            OSProcess proc = new OSProcess();
            proc.setName((String)procs.get("Name").get(p));
            proc.setPath((String)procs.get("ExecutablePath").get(p));
            proc.setCommandLine((String)procs.get("CommandLine").get(p));
            proc.setProcessID(((Long)procs.get("ProcessID").get(p)).intValue());
            if (myPid == proc.getProcessID()) {
                proc.setCurrentWorkingDirectory(new File(".").getAbsolutePath());
            }
            proc.setParentProcessID(((Long)procs.get("ParentProcessId").get(p)).intValue());
            proc.setUser((String)procs.get("PROCESS_GETOWNER").get(p));
            proc.setUserID((String)procs.get("PROCESS_GETOWNERSID").get(p));
            if (procCount == 1) {
                WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1040, false, proc.getProcessID());
                if (pHandle != null) {
                    WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
                    if (Advapi32.INSTANCE.OpenProcessToken(pHandle, 10, phToken)) {
                        Advapi32Util.Account[] accounts = Advapi32Util.getTokenGroups((WinNT.HANDLE)phToken.getValue());
                        groupList.clear();
                        groupIDList.clear();
                        for (Advapi32Util.Account account : accounts) {
                            groupList.add(account.name);
                            groupIDList.add(account.sidString);
                        }
                        proc.setGroup(FormatUtil.join((CharSequence)",", groupList));
                        proc.setGroupID(FormatUtil.join((CharSequence)",", groupIDList));
                    } else {
                        int error = Kernel32.INSTANCE.GetLastError();
                        if (error != 5) {
                            LOG.error("Failed to get process token for process {}: {}", (Object)proc.getProcessID(), (Object)Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }
                Kernel32.INSTANCE.CloseHandle(pHandle);
            }
            switch (((Long)procs.get("ExecutionState").get(p)).intValue()) {
                case 2: 
                case 6: {
                    proc.setState(OSProcess.State.SLEEPING);
                    break;
                }
                case 4: 
                case 5: {
                    proc.setState(OSProcess.State.WAITING);
                    break;
                }
                case 3: {
                    proc.setState(OSProcess.State.RUNNING);
                    break;
                }
                case 9: {
                    proc.setState(OSProcess.State.NEW);
                    break;
                }
                case 7: {
                    proc.setState(OSProcess.State.ZOMBIE);
                    break;
                }
                case 8: {
                    proc.setState(OSProcess.State.STOPPED);
                    break;
                }
                default: {
                    proc.setState(OSProcess.State.OTHER);
                }
            }
            proc.setThreadCount(((Long)procs.get("ThreadCount").get(p)).intValue());
            proc.setPriority(((Long)procs.get("Priority").get(p)).intValue());
            proc.setVirtualSize(ParseUtil.parseLongOrDefault((String)procs.get("VirtualSize").get(p), 0L));
            proc.setResidentSetSize(ParseUtil.parseLongOrDefault((String)procs.get("WorkingSetSize").get(p), 0L));
            proc.setKernelTime(ParseUtil.parseLongOrDefault((String)procs.get("KernelModeTime").get(p), 0L) / 10000L);
            proc.setUserTime(ParseUtil.parseLongOrDefault((String)procs.get("UserModeTime").get(p), 0L) / 10000L);
            proc.setStartTime((Long)procs.get("CreationDate").get(p));
            proc.setUpTime(now - proc.getStartTime());
            proc.setBytesRead((Long)procs.get("ReadTransferCount").get(p));
            proc.setBytesWritten((Long)procs.get("WriteTransferCount").get(p));
            proc.setOpenFiles((Long)procs.get("HandleCount").get(p));
            procList.add(proc);
        }
        return procList;
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getProcessCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ProcessCount.intValue();
    }

    @Override
    public int getThreadCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ThreadCount.intValue();
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new WindowsNetworkParams();
    }

    private static void enableDebugPrivilege() {
        WinNT.HANDLEByReference hToken = new WinNT.HANDLEByReference();
        boolean success = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, hToken);
        if (!success) {
            LOG.error("OpenProcessToken failed. Error: {}" + Native.getLastError());
            return;
        }
        WinNT.LUID luid = new WinNT.LUID();
        success = Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", luid);
        if (!success) {
            LOG.error("LookupprivilegeValue failed. Error: {}" + Native.getLastError());
            return;
        }
        WinNT.TOKEN_PRIVILEGES tkp = new WinNT.TOKEN_PRIVILEGES(1);
        tkp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
        success = Advapi32.INSTANCE.AdjustTokenPrivileges(hToken.getValue(), false, tkp, 0, null, null);
        if (!success) {
            LOG.error("AdjustTokenPrivileges failed. Error: {}" + Native.getLastError());
        }
        Kernel32.INSTANCE.CloseHandle(hToken.getValue());
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        StringBuilder query = new StringBuilder("WHERE ");
        for (Integer pid : pids) {
            query.append(String.format("ProcessId=%d OR ", pid));
        }
        query.setLength(query.length() - 3);
        Map<String, List<Object>> procs = WmiUtil.selectObjectsFrom(null, "Win32_Process", processProperties, query.toString(), processPropertyTypes);
        List<OSProcess> procList = this.processMapToList(procs);
        return procList;
    }

    static {
        WindowsOperatingSystem.enableDebugPrivilege();
    }
}

