/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.util.ExecutingCommand;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;

public class FreeBsdUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static Map<String, String> nameMap = new HashMap<String, String>();
    private static Map<String, String> vendorMap = new HashMap<String, String>();
    private static Map<String, String> vendorIdMap = new HashMap<String, String>();
    private static Map<String, String> productIdMap = new HashMap<String, String>();
    private static Map<String, String> serialMap = new HashMap<String, String>();
    private static Map<String, String> parentMap = new HashMap<String, String>();
    private static Map<String, List<String>> hubMap = new HashMap<String, List<String>>();

    public FreeBsdUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = FreeBsdUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            deviceList.add(new FreeBsdUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new FreeBsdUsbDevice[0]));
            FreeBsdUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(device);
            FreeBsdUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        nameMap.clear();
        vendorMap.clear();
        vendorIdMap.clear();
        productIdMap.clear();
        serialMap.clear();
        hubMap.clear();
        parentMap.clear();
        List<String> devices = ExecutingCommand.runNative("lshal");
        if (devices.isEmpty()) {
            return new FreeBsdUsbDevice[0];
        }
        String key = "";
        ArrayList<String> usBuses = new ArrayList<String>();
        for (String line : devices) {
            if (line.startsWith("udi =")) {
                key = ParseUtil.getSingleQuoteStringValue(line);
                continue;
            }
            if (key.isEmpty() || (line = line.trim()).isEmpty()) continue;
            if (line.startsWith("freebsd.driver =") && "usbus".equals(ParseUtil.getSingleQuoteStringValue(line))) {
                usBuses.add(key);
                continue;
            }
            if (line.contains(".parent =")) {
                String parent = ParseUtil.getSingleQuoteStringValue(line);
                if (key.replace(parent, "").startsWith("_if")) continue;
                parentMap.put(key, parent);
                MapUtil.createNewListIfAbsent(hubMap, parent).add(key);
                continue;
            }
            if (line.contains(".vendor =")) {
                vendorMap.put(key, ParseUtil.getSingleQuoteStringValue(line));
                continue;
            }
            if (line.contains(".product =")) {
                nameMap.put(key, ParseUtil.getSingleQuoteStringValue(line));
                continue;
            }
            if (line.contains(".serial =")) {
                String serial = ParseUtil.getSingleQuoteStringValue(line);
                serialMap.put(key, serial.startsWith("0x") ? ParseUtil.hexStringToString(serial.replace("0x", "")) : serial);
                continue;
            }
            if (!line.contains(".vendor_id =") && !line.contains(".product_id =")) continue;
            vendorIdMap.put(key, String.format("%04x", ParseUtil.getFirstIntValue(line)));
        }
        ArrayList<FreeBsdUsbDevice> controllerDevices = new ArrayList<FreeBsdUsbDevice>();
        for (String usbus : usBuses) {
            String parent = parentMap.get(usbus);
            hubMap.put(parent, hubMap.get(usbus));
            controllerDevices.add(FreeBsdUsbDevice.getDeviceAndChildren(parent, "0000", "0000"));
        }
        return controllerDevices.toArray(new UsbDevice[controllerDevices.size()]);
    }

    private static FreeBsdUsbDevice getDeviceAndChildren(String devPath, String vid, String pid) {
        String vendorId = MapUtil.getOrDefault(vendorIdMap, devPath, vid);
        String productId = MapUtil.getOrDefault(productIdMap, devPath, pid);
        List childPaths = MapUtil.getOrDefault(hubMap, devPath, new ArrayList());
        ArrayList<FreeBsdUsbDevice> usbDevices = new ArrayList<FreeBsdUsbDevice>();
        for (String path : childPaths) {
            usbDevices.add(FreeBsdUsbDevice.getDeviceAndChildren(path, vendorId, productId));
        }
        Collections.sort(usbDevices);
        return new FreeBsdUsbDevice(MapUtil.getOrDefault(nameMap, devPath, vendorId + ":" + productId), "", vendorId, productId, "", usbDevices.toArray(new UsbDevice[usbDevices.size()]));
    }
}

