/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pcsc;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.ATR;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.Hex;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;

public class SCardUtils {
    private static int a = 1;
    private static final Logger b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static List<ATR> retrieveATR() {
        b.info("SCardUtils16.retrieveATR() start");
        LinkedList<ATR> linkedList = new LinkedList();
        try {
            Iterator iterator = TerminalFactory.getDefault();
            iterator = ((TerminalFactory)((Object)iterator)).terminals().list();
            b.info("Numero di terminali trovati: {}", (Object)iterator.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                CardTerminal cardTerminal = (CardTerminal)iterator.next();
                b.info("  Terminal [{}]:", (Object)cardTerminal.getName());
                Card card = null;
                try {
                    card = cardTerminal.connect("*");
                    b.info("    connected", (Object)cardTerminal.getName());
                    String string = Hex.getHex((byte[])card.getATR().getBytes());
                    b.info("    returns ATR = {}", (Object)string);
                    linkedList.add(new ATR(cardTerminal.getName(), string.toLowerCase()));
                }
                catch (CardNotPresentException cardNotPresentException) {
                    b.error("    no card is present");
                }
                catch (CardException cardException) {
                    b.error("    not connected", (Throwable)cardException);
                }
                catch (Exception exception) {
                    b.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (card == null) continue;
                    card.disconnect(false);
                }
            }
        }
        catch (CardException cardException) {
            b.error(cardException.getMessage(), (Throwable)cardException);
            try {
                SCardUtils.clearTerminalsList();
                if (a-- >= 0) {
                    linkedList = SCardUtils.retrieveATR();
                }
            }
            catch (Exception exception) {
                b.error(cardException.getMessage(), (Throwable)cardException);
            }
            finally {
                a = 1;
            }
        }
        b.info("SCardUtils16.retrieveATR() end");
        return linkedList;
    }

    public static void clearTerminalsList() throws Exception {
        b.debug("clear the terminals in cache");
        b.info("clearTerminalsList() start");
        AnnotatedElement annotatedElement = Class.forName("sun.security.smartcardio.PCSCTerminals");
        Object object = ((Class)annotatedElement).getDeclaredField("contextId");
        ((Field)object).setAccessible(true);
        if (((Field)object).getLong(annotatedElement) != 0L) {
            GenericDeclaration genericDeclaration = Class.forName("sun.security.smartcardio.PCSC");
            Method method = genericDeclaration.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
            method.setAccessible(true);
            Field field = genericDeclaration.getDeclaredField("SCARD_SCOPE_USER");
            field.setAccessible(true);
            long l = (Long)method.invoke(genericDeclaration, field.getInt(genericDeclaration));
            ((Field)object).setLong(annotatedElement, l);
            object = TerminalFactory.getDefault();
            object = ((TerminalFactory)object).terminals();
            annotatedElement = ((Class)annotatedElement).getDeclaredField("terminals");
            ((Field)annotatedElement).setAccessible(true);
            genericDeclaration = Class.forName("java.util.Map");
            genericDeclaration = genericDeclaration.getDeclaredMethod("clear", new Class[0]);
            ((Method)genericDeclaration).invoke(((Field)annotatedElement).get(object), new Object[0]);
        }
        b.info("clearTerminalsList() end");
    }

    public static ATR retrieveATR(String string) {
        ATR aTR = new ATR("", "");
        try {
            Iterator iterator = TerminalFactory.getDefault();
            iterator = ((TerminalFactory)((Object)iterator)).terminals().list();
            b.info("Numero di terminali trovati: {}", (Object)iterator.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                CardTerminal cardTerminal = (CardTerminal)iterator.next();
                b.info("Lettura terminale [{}]", (Object)cardTerminal.getName());
                Card card = null;
                try {
                    if (!cardTerminal.getName().toUpperCase().contains(string.trim().toUpperCase())) continue;
                    card = cardTerminal.connect("*");
                    b.info("Terminale [{}] connesso", (Object)cardTerminal.getName());
                    String string2 = Hex.getHex((byte[])card.getATR().getBytes());
                    b.info("Trovato ATR = {}", (Object)string2);
                    aTR = new ATR(cardTerminal.getName(), string2.toLowerCase());
                }
                catch (CardNotPresentException cardNotPresentException) {
                    b.error("Nessuna carta presente");
                }
                catch (CardException cardException) {
                    b.error("Terminale [" + cardTerminal.getName() + "] non connesso", (Throwable)cardException);
                }
                catch (Exception exception) {
                    b.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (card == null) continue;
                    card.disconnect(false);
                }
            }
        }
        catch (CardException cardException) {
            b.error(cardException.getMessage(), (Throwable)cardException);
        }
        return aTR;
    }
}

