/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.Display;
import esecurity.desktop.swt.Image;
import esecurity.desktop.swt.Item;
import esecurity.desktop.swt.ReflectedClass;
import esecurity.desktop.swt.SWTClass;
import esecurity.desktop.swt.SWTFacade;
import esecurity.desktop.swt.ToolTip;
import esecurity.desktop.swt.Tray;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class TrayItem
extends Item {
    public TrayItem(Object obj) {
        try {
            this.innerObject = new ReflectedClass(obj);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public TrayItem(Tray tray, int style) {
        Display.getDefault().syncExec(() -> {
            try {
                this.innerObject = SWTClass.TrayItem.getRef();
                this.innerObject.init(tray.innerObject.getObj(), style);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
    }

    public void setImage(Image image) {
        Display.getDefault().syncExec(() -> {
            try {
                this.innerObject.callMethod("setImage", image.innerObject.getObj());
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
    }

    public void setToolTipText(String text) {
        Display.getDefault().syncExec(() -> {
            try {
                this.innerObject.callMethod("setToolTipText", text);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
    }

    public void setToolTip(ToolTip toolTip) {
        Display.getDefault().syncExec(() -> {
            try {
                this.innerObject.callMethod("setToolTip", toolTip.innerObject.getObj());
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
    }

    public void onDoubleClick(final Runnable run) {
        Display.getDefault().syncExec(() -> {
            try {
                Object p = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.Listener.getClss()}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        run.run();
                        return null;
                    }
                });
                this.innerObject.callMethod("addListener", 14, p);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
    }
}

