/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import esecurity.dsd.client.cmd.Command;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.http.AdminHTTPClient;
import java.util.Optional;

@Parameters(separators=" ", commandDescription="Get user administration")
public class CommandGetUser
implements Command {
    @Parameter(names={"list"}, description="List of users")
    private boolean list = false;
    @Parameter(description="Username")
    private String username = null;

    @Override
    public void execute(LocalConfigurationProvider lcp) {
        AdminHTTPClient adminHTTPClient = new AdminHTTPClient(lcp);
        if (this.list) {
            adminHTTPClient.getUsers().forEach(u -> System.out.println((String)u));
        } else if (this.username != null) {
            Optional credential = adminHTTPClient.getUserDetails(this.username);
            if (credential.isPresent()) {
                AdminHTTPClient.Credential c = (AdminHTTPClient.Credential)credential.get();
                System.out.println("User: " + this.username);
                System.out.println("Ruoli: " + c.getRoles());
            } else {
                System.out.println("User not found.");
            }
        }
    }

    @Override
    public String getCommand() {
        return "getuser";
    }
}

