/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.crl;

import com.google.gson.Gson;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CrlBean;
import esecurity.validator.x509status.RevocationBean;
import esecurity.validator.x509status.crl.CRLCacheManager;
import esecurity.validator.x509status.crl.CRLUtils;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.I;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.X509CRLEntry;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;

public class DefaultCrlCacheManager
implements CRLCacheManager {
    private boolean a = true;
    private ValidatorConfig b = null;
    private Logger c = null;
    private static final HashMap<String, MVStore> d = new HashMap();
    private MVStore e = null;
    private MVMap<String, String> f = null;
    private static final ConcurrentHashMap<String, CRL> g = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, MVStore> h = new ConcurrentHashMap();
    private static final LinkedBlockingQueue<String> i = new LinkedBlockingQueue();
    private Thread j = null;
    private Thread[] k = null;
    private a l = null;
    private b[] m = null;
    private int n = 3;
    private Gson o = new Gson();
    private String p = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCrlCacheManager(ValidatorConfig hashMap, Logger object) throws CapiException {
        this.b = hashMap;
        this.c = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (object != null) {
            this.c = object;
        }
        object = ((ValidatorConfig)((Object)hashMap)).getElement("certdb.file");
        String string = ((ValidatorConfig)((Object)hashMap)).getElement("certdb.pwd");
        try {
            CertDB.getInstance((String)object, string, false, true);
        }
        catch (CertDBException certDBException) {
            throw new CapiException("Impossibile trovare il certdb", 1003, certDBException);
        }
        hashMap = ((ValidatorConfig)((Object)hashMap)).getElement("crl.dir");
        if (hashMap != null) {
            if (!((File)((Object)(hashMap = new File((String)((Object)hashMap))))).exists()) {
                ((File)((Object)hashMap)).mkdirs();
            }
            this.a = false;
            this.p = ((File)((Object)hashMap)).getAbsolutePath() + File.separatorChar + "crl.cache";
            hashMap = d;
            synchronized (hashMap) {
                this.e = d.get(this.p);
                if (this.e == null) {
                    this.e = DefaultCrlCacheManager.a(this.p);
                    this.f = this.e.openMap("crlInfos", (MVMap.MapBuilder)new MVMap.Builder());
                    this.l = new a(this, 0);
                    this.j = new Thread(this.l);
                    this.j.setDaemon(true);
                    this.j.start();
                    this.m = new b[this.n];
                    this.k = new Thread[this.n];
                    for (int i = 0; i < this.n; ++i) {
                        this.m[i] = new b(this, 0);
                        this.k[i] = new Thread(this.m[i]);
                        this.k[i].setDaemon(true);
                        this.k[i].start();
                    }
                    d.put(this.p, this.e);
                    Runtime.getRuntime().addShutdownHook(new Thread(new esecurity.validator.x509status.crl.a(this)));
                } else {
                    this.f = this.e.openMap("crlInfos", (MVMap.MapBuilder)new MVMap.Builder());
                }
                return;
            }
        }
    }

    @Override
    public RevocationBean checkRevocation(Certificate object, ValidationDate object2) {
        String string = CRLUtils.generateCrlId((Certificate)object);
        RevocationBean revocationBean = null;
        Object object3 = g.get(string);
        if (object3 != null) {
            revocationBean = CRLUtils.a((CRL)object3, ((Certificate)object).getInternalCert().getSerialNumber(), (ValidationDate)object2);
        }
        if (revocationBean != null) {
            return revocationBean;
        }
        if (this.f.get((Object)string) == null) {
            this.c.debug("Crl not in cache...");
            return null;
        }
        object3 = new Date();
        CrlBean crlBean = (CrlBean)this.o.fromJson((String)this.f.get((Object)string), CrlBean.class);
        if (!crlBean.isCrlValid()) {
            this.c.debug("Crl not valid");
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            if (((Date)object3).before(simpleDateFormat.parse(crlBean.getNextUpdate()))) {
                revocationBean = new RevocationBean();
                revocationBean.setCrlBean(crlBean);
                revocationBean.setCrlStatus(crlBean.getCrlStatusExplained());
                object3 = h.get(string);
                string = object3.openMap(string, (MVMap.MapBuilder)new MVMap.Builder());
                object = (String)string.get((Object)((Certificate)object).getInternalCert().getSerialNumber());
                if (object == null) {
                    revocationBean.setCertRevoked(false);
                } else {
                    object = (c)this.o.fromJson((String)object, c.class);
                    if (((Date)(object2 = ((ValidationDate)object2).getDate())).compareTo(((c)object).b()) >= 0) {
                        revocationBean.setCertRevoked(true);
                        revocationBean.setRevocationDate(((c)object).b());
                        revocationBean.setRevocationReason(Integer.toString(((c)object).a()));
                        object = CRLUtils.a(((c)object).a());
                        if (!revocationBean.getInvalidityReason().equalsIgnoreCase("")) {
                            object = revocationBean.getInvalidityReason() + " - " + (String)object;
                        }
                        revocationBean.setInvalidityReason((String)object);
                    }
                }
            }
        }
        catch (ParseException parseException) {
            this.c.error("unable to parse crl nextUpdate.", (Throwable)parseException);
        }
        return revocationBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCrlInCache(String string) {
        Serializable serializable;
        if (this.a) {
            return false;
        }
        if (this.f.get((Object)string) == null) {
            this.c.debug("Crl's info for id:" + string + " is null");
            return g.get(string) != null;
        }
        CrlBean crlBean = (CrlBean)this.o.fromJson((String)this.f.get((Object)string), CrlBean.class);
        if (!crlBean.isCrlValid()) {
            this.c.debug("Crl not valid");
            return g.get(string) != null;
        }
        Object object = h.get(string);
        if (object == null) {
            serializable = h;
            synchronized (serializable) {
                object = h.get(string);
                if (object == null) {
                    object = DefaultCrlCacheManager.a(crlBean.getCacheFile());
                    h.put(string, (MVStore)object);
                }
            }
        }
        if (object != null) {
            serializable = new Date();
            try {
                object = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
                if (((Date)serializable).before(((DateFormat)object).parse(crlBean.getNextUpdate()))) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                this.c.error("unable to parse crl nextUpdate.", (Throwable)parseException);
            }
        }
        return g.get(string) != null;
    }

    @Override
    public void addCrlToCache(String string, CRL cRL) throws CapiException {
        if (!this.a && g.size() < 10) {
            g.put(string, cRL);
            i.add(string);
        }
    }

    private void d() {
        try {
            if (this.l != null) {
                this.l.a(false);
                this.j.join();
                this.l = null;
                this.j = null;
            }
            if (this.m == null) {
                return;
            }
            for (int i = 0; i < this.n; ++i) {
                this.m[i].a(false);
                this.k[i].join();
            }
            this.m = null;
            this.k = null;
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    public void finalize() throws Throwable {
        this.d();
        super.finalize();
    }

    private static MVStore a(String string) {
        return new MVStore.Builder().fileName(string).encryptionKey("1A23C4D567890AB76329CDE".toCharArray()).compress().open();
    }

    static /* synthetic */ void a(DefaultCrlCacheManager defaultCrlCacheManager) {
        defaultCrlCacheManager.d();
        for (String string : h.keySet()) {
            h.get(string).close();
        }
        h.clear();
        defaultCrlCacheManager.e.close();
    }

    private class c
    implements Serializable {
        private int a;
        private Date b;

        public c(DefaultCrlCacheManager defaultCrlCacheManager, BigInteger bigInteger, int n, Date date) {
            this.a = n;
            this.b = date;
        }

        public final int a() {
            return this.a;
        }

        public final Date b() {
            return this.b;
        }
    }

    private final class b
    implements Runnable {
        private boolean a = true;
        private /* synthetic */ DefaultCrlCacheManager b;

        private b(DefaultCrlCacheManager defaultCrlCacheManager) {
            this.b = defaultCrlCacheManager;
        }

        @Override
        public final void run() {
            try {
                while (this.a) {
                    CRL cRL;
                    String string = (String)i.poll(1L, TimeUnit.SECONDS);
                    if (string == null || (cRL = (CRL)g.get(string)) == null) continue;
                    try {
                        Serializable serializable;
                        CrlBean crlBean = CRLUtils.a(cRL, new Date());
                        String string2 = BigInteger.valueOf(System.nanoTime()).toString(16);
                        string2 = this.b.p.replaceAll(".cache", "_" + string + "_" + string2 + ".cache");
                        MVStore mVStore = DefaultCrlCacheManager.a(string2);
                        MVMap mVMap = mVStore.openMap(string);
                        if (cRL.getInternalCRL() != null && cRL.getInternalCRL().getRevokedCertificates() != null) {
                            for (X509CRLEntry x509CRLEntry : cRL.getInternalCRL().getRevokedCertificates()) {
                                int n = 0;
                                try {
                                    n = cRL.getReasonCode(x509CRLEntry.getSerialNumber());
                                }
                                catch (CapiException capiException) {}
                                serializable = new c(this.b, x509CRLEntry.getSerialNumber(), n, x509CRLEntry.getRevocationDate());
                                mVMap.putIfAbsent((Object)x509CRLEntry.getSerialNumber(), (Object)this.b.o.toJson((Object)serializable));
                            }
                        }
                        crlBean.setCacheFile(string2);
                        MVStore mVStore2 = h.put(string, mVStore);
                        if (mVStore2 != null) {
                            CrlBean crlBean2 = (CrlBean)this.b.o.fromJson((String)this.b.f.put((Object)string, (Object)this.b.o.toJson((Object)crlBean)), CrlBean.class);
                            mVStore2.close();
                            serializable = new File(crlBean2.getCacheFile());
                            ((File)serializable).delete();
                        } else {
                            this.b.f.put((Object)string, (Object)this.b.o.toJson((Object)crlBean));
                        }
                        g.remove(string);
                        mVStore.sync();
                        this.b.e.sync();
                        mVStore.commit();
                        this.b.e.commit();
                    }
                    catch (Exception exception) {
                        this.b.c.error("unable to parse crl.", (Throwable)exception);
                        exception.printStackTrace();
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.b.c.error("Worker Interrotto", (Throwable)interruptedException);
                interruptedException.printStackTrace();
                return;
            }
        }

        public final void a(boolean bl) {
            this.a = false;
        }

        /* synthetic */ b(DefaultCrlCacheManager defaultCrlCacheManager, byte by) {
            this(defaultCrlCacheManager);
        }
    }

    private final class a
    implements Runnable {
        private boolean a = true;
        private /* synthetic */ DefaultCrlCacheManager b;

        private a(DefaultCrlCacheManager defaultCrlCacheManager) {
            this.b = defaultCrlCacheManager;
        }

        @Override
        public final void run() {
            UrlClient urlClient = new UrlClient(this.b.b.getNetConfiguration(), this.b.c);
            while (this.a) {
                Serializable serializable;
                try {
                    while (this.a) {
                        Thread.sleep(1000L);
                    }
                    serializable = new Date();
                    if (g.size() >= 10) continue;
                    for (Map.Entry entry : this.b.f.entrySet()) {
                        Object object = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
                        CrlBean crlBean = (CrlBean)this.b.o.fromJson((String)entry.getValue(), CrlBean.class);
                        if (!((Date)serializable).after(new Date(((DateFormat)object).parse(crlBean.getNextUpdate()).getTime() - 600000L))) continue;
                        object = null;
                        try {
                            Object object2;
                            this.b.c.debug(I.d() + "Url " + crlBean.getDownloadedUrl());
                            if (crlBean.getDownloadedUrl().startsWith("ldap")) {
                                object2 = urlClient.downloadUrl(crlBean.getDownloadedUrl(), null, null);
                                if (!object2.equals("OK")) {
                                    Util.closeQuietly(null);
                                    continue;
                                }
                                object = new ByteArrayInputStream(object2.getData());
                            } else {
                                object = urlClient.getInputStream(new URL(crlBean.getDownloadedUrl()), null);
                            }
                            this.b.c.debug(I.d() + "Fine download");
                            object2 = new CRL(new BufferedInputStream((InputStream)object));
                            object2.setDownloadedUrl(crlBean.getDownloadedUrl());
                            this.b.addCrlToCache((String)entry.getKey(), (CRL)object2);
                            this.b.f.remove(entry.getKey());
                        }
                        catch (Exception exception) {
                            this.b.c.error(I.d() + "Errore: " + exception.getMessage());
                        }
                        finally {
                            Util.closeQuietly((Closeable)object);
                        }
                    }
                }
                catch (Exception exception) {
                    serializable = exception;
                    exception.printStackTrace();
                }
            }
        }

        public final void a(boolean bl) {
            this.a = false;
        }

        /* synthetic */ a(DefaultCrlCacheManager defaultCrlCacheManager, byte by) {
            this(defaultCrlCacheManager);
        }
    }
}

