/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.LoggerLevel;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.util.encoders.Hex;

public abstract class CmdLineParser {
    protected static CmdLineParser instance = null;
    protected File TSLFolder = null;
    protected File tslLogFile = null;
    protected boolean bForceTSLUpdate = false;
    protected File logFolder = null;
    protected File logFile = null;
    protected File baseFolder = null;
    protected File workFolder = null;
    protected LoggerLevel logLevel = null;
    protected File defaultConfAK = null;
    protected File guiConf = null;
    protected File blobAK = null;
    protected File langAK = null;
    protected String cdbPassword = null;
    protected boolean bVerbose = true;
    protected String timeZone = null;
    protected boolean useTimeZoneUTC = true;
    protected boolean bNoProxy = true;
    protected String proxyType = null;
    protected String proxyAddressAndPort = null;
    protected String proxyUsername = null;
    protected String proxyPassword = "password";
    protected File cdbFile = null;
    protected File configFile = null;
    protected String tutorialImagesPath = null;
    protected boolean showWizard = false;
    protected LanguagesCode languageCode = null;
    protected final String defaultPreSharedKey = "3145323430";
    protected List<File> newDocument = new ArrayList<File>();

    public abstract void parse(String[] var1) throws CapiException;

    public abstract void printHelp();

    public abstract void logParsedValues(EllipsLogger var1);

    protected String getParamValue(String[] object, int n) throws CapiException {
        if (object == null || ((String[])object).length == 0) {
            throw new CapiException("empty command line param", 1003);
        }
        if (n < 0 || n >= ((String[])object).length) {
            throw new CapiException("command line value out of bound", 1003);
        }
        if (((String)(object = object[n])).startsWith("--")) {
            throw new CapiException("missing value: another parameter found", 1003);
        }
        return ((String)object).trim();
    }

    public String decryptRC2(String object, String object2) throws CapiException {
        try {
            object2 = new SecretKeySpec(Hex.decode((String)object2), "RC2");
            Cipher cipher = Cipher.getInstance("RC2/ECB/NoPadding");
            cipher.init(2, (Key)object2);
            object2 = new ISO7816d4Padding();
            object = Hex.decode((String)object);
            object = cipher.doFinal((byte[])object);
            int n = object2.padCount((byte[])object);
            object = new String((byte[])object);
            object = ((String)object).substring(0, ((String)object).length() - n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CapiException(noSuchAlgorithmException.getMessage(), 3103);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CapiException(noSuchPaddingException.getMessage(), 3103);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CapiException(invalidKeyException.getMessage(), 3103);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CapiException(illegalBlockSizeException.getMessage(), 3103);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CapiException(badPaddingException.getMessage(), 3103);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new CapiException(invalidCipherTextException.getMessage(), 3103);
        }
        return object;
    }

    public String decryptRC2(String string) throws CapiException {
        return this.decryptRC2(string, "3145323430");
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public File getWorkFolder() {
        return this.workFolder;
    }

    public LoggerLevel getLogLevel() {
        return this.logLevel;
    }

    public File getDefaultConf() {
        return this.defaultConfAK;
    }

    public File getGuiConf() {
        return this.guiConf;
    }

    public String getCdbPassword() {
        return this.cdbPassword;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean isTimeZoneUTC() {
        return this.useTimeZoneUTC;
    }

    public static CmdLineParser getCmdLineparser() {
        return instance;
    }

    public boolean isNoProxy() {
        return this.bNoProxy;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public String getProxyAddressAndPort() {
        return this.proxyAddressAndPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public File getCdbFile() {
        return this.cdbFile;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public LanguagesCode getLanguage() {
        return this.languageCode;
    }

    public void setLanguage(LanguagesCode languagesCode) {
        this.languageCode = languagesCode;
    }

    public boolean isForceTSLUpdate() {
        return this.bForceTSLUpdate;
    }

    public File getTSLLogFile() {
        return this.tslLogFile;
    }

    public File getTSLFolder() {
        return this.TSLFolder;
    }

    public String getTutorialImagesPath() {
        return this.tutorialImagesPath;
    }

    public void setTutorialImagesPath(String string) {
        this.tutorialImagesPath = string;
    }

    public boolean isShowWizard() {
        return this.showWizard;
    }

    public void setShowWizard(boolean bl) {
        this.showWizard = bl;
    }

    public List<File> getNewDocument() {
        return this.newDocument;
    }
}

