/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class StepX509SubjectDNCheck
extends MultipleValidationSubStepImpl {
    public StepX509SubjectDNCheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        linkedList = new LinkedList();
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignature() == null || validationContextParameters.getSignature().getFormat() != null && !validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
            if (validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore().before(Constants.DPCM_AGID_189_2017_DEADLINE)) {
                return linkedList;
            }
            if (validationContextParameters.getSignerCertificate().getCert().getQcStatementSemanticIdentifier() != null && validationContextParameters.getSignerCertificate().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.2")) {
                List<String> list = validationContextParameters.getSignerCertificate().getCert().getQcStatementNameRegistrationAuthorities();
                boolean bl = false;
                try {
                    String[] stringArray = validationContextParameters.getSignerCertificate().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] stringArray2 = validationContextParameters.getSignerCertificate().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                    String[] stringArray3 = validationContextParameters.getSignerCertificate().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] stringArray4 = validationContextParameters.getSignerCertificate().getCert().getIssuerDNAttribute("2.5.4.97");
                    if (stringArray != null && stringArray.length == 1 && stringArray2 != null && stringArray2.length == 1 && stringArray3 != null && stringArray3.length == 1 && stringArray4 != null && stringArray4.length == 1) {
                        String string = stringArray4[0];
                        bl = string != null && string.length() > 6 && string.charAt(5) == '-' && (string.toUpperCase().startsWith("VAT") || string.toUpperCase().startsWith("NTR") || string.charAt(2) == ':' && list != null && list.size() > 0 && list.get(0) != null);
                    }
                }
                catch (CapiException capiException) {
                    bl = false;
                }
                if (!bl) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0020_INVALID_CERT_LEGAL_SEMANTIC, new Object[0]));
                }
            } else if (validationContextParameters.getSignerCertificate().getCert().getQcStatementSemanticIdentifier() != null && validationContextParameters.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.1")) {
                List<String> list = validationContextParameters.getSignerCertificate().getCert().getQcStatementNameRegistrationAuthorities();
                boolean bl = false;
                try {
                    String[] stringArray = validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] stringArray5 = validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.5");
                    String[] stringArray6 = validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] stringArray7 = null;
                    try {
                        stringArray7 = validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.42");
                    }
                    catch (CapiException capiException) {}
                    String[] stringArray8 = null;
                    try {
                        stringArray8 = validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.4");
                    }
                    catch (CapiException capiException) {}
                    String[] stringArray9 = null;
                    try {
                        stringArray9 = validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.65");
                    }
                    catch (CapiException capiException) {}
                    if (stringArray != null && stringArray.length == 1 && stringArray5 != null && stringArray5.length == 1 && stringArray6 != null && stringArray6.length == 1 && (stringArray7 != null && stringArray7.length == 1 && stringArray8 != null && stringArray8.length == 1 || stringArray9 != null && stringArray9.length == 1)) {
                        String string = stringArray5[0];
                        bl = string != null && string.length() > 6 && string.charAt(5) == '-' && (string.toUpperCase().startsWith("PAS") || string.toUpperCase().startsWith("IDC") || string.toUpperCase().startsWith("PNO") || string.toUpperCase().startsWith("VAT") || string.toUpperCase().startsWith("TIN") || string.charAt(2) == ':' && list != null && list.size() > 0 && list.get(0) != null);
                    }
                }
                catch (CapiException capiException) {
                    bl = false;
                }
                if (!bl) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0019_INVALID_CERT_NATURAL_SEMANTIC, new Object[0]));
                }
            } else if (validationContextParameters.getSignerCertificate().getCert().getQcStatementSemanticIdentifier() == null && validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore().before(Constants.DPCM_AGID_121_2019)) {
                String string;
                String[] stringArray;
                boolean bl = true;
                boolean bl2 = true;
                try {
                    stringArray = validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.5");
                    if (stringArray != null && stringArray.length == 1) {
                        bl = false;
                        string = stringArray[0];
                        if (string != null && string.length() > 6 && string.charAt(5) == '-' && (string.toUpperCase().startsWith("PAS") || string.toUpperCase().startsWith("IDC") || string.toUpperCase().startsWith("PNO") || string.toUpperCase().startsWith("TIN") || string.charAt(2) == ':')) {
                            bl = true;
                        }
                    }
                }
                catch (CapiException capiException) {
                    bl = false;
                }
                try {
                    stringArray = validationContextParameters.getSignerCertificate().getCert().getIssuerDNAttribute("2.5.4.97");
                    if (stringArray != null && stringArray.length == 1) {
                        bl2 = false;
                        string = stringArray[0];
                        if (string != null && string.length() > 6 && string.charAt(5) == '-' && (string.toUpperCase().startsWith("VAT") || string.toUpperCase().startsWith("NTR") || string.charAt(2) == ':')) {
                            bl2 = true;
                        }
                    }
                }
                catch (CapiException capiException) {
                    bl2 = false;
                }
                if (!bl2 || !bl) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0006_SERIALNUMBER_NOT_COMPLIANT, new Object[0]));
                }
            }
            boolean bl = false;
            try {
                if (validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.46") != null && validationContextParameters.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.46").length > 0) {
                    bl = true;
                }
            }
            catch (CapiException capiException) {}
            if (!bl) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0009_DNQUALIFIER_NOT_PRESENT, new Object[0]));
            }
        }
        return linkedList;
    }
}

