/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.dts.TimeStampToken;
import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.steps.SignatureValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.utils.LevelValidationUtils;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.signature.SignatureLevel;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSException;

@StepOrder(order=0)
public class StepValidationLevel
extends SignatureValidationStep {
    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        block31: {
            object = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            ((DateFormat)object).setTimeZone(validationContextParameters.getTimeZone());
            try {
                Object object2;
                if (validationContextParameters.getSignature() == null) break block31;
                if (validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                    if (validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignature().getSignatureDate() != null) {
                        object2 = new ValidationDate(((DateFormat)object).parse(validationContextParameters.getSignature().getSignatureDate()), DateSource.TIMESTAMP);
                        validationContextParameters.setCalculatedValidationDate((ValidationDate)object2);
                    } else if (validationContextParameters.getValidationDate() != null) {
                        ValidationContextParameters validationContextParameters2 = validationContextParameters;
                        validationContextParameters2.setCalculatedValidationDate(validationContextParameters2.getValidationDate());
                    } else {
                        object2 = new ValidationDate(new Date(), DateSource.SYSTEM);
                        validationContextParameters.setCalculatedValidationDate((ValidationDate)object2);
                    }
                } else if (validationContextParameters.getSignature().getTimeStampTokens() != null && validationContextParameters.getSignature().getTimeStampTokens().size() > 0) {
                    if (validationContextParameters.getSignature().getTimeStampTokens().get(0) != null) {
                        int n;
                        object2 = new TimeStampToken(validationContextParameters.getSignature().getTimeStampTokens().get(0).getSignatureInfo());
                        object = ((TimeStampToken)object2).getTSACert();
                        if (object == null) {
                            if (validationContextParameters.getValidationDate() == null) {
                                ValidationDate validationDate = new ValidationDate(new Date(), DateSource.SYSTEM);
                                validationContextParameters.setCalculatedValidationDate(validationDate);
                            } else {
                                ValidationContextParameters validationContextParameters3 = validationContextParameters;
                                validationContextParameters3.setCalculatedValidationDate(validationContextParameters3.getValidationDate());
                            }
                            return null;
                        }
                        X509Certificate x509Certificate = null;
                        try {
                            x509Certificate = validationContextParameters.getSignerCertificate().getCert().getInternalCert();
                        }
                        catch (Exception exception) {}
                        LinkedList<CertDBItem> linkedList = new LinkedList<CertDBItem>();
                        for (n = 0; n < validationContextParameters.getLstCert().size(); ++n) {
                            CertDBItem certDBItem = validationContextParameters.getCertDB().contains(validationContextParameters.getLstCert().get(n).getEncoded());
                            if (certDBItem == null) continue;
                            linkedList.add(certDBItem);
                        }
                        object = LevelValidationUtils.validateLevelByRefCRL(((TimeStampToken)object2).getDate(), x509Certificate, ((Certificate)object).getInternalCert(), validationContextParameters.getLstCert(), validationContextParameters.getLstOcsp(), validationContextParameters.getDoc().getCrls(), this.logger);
                        if (object != null) {
                            if (((LevelValidation)object).getSignerChain() != null) {
                                block7: for (n = 0; n < ((LevelValidation)object).getSignerChain().length; ++n) {
                                    for (int i = 0; i < linkedList.size(); ++i) {
                                        if (!((LevelValidation)object).getSignerChain()[n].getID().equals(((CertDBItem)linkedList.get(i)).getID())) continue;
                                        ((LevelValidation)object).getSignerChain()[n] = (CertDBItem)linkedList.get(i);
                                        continue block7;
                                    }
                                }
                            }
                            validationContextParameters.setLevelValidation((LevelValidation)object);
                            if (((LevelValidation)object).getLevel().compareTo(SignatureLevel.T) >= 0) {
                                n = 0;
                                if (validationContextParameters.getValidationDate() != null) {
                                    try {
                                        Date date = validationContextParameters.getValidationDate().getDate();
                                        object = ((TimeStampToken)object2).getDate();
                                        if (((Date)object).after(date)) {
                                            ValidationContextParameters validationContextParameters4 = validationContextParameters;
                                            validationContextParameters4.setCalculatedValidationDate(validationContextParameters4.getValidationDate());
                                            n = 1;
                                        }
                                    }
                                    catch (Exception exception) {
                                        this.logger.debug(exception.getMessage());
                                    }
                                }
                                if (n == 0) {
                                    ValidationDate validationDate = new ValidationDate(((TimeStampToken)object2).getDate(), DateSource.TIMESTAMP);
                                    validationContextParameters.setCalculatedValidationDate(validationDate);
                                }
                            }
                        }
                    }
                } else if (validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignerCertificate().isRsVerified()) {
                    object2 = validationContextParameters.getSignature().getSignerInfoData().getSignerInfo();
                    object = StepValidationLevel.a((SignerInfo)object2);
                    ValidationDate validationDate = new ValidationDate(object.getDate(), DateSource.RSVERIFIED);
                    validationContextParameters.setCalculatedValidationDate(validationDate);
                }
                if (validationContextParameters.getCalculatedValidationDate() == null) {
                    if (validationContextParameters.getValidationDate() == null) {
                        object2 = new ValidationDate(new Date(), DateSource.SYSTEM);
                        validationContextParameters.setCalculatedValidationDate((ValidationDate)object2);
                    } else {
                        ValidationContextParameters validationContextParameters5 = validationContextParameters;
                        validationContextParameters5.setCalculatedValidationDate(validationContextParameters5.getValidationDate());
                    }
                }
            }
            catch (Throwable throwable) {
                this.logger.error(throwable.getMessage());
            }
        }
        return null;
    }

    private static Time a(SignerInfo signerInfo) throws CMSException {
        ASN1Primitive aSN1Primitive;
        SignerInfo signerInfo2 = signerInfo;
        String string = "signing-time";
        signerInfo = CMSAttributes.signingTime;
        AttributeTable attributeTable = null;
        if (signerInfo2.getUnauthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo2.getUnauthenticatedAttributes());
        }
        if (attributeTable != null && attributeTable.getAll((ASN1ObjectIdentifier)signerInfo).size() > 0) {
            throw new CMSException("The " + string + " attribute MUST NOT be an unsigned attribute");
        }
        attributeTable = null;
        if (signerInfo2.getAuthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo2.getAuthenticatedAttributes());
        }
        if (attributeTable == null) {
            aSN1Primitive = null;
        } else {
            signerInfo = attributeTable.getAll((ASN1ObjectIdentifier)signerInfo);
            switch (signerInfo.size()) {
                case 0: {
                    aSN1Primitive = null;
                    break;
                }
                case 1: {
                    signerInfo = (Attribute)signerInfo.get(0);
                    signerInfo = signerInfo.getAttrValues();
                    if (signerInfo.size() != 1) {
                        throw new CMSException("A " + string + " attribute MUST have a single attribute value");
                    }
                    aSN1Primitive = signerInfo.getObjectAt(0).toASN1Primitive();
                    break;
                }
                default: {
                    throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + string + " attribute");
                }
            }
        }
        signerInfo = aSN1Primitive;
        if (aSN1Primitive == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)signerInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }
}

